/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.actf.util.resources.DefaultResourceLocator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class EclipseResourceLocator
extends DefaultResourceLocator {
    private List _bundles = new LinkedList();
    private File metadataDir;
    private Logger logger = Logger.getLogger("org.eclipse.actf.core");

    public void registerBundleName(String bundle) {
        this._bundles.add(bundle);
    }

    public InputStream getResourceAsStream(String id, ClassLoader loader) {
        return this.getResourceAsStream(id, null, null, loader);
    }

    public InputStream getResourceAsStream(String id, String base, String ext, ClassLoader loader) {
        return loader != null ? super.getResourceAsStream(id, base, ext, loader) : this.getResourceAsStream(id, base, ext);
    }

    private InputStream getResourceAsStream(String id, String base, String ext) {
        InputStream stream = null;
        ListIterator iter = this._bundles.listIterator();
        while (iter.hasNext() & stream == null) {
            String bundleName = (String)iter.next();
            stream = this.getResourceAsStream(id, base, ext, bundleName);
        }
        return stream;
    }

    public InputStream getResourceAsStream(String id, String base, String ext, String bundleName) {
        FileInputStream stream = null;
        String relativePath = this.getRelativePath(base, id, ext);
        IPath pathToFile = null;
        if (bundleName != null) {
            pathToFile = this.getPathToFile(bundleName, relativePath);
        }
        if (pathToFile != null) {
            try {
                stream = new FileInputStream(pathToFile.toFile());
                this.logger.log(Level.FINE, "Created stream for file - " + relativePath + " using bundle " + bundleName);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else {
            this.logger.log(Level.FINE, "unable to create stream for file - " + relativePath + " using bundle " + bundleName);
        }
        return stream;
    }

    private String getRelativePath(String base, String fileName, String ext) {
        String relativePath = null;
        if (base == null) {
            base = "resources";
        }
        relativePath = ext != null ? String.valueOf(base) + File.separator + fileName + "." + ext : String.valueOf(base) + File.separator + fileName + ".properties";
        return relativePath;
    }

    public URL getResource(String name) {
        URL result = super.getResource(name);
        if (result == null) {
            IPath ipath = null;
            ListIterator iter = this._bundles.listIterator();
            while (iter.hasNext() & ipath == null) {
                String bundleName = (String)iter.next();
                ipath = bundleName.equals(name) ? this.getPathToBundle(name) : this.getPathToFile(bundleName, name);
            }
            if (ipath == null) {
                ipath = this.getPathToBundle(name);
            }
            if (ipath != null) {
                try {
                    result = ipath.toFile().toURL();
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        if (result == null) {
            File sourceLoc = new File(name);
            if (name.endsWith(".xml")) {
                this.metadataDir = sourceLoc.getParentFile();
            } else {
                String path = this.metadataDir.getAbsolutePath();
                sourceLoc = new File(String.valueOf(path) + "/" + name);
            }
            try {
                result = sourceLoc.toURL();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public String getPath(String name) {
        String result = null;
        URL url = this.getResource(name);
        result = this.convertToFileURL(url);
        return result;
    }

    public String[] getPaths(String name) {
        String[] result = null;
        URL[] urls = this.getResources(name);
        if (urls != null) {
            result = new String[urls.length];
            int i = 0;
            while (i < urls.length) {
                result[i] = this.convertToFileURL(urls[i]);
                ++i;
            }
        }
        return result;
    }

    private String convertToFileURL(URL url) {
        String result = null;
        if (url != null) {
            try {
                URL fileUrl = FileLocator.toFileURL((URL)url);
                result = fileUrl.getFile().substring(1);
            }
            catch (IOException iOException) {
                result = null;
            }
        }
        return result;
    }

    public IPath getPathToFile(String bundleName, String relativePath) {
        Bundle bundle;
        Path absolutePath = null;
        if (bundleName != null && bundleName.length() > 0 && (bundle = Platform.getBundle((String)bundleName)) != null) {
            Path relativeFilePath = new Path(relativePath);
            URL pathUrl = Platform.find((Bundle)bundle, (IPath)relativeFilePath);
            if (pathUrl == null) {
                relativeFilePath = new Path("resources/" + relativePath);
                pathUrl = Platform.find((Bundle)bundle, (IPath)relativeFilePath);
            }
            if (pathUrl != null) {
                try {
                    pathUrl = Platform.resolve((URL)pathUrl);
                    absolutePath = new Path(new File(pathUrl.getFile()).getAbsolutePath());
                    this.logger.log(Level.FINE, "getPathToFile(), absolute path to " + relativePath + " = " + absolutePath.toString());
                }
                catch (IOException ioe) {
                    this.logger.log(Level.WARNING, ioe.getMessage(), ioe);
                }
            }
        }
        return absolutePath;
    }

    public IPath getPathToBundle(String bundleName) {
        Bundle bundle;
        Path absolutePath = null;
        if (bundleName != null && bundleName.length() > 0 && (bundle = Platform.getBundle((String)bundleName)) != null) {
            try {
                String bundleLoc = FileLocator.resolve((URL)bundle.getEntry("/")).getFile();
                if (bundleLoc.startsWith("file:")) {
                    bundleLoc = bundleLoc.substring("file:".length());
                }
                if (bundleLoc.startsWith("/") && Platform.getOS().equals("win32")) {
                    bundleLoc = bundleLoc.substring(1);
                }
                if (bundleLoc.endsWith("jar!/")) {
                    absolutePath = new Path(bundleLoc.substring(0, bundleLoc.length() - 2));
                } else if (bundleLoc.endsWith("/")) {
                    absolutePath = new Path(bundleLoc.substring(0, bundleLoc.length() - 1));
                }
                this.logger.log(Level.FINE, "getPathToBundle(), path to bundle " + bundleName + " = " + absolutePath.toString());
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "Could not retrieve location for a bundle", e);
            }
        }
        return absolutePath;
    }
}

