/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.actf.util.httpproxy.core.IBufferRange;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPHeader;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessageBuffer;

public final class HeaderInBuffer
extends HTTPHeader {
    private HTTPMessageBuffer fBuffer;
    private IBufferRange fName = null;
    private IBufferRange fValue = null;
    private byte[] fReplacedValue = null;

    public void init(HTTPMessageBuffer buffer, IBufferRange name, IBufferRange value) {
        this.fBuffer = buffer;
        this.fName = name;
        this.fValue = value;
        this.fReplacedValue = null;
    }

    public void reset() {
        this.fName = null;
        this.fValue = null;
        this.fReplacedValue = null;
    }

    public IBufferRange getNameAsBufferRange() {
        return this.fName;
    }

    public IBufferRange getValueAsBufferRange() {
        return this.fValue;
    }

    public boolean isFieldNameEqualsTo(byte[] name) {
        return this.fBuffer.equalsIgnoreCase(this.fName, name);
    }

    public boolean isFieldValueEqualsTo(byte[] value) {
        return this.fBuffer.equals(this.fValue, value);
    }

    public byte[] getName() {
        return this.fBuffer.getAsBytes(this.fName);
    }

    public byte[] getValue() {
        return this.fBuffer.getAsBytes(this.fValue);
    }

    public void setValue(byte[] value) {
        this.fValue = null;
        this.fReplacedValue = value;
    }

    protected void write(OutputStream out) throws IOException {
        this.fBuffer.writeTo(out, this.fName);
        this.writeHeaderSeparator(out);
        if (this.fValue != null) {
            this.fBuffer.writeTo(out, this.fValue);
        } else if (this.fReplacedValue != null) {
            out.write(this.fReplacedValue);
        }
    }
}

