/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.core.runtime;

import java.lang.reflect.Method;
import org.eclipse.actf.core.runtime.IRuntimeContext;

public class RuntimeContextFactory {
    public static final String RUNTIME_CONTEXT_CLASSNAME_KEY = "org.eclipse.actf.core.runtimeContext";
    private static RuntimeContextFactory factoryInstance;
    private IRuntimeContext contextInstance;

    protected RuntimeContextFactory() {
    }

    public static RuntimeContextFactory getInstance() {
        if (factoryInstance == null) {
            factoryInstance = new RuntimeContextFactory();
        }
        return factoryInstance;
    }

    public IRuntimeContext getRuntimeContext() {
        if (this.contextInstance == null) {
            this.contextInstance = this.createRuntimeContext();
        }
        return this.contextInstance;
    }

    private IRuntimeContext createRuntimeContext() {
        String string = "org.eclipse.actf.core.runtime.StandaloneRuntimeContext";
        String string2 = System.getProperty(RUNTIME_CONTEXT_CLASSNAME_KEY);
        IRuntimeContext iRuntimeContext = null;
        if (string2 != null && string2.length() > 0) {
            string = string2;
        } else {
            try {
                boolean bl;
                Class<?> clazz = Class.forName("org.eclipse.core.runtime.Platform");
                Method method = clazz.getMethod("isRunning", null);
                if (method != null && (bl = ((Boolean)method.invoke(null, null)).booleanValue())) {
                    string = "org.eclipse.actf.core.runtime.EclipseRuntimeContext";
                }
            }
            catch (Exception exception) {}
        }
        try {
            iRuntimeContext = (IRuntimeContext)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return iRuntimeContext;
    }
}

