/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.voicebrowser;

import org.eclipse.actf.visualization.engines.voicebrowser.IPacket;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.PacketCollection;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomUtil {
    protected static int tab;
    protected static int cnt;
    private static NodeList FormChildren;

    static {
        FormChildren = null;
    }

    public DomUtil() {
        tab = 0;
        cnt = 0;
        FormChildren = null;
    }

    public static void recursiveWalk(Node node, int num) {
        DomUtil.getNodeInfo(node, num);
        ++tab;
        cnt = 0;
        Node child = node.getFirstChild();
        while (child != null) {
            DomUtil.recursiveWalk(child, cnt);
            child = child.getNextSibling();
            ++cnt;
        }
        --tab;
    }

    public static String getString(Node node) {
        String str = null;
        if (node != null) {
            str = "[" + node.getNodeName() + "] [" + node.getNodeValue() + "]";
        }
        return str;
    }

    private static void getNodeInfo(Node node, int num) {
        DomUtil.tabbing();
        String nodeName = node.getNodeName();
        if (node.getNodeType() == 1) {
            NamedNodeMap attList = ((Element)node).getAttributes();
            if (attList.getLength() > 0) {
                String str = "<" + nodeName + ":" + node.getNodeValue();
                int i = 0;
                while (i < attList.getLength()) {
                    Attr att = (Attr)attList.item(i);
                    str = String.valueOf(str) + "," + att.getName() + "=" + att.getValue();
                    ++i;
                }
                str = String.valueOf(str) + ">";
                System.out.println(str);
            } else {
                System.out.println("<" + nodeName + ":" + node.getNodeValue() + ">");
            }
        } else {
            System.out.println("<" + nodeName + ":" + node.getNodeValue() + ">");
        }
    }

    private static void tabbing() {
        int i = 0;
        while (i < tab) {
            System.out.print("\t");
            ++i;
        }
    }

    public static boolean isNameAttr(Node node) {
        NamedNodeMap attrs;
        Node altNode;
        return node != null && node.getNodeType() == 1 && node.getNodeName().toLowerCase().equals("a") && (altNode = (attrs = node.getAttributes()).getNamedItem("name")) != null;
    }

    public static void dumpPC(PacketCollection pc) {
        if (pc == null) {
            return;
        }
        if (pc.size() > 0) {
            int i = 0;
            while (i < pc.size()) {
                IPacket p = (IPacket)pc.get(i);
                String str = p.getText();
                System.out.println("[" + i + "] <" + str + ">");
                ++i;
            }
        }
    }

    public static void setFormList(Node node) {
        if (node != null) {
            FormChildren = ((Element)node).getElementsByTagName("form");
        }
    }

    public static int getFormNum(Element element) {
        if (FormChildren != null && FormChildren.getLength() > 0) {
            int i = 0;
            while (i < FormChildren.getLength()) {
                if (element == (Element)FormChildren.item(i)) {
                    return i + 1;
                }
                ++i;
            }
        }
        return 0;
    }
}

