/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.voicebrowser;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.eclipse.actf.ai.tts.ITTSEngine;
import org.eclipse.actf.visualization.engines.voicebrowser.CursorListener;
import org.eclipse.actf.visualization.engines.voicebrowser.CursorMovedEvent;
import org.eclipse.actf.visualization.engines.voicebrowser.IPacket;
import org.eclipse.actf.visualization.engines.voicebrowser.IVoiceBrowserController;
import org.eclipse.actf.visualization.engines.voicebrowser.IVoiceBrowserView;
import org.eclipse.actf.visualization.engines.voicebrowser.SelectionObserver;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.CurrentCursor;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.CursorMovedEventImpl;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.DomUtil;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.DummyTTSEngine;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.JWATCore;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.MessageCollection;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.OutLoud;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.PacketCollection;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JWATControllerImpl
implements IVoiceBrowserController {
    private static final String BACKSLASH_N = "\n";
    private static List<IVoiceBrowserView> views = new ArrayList<IVoiceBrowserView>();
    private static List<SelectionObserver> selObservers = new ArrayList<SelectionObserver>();
    private static MessageCollection mc = null;
    private JWATCore core = new JWATCore();
    private CurrentCursor ccursor = new CurrentCursor();
    private ITTSEngine speech = new DummyTTSEngine();
    private Vector<CursorListener> cursorListeners = new Vector();

    public JWATControllerImpl() {
        this.setMode(1);
    }

    public JWATControllerImpl(int mode) {
        this.setMode(mode);
    }

    public void setMode(int mode) {
        this.setMode(mode, "");
    }

    public void setMode(int mode, String xmlpath) {
        mc = this.core.setJwatMode(mode, xmlpath);
        this.doTopOfPage();
        String s = String.valueOf(OutLoud.name) + " mode";
        this.speech.stop();
        this.speech.speak(s, 1, -1);
    }

    public void setDocument(Document document) {
        this.setDocument(document, null, null);
    }

    public void setDocument(Document document, String uri, String anchorName) {
        NodeList children;
        Node node = document;
        JWATCore.setUriPrefix(uri);
        if (node != null && (children = document.getElementsByTagName("body")) != null && children.getLength() > 0) {
            node = children.item(0);
            DomUtil.setFormList(node);
            this.ccursor.setPc(this.core.getPacketCollection(node));
            this.ccursor.setOwnerDocumentNode(document);
            if (this.ccursor.getPc() != null && this.ccursor.getPc().size() > 0 && this.ccursor.getCurPos() == 0) {
                int pos = 0;
                if (anchorName != null && anchorName.length() > 0) {
                    pos = this.core.getAnchorPosition(anchorName, this.ccursor.getTopNode(), this.ccursor.getPc());
                    this.ccursor.setCurPos(pos);
                    this.doCurLine();
                } else {
                    pos = this.core.getNodePosition(node, this.ccursor.getPc());
                    this.ccursor.setCurPos(pos);
                }
            }
        }
    }

    public void setNode(Node node) {
        this.setNode(node, null, null);
    }

    public void setNode(Node node, String uri, String anchorName) {
        JWATCore.setUriPrefix(uri);
        if (node != null) {
            Document ownerNode = node.getOwnerDocument();
            if (ownerNode != null && (this.ccursor.getPc() == null || this.ccursor.getPc().size() == 0 || this.ccursor.getOwnerDocumentNode() != ownerNode)) {
                this.setDocument(ownerNode);
            }
            int pos = 0;
            if (anchorName != null && anchorName.length() > 0) {
                pos = this.core.getAnchorPosition(anchorName, this.ccursor.getTopNode(), this.ccursor.getPc());
                this.ccursor.setCurPos(pos);
                this.doCurLine();
            } else {
                pos = this.core.getNodePosition(node, this.ccursor.getPc());
                this.ccursor.setCurPos(pos);
            }
        }
    }

    public String doCommand(int type) {
        int prevPos = this.ccursor.getCurPos();
        switch (type) {
            case 1: {
                this.doPrevLine();
                break;
            }
            case 2: {
                this.doCurLine();
                break;
            }
            case 3: {
                this.doNextLine();
                break;
            }
            case 4: {
                this.doPrevLink();
                break;
            }
            case 5: {
                this.doCurLink();
                break;
            }
            case 6: {
                this.doNextLink();
                break;
            }
            case 7: {
                int i = 0;
                while (i < 10) {
                    this.doPrevLine();
                    ++i;
                }
                break;
            }
            case 8: {
                int i = 0;
                while (i < 10) {
                    this.doNextLine();
                    ++i;
                }
                break;
            }
            case 9: {
                this.doCurLine();
                break;
            }
            case 10: {
                this.doTopOfPage();
                break;
            }
            case 11: {
                this.doBottomOfPage();
                break;
            }
            case 14: {
                String s = this.doLinkJump();
                if (s == null || s.length() <= 0) break;
                return s;
            }
            case 12: {
                this.doPlay();
                break;
            }
            case 13: {
                this.doStop();
            }
        }
        if (this.ccursor.getCurPos() != prevPos) {
            this.sendCursorEvent(new CursorMovedEventImpl(this, this.ccursor.getCurPos()));
        }
        return null;
    }

    private void doCurLine() {
        try {
            PacketCollection lpc;
            PacketCollection pc = this.ccursor.getPc();
            if (pc != null && pc.size() > 0 && (lpc = this.getCurLine(true)) != null && lpc.size() > 0) {
                this.speakWithVisual(lpc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doPrevLine() {
        try {
            PacketCollection pc = this.ccursor.getPc();
            if (pc != null && pc.size() > 0) {
                PacketCollection lpc = this.getPrevLine(true);
                if (lpc != null && lpc.size() > 0) {
                    this.speakWithVisual(lpc);
                } else {
                    this.speech.stop();
                    if (OutLoud.topofpage != null && OutLoud.topofpage.length() > 0) {
                        this.speech.speak(OutLoud.topofpage, 1, -1);
                    } else {
                        this.speech.speak("Top of page.", 1, -1);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doNextLine() {
        try {
            PacketCollection pc = this.ccursor.getPc();
            if (pc != null && pc.size() > 0) {
                PacketCollection lpc = this.getNextLine(true);
                if (lpc != null && lpc.size() > 0) {
                    this.speakWithVisual(lpc);
                } else {
                    this.speech.stop();
                    if (OutLoud.endofpage != null && OutLoud.endofpage.length() > 0) {
                        this.speech.speak(OutLoud.endofpage, 1, -1);
                    } else {
                        this.speech.speak("End of page.", 1, -1);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doCurLink() {
        try {
            PacketCollection pc = this.ccursor.getPc();
            if (pc != null && pc.size() > 0) {
                PacketCollection lpc = this.getCurLink();
                if (lpc != null && lpc.size() > 0) {
                    this.speakWithVisual(lpc);
                } else {
                    this.speech.stop();
                    if (OutLoud.nocurlink != null && OutLoud.nocurlink.length() > 0) {
                        this.speech.speak(OutLoud.nocurlink, 1, -1);
                    } else {
                        this.speech.speak("No Current Link.", 1, -1);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doPrevLink() {
        try {
            PacketCollection pc = this.ccursor.getPc();
            if (pc != null && pc.size() > 0) {
                PacketCollection lpc = this.getPrevLink();
                if (lpc != null && lpc.size() > 0) {
                    this.speakWithVisual(lpc);
                } else {
                    this.speech.stop();
                    if (OutLoud.noprevlink != null && OutLoud.noprevlink.length() > 0) {
                        this.speech.speak(OutLoud.noprevlink, 1, -1);
                    } else {
                        this.speech.speak("No Previous Link.", 1, -1);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doNextLink() {
        try {
            PacketCollection pc = this.ccursor.getPc();
            if (pc != null && pc.size() > 0) {
                PacketCollection lpc = this.getNextLink();
                if (lpc != null && lpc.size() > 0) {
                    this.speakWithVisual(lpc);
                } else {
                    this.speech.stop();
                    if (OutLoud.nonextlink != null && OutLoud.nonextlink.length() > 0) {
                        this.speech.speak(OutLoud.nonextlink, 1, -1);
                    } else {
                        this.speech.speak("No Next Link.", 1, -1);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doTopOfPage() {
        try {
            PacketCollection pc = this.ccursor.getPc();
            if (pc != null && pc.size() > 0) {
                PacketCollection tpc = this.getTopLine();
                if (tpc != null && tpc.size() > 0) {
                    this.speakWithVisual(tpc);
                } else {
                    this.speech.stop();
                    if (OutLoud.topofpage != null && OutLoud.topofpage.length() > 0) {
                        this.speech.speak(OutLoud.topofpage, 1, -1);
                    } else {
                        this.speech.speak("Top of page.", 1, -1);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doBottomOfPage() {
        try {
            PacketCollection pc = this.ccursor.getPc();
            if (pc != null && pc.size() > 0) {
                PacketCollection bpc = this.getBottomLine();
                if (bpc != null && bpc.size() > 0) {
                    this.speakWithVisual(bpc);
                } else {
                    this.speech.stop();
                    if (OutLoud.endofpage != null && OutLoud.endofpage.length() > 0) {
                        this.speech.speak(OutLoud.endofpage, 1, -1);
                    } else {
                        this.speech.speak("End of page.", 1, -1);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doPlay() {
        try {
            PacketCollection pc = this.ccursor.getPc();
            if (pc != null && pc.size() > 0) {
                String str = this.render(pc, this.ccursor.getCurPos());
                this.speech.stop();
                this.speech.speak(str, 1, -1);
                this.drawText(str);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doStop() {
        this.speech.stop();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String doLinkJump() {
        try {
            PacketCollection pc = this.ccursor.getPc();
            if (pc != null) {
                int curpos = this.ccursor.getCurPos();
                Node node = null;
                node = ((IPacket)pc.get(curpos)).getNode();
                if (!pc.isLinkTag(curpos) && node != null) {
                    boolean link = false;
                    for (Node pnode = node.getParentNode(); !(pnode == null || pnode.getNodeType() == 1 && pnode.getNodeName().toLowerCase().equals("body")); pnode = pnode.getParentNode()) {
                        if (pnode.getNodeType() != 1 || !pnode.getNodeName().toLowerCase().equals("a")) continue;
                        node = pnode;
                        link = true;
                        break;
                    }
                    if (!link) {
                        this.speech.stop();
                        if (OutLoud.notonalink != null && OutLoud.notonalink.length() > 0) {
                            this.speech.speak(OutLoud.notonalink, 1, -1);
                        } else {
                            this.speech.speak("Not on a link.", 1, -1);
                        }
                        return null;
                    }
                }
                if (this.ccursor.getTopNode() != null) {
                    Node targetNode = null;
                    String href = this.core.getHrefString(node);
                    if (href != null && href.length() > 0) {
                        if (href.charAt(0) == '#') {
                            targetNode = this.core.getTargetNode(node, this.ccursor.getTopNode());
                            int targetpos = curpos;
                            if (targetNode != null) {
                                targetpos = this.core.getNodePosition(targetNode, this.ccursor.getPc());
                            }
                            if (curpos != targetpos) {
                                boolean hasstr = false;
                                int pos = targetpos;
                                while (pos < pc.size()) {
                                    String str = ((IPacket)pc.get(pos)).getText();
                                    if (str != null && str.length() > 0) {
                                        hasstr = true;
                                        break;
                                    }
                                    ++pos;
                                }
                                if (hasstr) {
                                    this.ccursor.setCurPos(pos);
                                    this.doCurLine();
                                } else {
                                    this.ccursor.setCurPos(curpos);
                                    this.speech.stop();
                                    if (OutLoud.nostring != null && OutLoud.nostring.length() > 0) {
                                        this.speech.speak(OutLoud.nostring, 1, -1);
                                    } else {
                                        this.speech.speak("Target has no strings.", 1, -1);
                                    }
                                }
                            }
                            return null;
                        }
                        if (!href.toLowerCase().startsWith("javascript:")) {
                            return href;
                        }
                    }
                }
            }
            this.speech.stop();
            if (OutLoud.notonalink != null && OutLoud.notonalink.length() > 0) {
                this.speech.speak(OutLoud.notonalink, 1, -1);
            } else {
                this.speech.speak("Not on a link.", 1, -1);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private PacketCollection getPrevLink() {
        PacketCollection pc = this.ccursor.getPc();
        PacketCollection lpc = new PacketCollection();
        if (pc != null && pc.size() > 0) {
            int curpos;
            int newpos = curpos = this.ccursor.getCurPos();
            boolean hasstr = false;
            if (curpos > 0) {
                int i = curpos - 1;
                while (i >= 0) {
                    if (i < pc.size()) {
                        String str = ((IPacket)pc.get(i)).getText();
                        if (str != null && str.length() > 0 && pc.isInsideAnchor(i)) {
                            hasstr = true;
                        }
                        if (pc.isLinkTag(i) && hasstr) {
                            newpos = i;
                            break;
                        }
                        if (pc.isLinkTag(i)) {
                            hasstr = false;
                        }
                    }
                    --i;
                }
            }
            if (curpos != newpos) {
                this.ccursor.setCurPos(newpos);
                int endpos = this.getEndPositionOfCurLine();
                if (newpos == endpos && endpos < pc.size() - 1) {
                    ++endpos;
                }
                lpc.addAll(pc.subList(newpos, endpos));
                if (lpc.size() > 0) {
                    int linkcnt = 0;
                    int j = 0;
                    while (j < lpc.size()) {
                        if (lpc.isLinkTag(j)) {
                            ++linkcnt;
                        }
                        ++j;
                    }
                    if (linkcnt > 1) {
                        lpc = this.getCurLinkPC(true);
                    } else if (linkcnt == 0) {
                        lpc = null;
                    }
                }
            }
        }
        return lpc;
    }

    private PacketCollection getCurLink() {
        PacketCollection pc = this.ccursor.getPc();
        PacketCollection lpc = null;
        if (pc != null && pc.size() > 0 && (lpc = this.getCurLine(false)) != null && lpc.size() > 0) {
            int linkcnt = 0;
            int j = 0;
            while (j < lpc.size()) {
                if (lpc.isLinkTag(j)) {
                    ++linkcnt;
                }
                ++j;
            }
            if (linkcnt > 1) {
                lpc = this.getCurLinkPC(true);
            } else if (linkcnt == 0) {
                lpc = null;
            }
        }
        return lpc;
    }

    private PacketCollection getNextLink() {
        PacketCollection pc = this.ccursor.getPc();
        PacketCollection lpc = new PacketCollection();
        if (pc != null && pc.size() > 0) {
            int curpos;
            int newpos = curpos = this.ccursor.getCurPos();
            boolean found = false;
            int i = curpos + 1;
            while (i < pc.size()) {
                if (pc.isLinkTag(i)) {
                    int k = i;
                    if (pc.isInsideAnchor(i)) {
                        k = i;
                        while (k < pc.size()) {
                            if (!pc.isInsideAnchor(k)) break;
                            ++k;
                        }
                    }
                    int j = i;
                    while (j <= k) {
                        String str = ((IPacket)pc.get(j)).getText();
                        if (str != null && str.length() > 0) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (found) {
                        newpos = i;
                        break;
                    }
                }
                ++i;
            }
            if (curpos != newpos) {
                this.ccursor.setCurPos(newpos);
                int endpos = this.getEndPositionOfCurLine();
                if (newpos == endpos && endpos < pc.size() - 1) {
                    ++endpos;
                }
                lpc.addAll(pc.subList(newpos, endpos));
                if (lpc.size() > 0) {
                    int linkcnt = 0;
                    int j = 0;
                    while (j < lpc.size()) {
                        if (lpc.isLinkTag(j)) {
                            ++linkcnt;
                        }
                        ++j;
                    }
                    if (linkcnt > 1) {
                        lpc = this.getCurLinkPC(true);
                        return lpc;
                    }
                    if (linkcnt == 0) {
                        lpc = null;
                    }
                }
            }
        }
        return lpc;
    }

    private PacketCollection getCurLine(boolean setpos) {
        PacketCollection newPc = new PacketCollection();
        PacketCollection pc = this.ccursor.getPc();
        if (pc != null && pc.size() > 0) {
            int startIndex = 0;
            int endIndex = 0;
            int pos = 0;
            int headPos = 0;
            int i = 0;
            int j = 0;
            pos = this.ccursor.getCurPos();
            headPos = pc.getTopNodePosition();
            startIndex = pos;
            if (headPos >= pos) {
                startIndex = headPos;
            } else {
                if (pos > 0) {
                    if (pc.isLinkTag(pos) && pc.isLinkTag(pos - 1)) {
                        i = pos - 1;
                    } else {
                        i = pos - 1;
                        while (i >= 0) {
                            if (pc.isLineDelimiter(i)) break;
                            --i;
                        }
                    }
                }
                j = i + 1;
                while (j < pc.size()) {
                    String str = ((IPacket)pc.get(j)).getText();
                    if (str != null && str.length() > 0) {
                        pos = j;
                        break;
                    }
                    ++j;
                }
                if (pc.isInsideAnchor(j)) {
                    int k = j;
                    while (k >= 0) {
                        if (pc.isLinkTag(k)) {
                            startIndex = k;
                            break;
                        }
                        --k;
                    }
                } else {
                    startIndex = j;
                }
                if (pos < j) {
                    startIndex = pos;
                }
            }
            endIndex = this.searchEndPosition(startIndex);
            if (startIndex == endIndex) {
                ++endIndex;
            }
            if (setpos) {
                this.ccursor.setCurPos(startIndex);
            }
            newPc.addAll(pc.subList(startIndex, endIndex));
        }
        return newPc;
    }

    private int getEndPositionOfCurLine() {
        int endIndex = 0;
        PacketCollection pc = this.ccursor.getPc();
        if (pc != null && pc.size() > 0) {
            int startIndex = 0;
            int pos = 0;
            int headPos = 0;
            int i = 0;
            int j = 0;
            pos = this.ccursor.getCurPos();
            headPos = pc.getTopNodePosition();
            startIndex = pos;
            if (headPos >= pos) {
                startIndex = headPos;
            } else {
                if (pos > 0) {
                    if (pc.isLinkTag(pos) && pc.isLinkTag(pos - 1)) {
                        i = pos - 1;
                    } else {
                        i = pos - 1;
                        while (i >= 0) {
                            if (pc.isLineDelimiter(i)) break;
                            --i;
                        }
                    }
                }
                j = i + 1;
                while (j < pc.size()) {
                    String str = ((IPacket)pc.get(j)).getText();
                    if (str != null && str.length() > 0) {
                        pos = j;
                        break;
                    }
                    ++j;
                }
                if (pc.isInsideAnchor(j)) {
                    int k = j;
                    while (k >= 0) {
                        if (pc.isLinkTag(k)) {
                            startIndex = k;
                            break;
                        }
                        --k;
                    }
                } else {
                    startIndex = j;
                }
                if (pos < j) {
                    startIndex = pos;
                }
            }
            endIndex = this.searchEndPosition(startIndex);
            if (startIndex == endIndex) {
                ++endIndex;
            }
        }
        return endIndex;
    }

    private int searchEndPosition(int startPos) {
        int endPos = startPos;
        PacketCollection pc = this.ccursor.getPc();
        if (pc != null && pc.size() > 0) {
            if (pc.isStartSelect(startPos) || pc.isLinkTag(startPos) && startPos + 1 < pc.size() && pc.isLinkTag(startPos + 1)) {
                endPos = startPos + 1;
            } else {
                boolean insideForm = pc.isInsideForm(startPos);
                while (startPos < pc.size() && !pc.isLineDelimiter(startPos)) {
                    if (insideForm && !pc.isInsideForm(startPos)) break;
                    ++startPos;
                }
                endPos = startPos;
            }
        }
        return endPos;
    }

    private PacketCollection getPrevLine(boolean setpos) {
        PacketCollection newPc = new PacketCollection();
        PacketCollection pc = this.ccursor.getPc();
        if (pc != null && pc.size() > 0) {
            int startIndex = 0;
            int endIndex = 0;
            int pos = 0;
            int headPos = 0;
            pos = this.ccursor.getCurPos();
            headPos = pc.getTopNodePosition();
            if (headPos >= pos) {
                this.ccursor.setCurPos(headPos);
                return null;
            }
            int curpos = this.ccursor.getCurPos();
            boolean strfound = false;
            if (curpos - 1 >= 0) {
                int i = curpos - 1;
                while (i >= 0) {
                    String str = ((IPacket)pc.get(i)).getText();
                    if (!strfound && str != null && str.length() > 0) {
                        strfound = true;
                        if (strfound && pc.isLineDelimiter(i)) {
                            pos = i;
                            break;
                        }
                    } else if (strfound && pc.isLineDelimiter(i)) {
                        pos = i + 1;
                        if (!pc.isLinkTag(pos) || !pc.isLinkTag(pos + 1)) break;
                        ++pos;
                        break;
                    }
                    --i;
                }
            }
            if ((startIndex = pos == curpos ? pos - 1 : pos) == (endIndex = this.searchEndPosition(startIndex))) {
                ++endIndex;
            }
            if (setpos) {
                this.ccursor.setCurPos(startIndex);
            }
            newPc.addAll(pc.subList(startIndex, endIndex));
        }
        return newPc;
    }

    /*
     * Unable to fully structure code
     */
    private PacketCollection getNextLine(boolean setpos) {
        block7: {
            block8: {
                newPc = new PacketCollection();
                pc = this.ccursor.getPc();
                if (pc == null || pc.size() <= 0) break block7;
                startIndex = 0;
                endIndex = 0;
                pos = 0;
                curpos = this.ccursor.getCurPos();
                if (curpos >= (bottompos = pc.getBottomNodePosition())) {
                    return null;
                }
                i = curpos;
                insideForm = pc.isInsideForm(i);
                if (!pc.isStartSelect(i) && (!pc.isLinkTag(i) || i + 1 >= pc.size() || !pc.isLinkTag(i + 1))) ** GOTO lbl17
                pos = i + 1;
                break block8;
                while (!(insideForm && !pc.isInsideForm(i) || pc.isStartSelect(i))) {
                    ++i;
lbl17:
                    // 2 sources

                    if (i < pc.size() && !pc.isLineDelimiter(i)) continue;
                }
                pos = insideForm != false && pc.isInsideForm(i) == false || pc.isStartSelect(i) != false ? i : i + 1;
            }
            if (pos <= pc.size()) {
                i = pos;
                while (i < pc.size()) {
                    str = ((IPacket)pc.get(i)).getText();
                    if (str != null && str.length() > 0) {
                        pos = i;
                        break;
                    }
                    ++i;
                }
            }
            if ((startIndex = pos) == (endIndex = this.searchEndPosition(startIndex))) {
                ++endIndex;
            }
            if (setpos) {
                this.ccursor.setCurPos(startIndex);
            }
            newPc.addAll(pc.subList(startIndex, endIndex));
        }
        return newPc;
    }

    private PacketCollection getTopLine() {
        PacketCollection newPc = new PacketCollection();
        PacketCollection pc = this.ccursor.getPc();
        if (pc != null && pc.size() > 0) {
            int startIndex = 0;
            int endIndex = 0;
            int i = startIndex = pc.getTopNodePosition();
            while (i < pc.size() && !pc.isLineDelimiter(i)) {
                ++i;
            }
            endIndex = i;
            if (startIndex == endIndex) {
                ++endIndex;
            }
            this.ccursor.setCurPos(startIndex);
            newPc.addAll(pc.subList(startIndex, endIndex));
        }
        return newPc;
    }

    private PacketCollection getBottomLine() {
        PacketCollection newPc = new PacketCollection();
        PacketCollection pc = this.ccursor.getPc();
        if (pc != null && pc.size() > 0) {
            int startIndex = 0;
            int endIndex = 0;
            int pos = 0;
            pos = pc.getBottomNodePosition();
            int i = pos;
            if (!pc.isLineDelimiter(i)) {
                while (i < pc.size() && pc.isLineDelimiter(i)) {
                    ++i;
                }
            }
            i = startIndex = i;
            while (i < pc.size() - 1 && !pc.isLineDelimiter(i)) {
                ++i;
            }
            endIndex = i;
            if (startIndex == endIndex) {
                ++endIndex;
            }
            this.ccursor.setCurPos(startIndex);
            newPc.addAll(pc.subList(startIndex, endIndex));
        }
        return newPc;
    }

    private PacketCollection getCurLinkPC(boolean setpos) {
        PacketCollection newPc = new PacketCollection();
        PacketCollection pc = this.ccursor.getPc();
        if (pc != null && pc.size() > 0) {
            int startIndex = 0;
            int endIndex = 0;
            int i = startIndex = this.ccursor.getCurPos();
            while (i < pc.size()) {
                if (pc.isLinkTag(i)) {
                    startIndex = i;
                    break;
                }
                ++i;
            }
            endIndex = startIndex + 1;
            if (pc.isInsideAnchor(startIndex)) {
                i = startIndex;
                while (i < pc.size()) {
                    if (!pc.isInsideAnchor(i)) {
                        endIndex = i;
                        break;
                    }
                    ++i;
                }
            }
            if (setpos) {
                this.ccursor.setCurPos(startIndex);
            }
            newPc.addAll(pc.subList(startIndex, endIndex));
        }
        return newPc;
    }

    private void setRange(Node firstNode, Node lastNode) {
        if (firstNode != null && lastNode != null) {
            int numSelObservers = selObservers.size();
            int i = 0;
            while (i < numSelObservers) {
                selObservers.get(i).setRange(firstNode, lastNode);
                ++i;
            }
        }
    }

    private void speakWithVisual(PacketCollection pc) {
        String str;
        Node lastNode;
        Node firstNode;
        try {
            firstNode = pc.getFirstNode();
            lastNode = pc.getLastNode();
            str = this.render(pc);
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.speech.stop();
            if (OutLoud.endofpage != null && OutLoud.endofpage.length() > 0) {
                this.speech.speak(OutLoud.endofpage, 1, -1);
            } else {
                this.speech.speak("End of page.", 1, -1);
            }
            return;
        }
        if (str != null && str.length() > 0) {
            this.speech.stop();
            this.speech.speak(str, 1, -1);
            this.setRange(firstNode, lastNode);
            this.drawText(str);
        }
    }

    public String render(PacketCollection pc) {
        int startPos = 0;
        try {
            int size = pc.size();
            StringBuffer result = new StringBuffer();
            int i = startPos;
            while (i < size) {
                char lastChar;
                IPacket p = (IPacket)pc.get(i);
                String str = p.getText();
                if (str != null && str.length() > 0) {
                    if (result.length() > 0 && (lastChar = result.charAt(result.length() - 1)) != '\n' && p.getContext().isStartSelect()) {
                        result.append(BACKSLASH_N);
                    }
                    result.append(" ");
                    result.append(str);
                }
                if (result.length() > 0 && (lastChar = result.charAt(result.length() - 1)) != '\n' && (p.getContext().isLineDelimiter() || pc.isLinkTag(i) && i + 1 < pc.size() && pc.isLinkTag(i + 1))) {
                    result.append(BACKSLASH_N);
                }
                ++i;
            }
            return result.toString();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String render(PacketCollection pc, int startPos) {
        try {
            int size = pc.size();
            StringBuffer result = new StringBuffer();
            int i = startPos;
            while (i < size) {
                char lastChar;
                IPacket p = (IPacket)pc.get(i);
                String str = p.getText();
                if (str != null && str.length() > 0 && p.getContext().isStringOutput()) {
                    if (result.length() > 0 && (lastChar = result.charAt(result.length() - 1)) != '\n' && p.getContext().isStartSelect()) {
                        result.append(BACKSLASH_N);
                    }
                    result.append(" ");
                    result.append(str);
                }
                if (result.length() > 0 && (lastChar = result.charAt(result.length() - 1)) != '\n' && (p.getContext().isLineDelimiter() || pc.isLinkTag(i) && i + 1 < pc.size() && pc.isLinkTag(i + 1))) {
                    result.append(BACKSLASH_N);
                }
                ++i;
            }
            return result.toString();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public void addView(IVoiceBrowserView view) {
        views.add(view);
    }

    public void removeView(IVoiceBrowserView view) {
        views.remove(view);
    }

    public void addSelectionObserver(SelectionObserver view) {
        selObservers.add(view);
    }

    public void removeSelectionObserver(SelectionObserver view) {
        selObservers.remove(view);
    }

    public PacketCollection getPacketCollection() {
        return this.ccursor.getPc();
    }

    void drawText(String text) {
        if (views == null) {
            return;
        }
        int numViews = views.size();
        int i = 0;
        while (i < numViews) {
            IVoiceBrowserView tv = views.get(i);
            tv.drawText(text);
            ++i;
        }
    }

    void drawAppendText(String text) {
        if (views == null) {
            return;
        }
        int numViews = views.size();
        int i = 0;
        while (i < numViews) {
            IVoiceBrowserView tv = views.get(i);
            tv.drawAppendText(text);
            ++i;
        }
    }

    public void addCursorListener(CursorListener listener) {
        this.cursorListeners.addElement(listener);
    }

    public void removeCursorListener(CursorListener listener) {
        this.cursorListeners.removeElement(listener);
    }

    public void sendCursorEvent(CursorMovedEvent event) {
        Vector listeners = (Vector)this.cursorListeners.clone();
        Enumeration enums = listeners.elements();
        while (enums.hasMoreElements()) {
            CursorListener listener = (CursorListener)enums.nextElement();
            listener.doCursorMoved(event);
        }
    }

    public void setSpeechControl(ITTSEngine speech) {
        if (speech != null) {
            this.speech = speech;
        }
    }
}

