/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.voicebrowser;

import org.eclipse.actf.visualization.internal.engines.voicebrowser.Context;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.IElementRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.MessageCollection;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.OutLoud;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.Packet;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.PacketCollection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StaticMAPRenderer
implements IElementRenderer {
    public PacketCollection getPacketCollectionIn(Element element, Context ctx, String url, MessageCollection mc) {
        this.setContextIn(element, ctx);
        NodeList children = element.getChildNodes();
        int num = 0;
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            String nodeName = node.getNodeName().toLowerCase();
            if (nodeName.equals("area")) {
                ++num;
            }
            ++i;
        }
        String result = null;
        if (num > 1) {
            result = OutLoud.buildResultString(mc, url, element, "in", "plural", "<name=num1>", Integer.toString(num));
            if (result == null && OutLoud.hprDefltMsg) {
                result = "(Start of map with " + num + " items.)";
            }
        } else {
            result = OutLoud.buildResultString(mc, url, element, "in", "singular", "<name=num1>", Integer.toString(num));
            if (result == null && OutLoud.hprDefltMsg) {
                result = "(Start of map with 1 item.)";
            }
        }
        if (result != null) {
            result = result.trim();
        }
        return new PacketCollection(new Packet(element, result, ctx, true));
    }

    public PacketCollection getPacketCollectionOut(Element element, Context ctx, String url, MessageCollection mc) {
        this.setContextOut(element, ctx);
        String result = OutLoud.buildResultString(mc, url, element, "out", null);
        if (result == null && OutLoud.hprDefltMsg) {
            result = "(End of Map.)";
        }
        if (result != null) {
            result = result.trim();
        }
        return new PacketCollection(new Packet(element, result, ctx, false));
    }

    public void setContextIn(Element element, Context ctx) {
        ctx.setStartSelect(true);
        ctx.setGoChild(true);
        ctx.setLineDelimiter(true);
        ctx.setLinkTag(false);
    }

    public void setContextOut(Element element, Context ctx) {
        ctx.setStartSelect(false);
        ctx.setGoChild(true);
        ctx.setLineDelimiter(true);
        ctx.setLinkTag(false);
    }
}

