/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.voicebrowser;

import java.util.HashMap;
import java.util.Map;

public class TextUtil {
    private static Map<Character, String> replaceMap = new HashMap<Character, String>();

    static {
        replaceMap.put(new Character('\u2122'), "trade mark");
        replaceMap.put(new Character('\u00a9'), "copyright mark");
        replaceMap.put(new Character('\u00ae'), "registered mark");
    }

    public static StringBuffer replace(StringBuffer s) {
        int length = s.length();
        int i = 0;
        while (i < length) {
            String insert = replaceMap.get(new Character(s.charAt(i)));
            if (insert != null) {
                s.deleteCharAt(i);
                s.insert(i, " " + insert);
                i += insert.length();
                length += insert.length();
            }
            ++i;
        }
        return s;
    }

    public static String substitute(String input, String pattern, String replacement) {
        int index = input.indexOf(pattern.toLowerCase());
        if (index == -1) {
            return input;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(input.substring(0, index)) + replacement);
        if (index + pattern.length() < input.length()) {
            String rest = input.substring(index + pattern.length(), input.length());
            buffer.append(TextUtil.substitute(rest, pattern, replacement));
        }
        return buffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String trim(String s) {
        int from = 0;
        int to = s.length();
        if (to == 0) {
            return "";
        }
        try {
            char c = s.charAt(from);
            while (true) {
                if (from >= to || !Character.isWhitespace(c) && !Character.isSpaceChar(c) && !TextUtil.isReturn(c)) {
                    if (from == 0 || to - from != 1) break;
                    return s.substring(from, to + 1);
                }
                if (++from == to) {
                    return "";
                }
                c = s.charAt(from);
            }
            c = s.charAt(--to);
            while (true) {
                if (from >= to || !Character.isWhitespace(c) && !Character.isSpaceChar(c) && !TextUtil.isReturn(c)) {
                    return s.substring(from, to + 1);
                }
                c = s.charAt(--to);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return s;
        }
    }

    private static boolean isReturn(char c) {
        if (c == '\n') {
            return true;
        }
        return c == '\r';
    }
}

