/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision;

import org.eclipse.actf.visualization.engines.lowvision.LowVisionException;
import org.eclipse.actf.visualization.engines.lowvision.image.IPageImage;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CharacterMS;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CharacterSM;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CharacterSS;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorIRGB;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorLAB;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.BinaryImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Container;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.LineSegment;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.PageComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Topology;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Vector3D;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.ColorProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemException;

public class DecisionMaker {
    public static final double THRESHOLD_MIN_CHAR_RATIO = 0.1;
    public static final double THRESHOLD_MAX_CHAR_RATIO = 10.0;
    public static final double THRESHOLD_MIN_CONTAINER_DENSITY = 0.4;
    public static final double THRESHOLD_MAX_CHARACTER_DENSITY = 0.75;
    public static final double THRESHOLD_MIN_THINNING_RATIO = 0.25;
    public static final double THRESHOLD_MIN_UNDERLINE_POSITION = 0.85;
    public static final double THRESHOLD_MIN_UNDERLINE_WIDTH_RATIO = 0.95;
    public static final double THRESHOLD_MIN_UNDERLINE_RATIO = 3.0;
    public static final int THRESHOLD_MIN_CHAR_WIDTH = 5;
    public static final int THRESHOLD_MAX_CHAR_WIDTH = 72;
    public static final int THRESHOLD_MIN_CHAR_HEIGHT = 5;
    public static final int THRESHOLD_MAX_CHAR_HEIGHT = 100;
    public static final int THRESHOLD_MAX_THINNED_BRANCHES = 8;
    public static final int THRESHOLD_MAX_THINNED_CROSSES = 8;
    public static final int THRESHOLD_MIN_MSCHAR_WIDTH = 10;
    public static final int THRESHOLD_MIN_MSCHAR_HEIGHT = 10;
    public static final int THRESHOLD_MAX_MSCHAR_HEIGHT = 100;
    public static final int THRESHOLD_MIN_SMCHAR_WIDTH = 10;
    public static final int THRESHOLD_MIN_SMCHAR_HEIGHT = 10;
    public static final int THRESHOLD_MAX_SMCHAR_HEIGHT = 100;
    public static final double THRESHOLD_FOREGROUND_RATIO = 0.25;
    public static final double THRESHOLD_FOREGROUND_ERROR_MARGIN = 1.5;
    public static final float THRESHOLD_LIMIT_BLURRED_WIDTH_RATIO = 3.0f;
    public static final float THRESHOLD_LIMIT_BLURRED_HEIGHT_RATIO = 3.0f;
    public static final int THRESHOLD_MAX_CHARACTER_SPACE = 7;
    public static final int THRESHOLD_MAX_REGION_ELEMENT_SPACE = 80;
    public static final int THRESHOLD_MAX_GROUPED_CONTAINER_WIDTH = 300;
    public static final int THRESHOLD_MAX_GROUPED_CONTAINER_HEIGHT = 300;
    public static final double SCORE_ORANGE = 0.5;
    public static final double SCORE_RED = 1.0;
    public static final float ENOUGH_DELTA_E_FOR_IMAGE = 40.0f;
    public static final float MIN_ENOUGH_DELTA_L_FOR_TEXT = 20.0f;
    public static final float MAX_ENOUGH_DELTA_L_FOR_TEXT = 40.0f;
    public static final float ENOUGH_DELTA_E_FOR_TEXT = 100.0f;
    public static final float ENOUGH_DELTA_H_FOR_TEXT = 100.0f;

    public static short judgeComponentType(ConnectedComponent _cc, IPageImage _pi) throws ImageException {
        return DecisionMaker.judgeComponentType(_cc, _pi, false);
    }

    public static short judgeComponentType(ConnectedComponent _cc, IPageImage _pi, boolean _test) throws ImageException {
        BinaryImage shape = _cc.getShape();
        int cWidth = shape.getWidth();
        int cHeight = shape.getHeight();
        if (cWidth < 5 || cHeight < 5) {
            return 100;
        }
        double density = _cc.getDensity();
        LineSegment horSeg = shape.detectLongestHorizontalLine();
        if (horSeg.isVertical() || horSeg.isDiagonal()) {
            throw new ImageException("detectLongestHorizontalLine() does not work.");
        }
        double widthRatio = horSeg.getLength() / (double)cWidth;
        double position = (double)horSeg.getLeftPoint().getY() / (double)cHeight;
        double ratio = (double)cWidth / (double)cHeight;
        if (widthRatio >= 0.95 && position >= 0.85 && ratio >= 3.0 && density < 0.4) {
            return 3;
        }
        if (cWidth > 72 || cHeight > 100) {
            return 1;
        }
        if (ratio < 0.1 || 10.0 < ratio) {
            return 100;
        }
        ConnectedComponent thinCc = _cc.thinning();
        if ((double)thinCc.getCount() / (double)_cc.getCount() < 0.25) {
            return 100;
        }
        Topology thinTopo = new Topology(thinCc);
        if (thinTopo.getNumBranches() > 8) {
            return 100;
        }
        if (thinTopo.getNumCrosses() > 8) {
            return 100;
        }
        return 2;
    }

    public static boolean isMSCharacter(ConnectedComponent _cc) throws ImageException {
        BinaryImage shape = _cc.getShape();
        int cWidth = shape.getWidth();
        int cHeight = shape.getHeight();
        if (cWidth < 10 || cHeight < 10) {
            return false;
        }
        return cHeight <= 100;
    }

    public static boolean isTooSmallThinedMSCharacter(CharacterMS _msc) throws ImageException {
        ConnectedComponent curCc = _msc.getConnectedComponent();
        ConnectedComponent thinCc = curCc.thinning();
        double ratio = (double)thinCc.getCount() / (double)curCc.getCount();
        return ratio < 0.25;
    }

    public static boolean isSMCharacter(CharacterSM _smc) {
        int foregroundColor = _smc.getForegroundColor();
        int sumR = 0;
        int sumG = 0;
        int sumB = 0;
        int w = _smc.getWidth();
        int h = _smc.getHeight();
        if (w < 10 || h < 10 || h > 100) {
            return false;
        }
        ConnectedComponent cc = _smc.getConnectedComponent();
        byte[][] data = cc.getShape().getData();
        int[][] img = _smc.getImage();
        int count = 0;
        int j = 0;
        while (j < h) {
            int i = 0;
            while (i < w) {
                if (data[j][i] == 0) {
                    int color = img[j][i];
                    sumR += color >> 16 & 0xFF;
                    sumG += color >> 8 & 0xFF;
                    sumB += color & 0xFF;
                    ++count;
                }
                ++i;
            }
            ++j;
        }
        int sumColor = ((sumR /= count) & 0xFF) << 16 | ((sumG /= count) & 0xFF) << 8 | (sumB /= count) & 0xFF;
        try {
            return DecisionMaker.distinguishableTextColors(foregroundColor, sumColor);
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public static boolean distinguishableTextColors(ColorLAB _c1, ColorLAB _c2) {
        double deltaL = ColorLAB.deltaL(_c1, _c2);
        double deltaE = ColorLAB.deltaE(_c1, _c2);
        if (deltaL < 20.0) {
            return false;
        }
        if (deltaE >= 100.0) {
            return true;
        }
        double thresholdL = DecisionMaker.calcThresholdLforText(_c1, _c2);
        return !(deltaL < thresholdL);
    }

    public static boolean distinguishableTextColors(int _c1, int _c2) throws LowVisionException {
        ColorLAB lab1 = null;
        ColorLAB lab2 = null;
        try {
            lab1 = new ColorIRGB(_c1).toXYZ().toLAB();
            lab2 = new ColorIRGB(_c2).toXYZ().toLAB();
        }
        catch (ColorException ce) {
            ce.printStackTrace();
            throw new LowVisionException("ColorException occurred while converting int into ColorLAB");
        }
        return DecisionMaker.distinguishableTextColors(lab1, lab2);
    }

    public static double calcThresholdLforText(ColorLAB _c1, ColorLAB _c2) {
        double deltaE = ColorLAB.deltaE(_c1, _c2);
        double thresholdL = (double)-0.2f * deltaE + 40.0;
        if (thresholdL < 0.0) {
            thresholdL = 0.0;
        }
        return thresholdL;
    }

    public static double calcThresholdLforText(int _c1, int _c2) throws LowVisionException {
        ColorLAB lab1 = null;
        ColorLAB lab2 = null;
        try {
            lab1 = new ColorIRGB(_c1).toXYZ().toLAB();
            lab2 = new ColorIRGB(_c2).toXYZ().toLAB();
        }
        catch (ColorException ce) {
            ce.printStackTrace();
            throw new LowVisionException("ColorException occurred while converting int into ColorLAB");
        }
        return DecisionMaker.calcThresholdLforText(lab1, lab2);
    }

    public static boolean distinguishableImageColors(ColorLAB _c1, ColorLAB _c2) {
        return DecisionMaker.calcColorDistanceForImage(_c1, _c2) >= 1.0;
    }

    public static boolean distinguishableImageColors(int _c1, int _c2) throws LowVisionException {
        ColorLAB lab1 = null;
        ColorLAB lab2 = null;
        try {
            lab1 = new ColorIRGB(_c1).toXYZ().toLAB();
            lab2 = new ColorIRGB(_c2).toXYZ().toLAB();
        }
        catch (ColorException ce) {
            ce.printStackTrace();
            throw new LowVisionException("ColorException occurred while converting int into ColorLAB");
        }
        return DecisionMaker.distinguishableImageColors(lab1, lab2);
    }

    public static double calcColorDistanceForImage(ColorLAB _c1, ColorLAB _c2) {
        return ColorLAB.deltaE(_c1, _c2) / 40.0f;
    }

    public static double calcColorDistanceForImage(int _c1, int _c2) throws LowVisionException {
        ColorLAB lab1 = null;
        ColorLAB lab2 = null;
        try {
            lab1 = new ColorIRGB(_c1).toXYZ().toLAB();
            lab2 = new ColorIRGB(_c2).toXYZ().toLAB();
        }
        catch (ColorException ce) {
            ce.printStackTrace();
            throw new LowVisionException("ColorException occurred while converting int into ColorLAB");
        }
        return DecisionMaker.calcColorDistanceForImage(lab1, lab2);
    }

    public static boolean isForegroundColor(int _color, int _fore, int _back) {
        Vector3D colV = DecisionMaker.colorToVector3D(_color);
        Vector3D foreV = DecisionMaker.colorToVector3D(_fore);
        Vector3D backV = DecisionMaker.colorToVector3D(_back);
        Vector3D back2colV = Vector3D.subtract(colV, backV);
        Vector3D back2foreV = Vector3D.subtract(foreV, backV);
        if (back2foreV.isZeroVector() || back2colV.isZeroVector()) {
            double distance = Vector3D.magnitude(Vector3D.subtract(foreV, colV));
            return distance <= 1.5;
        }
        double rCol = back2colV.magnitude();
        double rFore = back2foreV.magnitude();
        double sinTheta = 0.0;
        double cosTheta = 0.0;
        try {
            sinTheta = Vector3D.sine(back2foreV, back2colV);
            cosTheta = Vector3D.cosine(back2foreV, back2colV);
        }
        catch (ImageException e) {
            e.printStackTrace();
        }
        if (rCol * sinTheta > 1.5) {
            return false;
        }
        double ratio = rCol * cosTheta / rFore;
        return !(ratio < 0.25) && !(1.0 < ratio);
    }

    private static Vector3D colorToVector3D(int _color) {
        ColorIRGB ci = new ColorIRGB(_color);
        return new Vector3D(ci.getR(), ci.getG(), ci.getB());
    }

    public static int calcSearchMinX(int _origLeft, int _origWidth, int _pageWidth) {
        int tmpX = _origLeft - Math.round(1.0f * (float)_origWidth);
        if (tmpX < 0) {
            tmpX = 0;
        }
        return tmpX;
    }

    public static int calcSearchMaxX(int _origLeft, int _origWidth, int _pageWidth) {
        int tmpX = _origLeft + _origWidth + Math.round(1.0f * (float)_origWidth);
        if (tmpX > _pageWidth - 1) {
            tmpX = _pageWidth - 1;
        }
        return tmpX;
    }

    public static int calcSearchMinY(int _origTop, int _origHeight, int _pageHeight) {
        int tmpY = _origTop - Math.round(1.0f * (float)_origHeight);
        if (tmpY < 0) {
            tmpY = 0;
        }
        return tmpY;
    }

    public static int calcSearchMaxY(int _origTop, int _origHeight, int _pageHeight) {
        int tmpY = _origTop + _origHeight + Math.round(1.0f * (float)_origHeight);
        if (tmpY > _pageHeight - 1) {
            tmpY = _pageHeight - 1;
        }
        return tmpY;
    }

    public static boolean areSameGroupProblems(LowVisionProblem _p1, LowVisionProblem _p2) throws LowVisionProblemException {
        short componentType2;
        if (_p1.isGroup() || _p2.isGroup()) {
            throw new LowVisionProblemException("ProblemGroup cannot be grouped any more.");
        }
        PageComponent component1 = _p1.getPageComponent();
        PageComponent component2 = _p2.getPageComponent();
        short componentType1 = component1.getType();
        if (componentType1 != (componentType2 = component2.getType())) {
            return false;
        }
        int type1 = _p1.getLowVisionProblemType();
        if (type1 != _p2.getLowVisionProblemType()) {
            return false;
        }
        if (type1 == 1) {
            ColorProblem cp1 = (ColorProblem)_p1;
            ColorProblem cp2 = (ColorProblem)_p2;
            if (componentType1 == 4) {
                if (cp1.getBackgroundColor() != cp2.getBackgroundColor()) {
                    return false;
                }
                if (cp1.getForegroundColor() != cp2.getForegroundColor()) {
                    return false;
                }
            } else if (componentType1 == 5 ? cp1.getBackgroundColor() != cp2.getBackgroundColor() : componentType1 == 6 && cp1.getForegroundColor() != cp2.getForegroundColor()) {
                return false;
            }
        } else if (type1 == 2) {
            if (componentType1 == 4) {
                CharacterSS ssc1 = (CharacterSS)component1;
                CharacterSS ssc2 = (CharacterSS)component2;
                if (ssc1.getForegroundColor() != ssc2.getForegroundColor()) {
                    return false;
                }
                if (ssc1.getBackgroundColor() != ssc2.getBackgroundColor()) {
                    return false;
                }
            } else if (componentType1 == 5 ? ((CharacterMS)component1).getBackgroundColor() != ((CharacterMS)component2).getBackgroundColor() : componentType1 == 6 && ((CharacterSM)component1).getForegroundColor() != ((CharacterSM)component2).getForegroundColor()) {
                return false;
            }
        } else {
            throw new LowVisionProblemException("Unknown problem type :" + type1);
        }
        Container cont = null;
        cont = _p1.getPageComponent().getContainer();
        if (cont != null && cont.getWidth() <= 300 && cont.getHeight() <= 300) {
            return true;
        }
        int left1 = _p1.getX();
        int right1 = left1 + _p1.getWidth() - 1;
        int top1 = _p1.getY();
        int bottom1 = top1 + _p1.getHeight() - 1;
        int left2 = _p2.getX();
        int right2 = left2 + _p2.getWidth() - 1;
        int top2 = _p2.getY();
        int bottom2 = top2 + _p2.getHeight() - 1;
        if (left1 - right2 > 80 || left2 - right1 > 80) {
            return false;
        }
        return top1 - bottom2 <= 80 && top2 - bottom1 <= 80;
    }

    public static int getScoreMapColor(double _score) {
        if (_score <= 0.0) {
            return 0xAAAAAA;
        }
        if (_score < 0.5) {
            return 0xFFFF00;
        }
        if (_score < 1.0) {
            return 0xFF7700;
        }
        return 0xFF0000;
    }
}

