/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.problem;

import org.eclipse.actf.visualization.engines.lowvision.LowVisionType;
import org.eclipse.actf.visualization.internal.engines.lowvision.Messages;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.BinaryImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.InteriorImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.InteriorImageComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.DontRelyOnColorRecommendation;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemException;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionRecommendation;

public class ImageColorProblem
extends LowVisionProblem {
    InteriorImageComponent imageComponent1 = null;
    InteriorImageComponent imageComponent2 = null;

    public ImageColorProblem(InteriorImage _ii, LowVisionType _lvType, double _prob, InteriorImageComponent _lc1, InteriorImageComponent _lc2) throws LowVisionProblemException {
        super(3, _lvType, Messages.ImageColorProblem_This_image_has_two_or_more_components_whose_colors_are_too_close__1, _ii, _prob);
        this.left = _ii.getLeft();
        this.top = _ii.getTop();
        this.width = _ii.getWidth();
        this.height = _ii.getHeight();
        this.imageComponent1 = _lc1;
        this.imageComponent2 = _lc2;
        if (_lc1.getContainerImage() != _lc2.getContainerImage()) {
            throw new LowVisionProblemException("The two component come from different images.");
        }
        if (_lc1.getContainerImage() != _ii) {
            throw new LowVisionProblemException("The container of the components and the InteriorImage do not match.");
        }
        this.setRecommendations();
    }

    public InteriorImageComponent[] getInteriorImageComponentArray() {
        InteriorImageComponent[] array = new InteriorImageComponent[]{this.imageComponent1, this.imageComponent2};
        return array;
    }

    public InteriorImage getContainerImage() {
        return this.imageComponent1.getContainerImage();
    }

    protected void setRecommendations() throws LowVisionProblemException {
        this.numRecommendations = 1;
        this.recommendations = new LowVisionRecommendation[this.numRecommendations];
        this.recommendations[0] = new DontRelyOnColorRecommendation(this);
    }

    public IInt2D showProblemImage() {
        Int2D whiteI2d = null;
        try {
            int i;
            int j;
            byte[][] ccData;
            int ccHeight;
            int ccWidth;
            BinaryImage shape;
            int ccTop;
            int ccLeft;
            ConnectedComponent cc;
            InteriorImage ii = (InteriorImage)this.pageComponent;
            Int2D simI2d = ii.simulate(this.lowVisionType);
            whiteI2d = new Int2D(simI2d.getWidth(), simI2d.getHeight());
            int numCC = this.imageComponent1.getNumConnectedComponents();
            ConnectedComponent[] ccArray = this.imageComponent1.getConnectedComponents();
            int k = 0;
            while (k < numCC) {
                cc = ccArray[k];
                ccLeft = cc.getLeft();
                ccTop = cc.getTop();
                shape = cc.getShape();
                ccWidth = shape.getWidth();
                ccHeight = shape.getHeight();
                ccData = shape.getData();
                j = 0;
                while (j < ccHeight) {
                    i = 0;
                    while (i < ccWidth) {
                        if (ccData[j][i] != 0) {
                            whiteI2d.getData()[j + ccTop][i + ccLeft] = simI2d.getData()[j + ccTop][i + ccLeft];
                        }
                        ++i;
                    }
                    ++j;
                }
                ++k;
            }
            numCC = this.imageComponent2.getNumConnectedComponents();
            ccArray = null;
            ccArray = this.imageComponent2.getConnectedComponents();
            k = 0;
            while (k < numCC) {
                cc = ccArray[k];
                ccLeft = cc.getLeft();
                ccTop = cc.getTop();
                shape = cc.getShape();
                ccWidth = shape.getWidth();
                ccHeight = shape.getHeight();
                ccData = shape.getData();
                j = 0;
                while (j < ccHeight) {
                    i = 0;
                    while (i < ccWidth) {
                        if (ccData[j][i] != 0) {
                            whiteI2d.getData()[j + ccTop][i + ccLeft] = simI2d.getData()[j + ccTop][i + ccLeft];
                        }
                        ++i;
                    }
                    ++j;
                }
                ++k;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return whiteI2d;
    }
}

