/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.problem;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionType;
import org.eclipse.actf.visualization.engines.lowvision.image.IPageImage;
import org.eclipse.actf.visualization.eval.problem.ILowvisionProblemSubtype;
import org.eclipse.actf.visualization.internal.engines.lowvision.PageElement;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.PageComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemException;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionRecommendation;
import org.w3c.dom.Element;

public abstract class LowVisionProblem
implements ILowvisionProblemSubtype {
    public static final int UNSET_POSITION = -1;
    public static final int DEFAULT_PRIORITY = 0;
    public static final short LOWVISION_PROBLEM = 0;
    IPageImage pageImage = null;
    LowVisionType lowVisionType = null;
    int problemType;
    short componentType = (short)-1;
    PageComponent pageComponent = null;
    PageElement pageElement = null;
    String description;
    int left = -1;
    int top = -1;
    int width = 0;
    int height = 0;
    int priority;
    double probability = 0.0;
    double characterScore = 0.0;
    int numRecommendations = 0;
    LowVisionRecommendation[] recommendations = null;
    boolean isGroupFlag = false;
    Element element;
    private static final int[] PROBLEM_COLORS = new int[]{0xFFFFFF, 0xFF0000, 65280};

    protected LowVisionProblem() {
    }

    public LowVisionProblem(int _type, LowVisionType _lvType, String _description, PageComponent _com, double _proba) throws LowVisionProblemException {
        this.problemType = _type;
        this.lowVisionType = _lvType;
        this.description = _description;
        this.pageComponent = _com;
        this.componentType = this.pageComponent.getType();
        this.pageImage = this.pageComponent.getPageImage();
        ConnectedComponent cc = this.pageComponent.getConnectedComponent();
        if (cc != null) {
            this.left = cc.getLeft();
            this.top = cc.getTop();
            this.width = cc.getWidth();
            this.height = cc.getHeight();
        }
        this.setPriority();
        this.probability = _proba;
        this.characterScore = this.probability * (double)this.width * (double)this.height;
    }

    public LowVisionProblem(int _type, LowVisionType _lvType, String _description, PageElement _pe, double _proba) {
        this.problemType = _type;
        this.lowVisionType = _lvType;
        this.description = _description;
        this.pageElement = _pe;
        if (this.pageElement != null) {
            this.left = this.pageElement.getX();
            this.top = this.pageElement.getY();
            this.width = this.pageElement.getWidth();
            this.height = this.pageElement.getHeight();
        }
        this.setPriority();
        this.probability = _proba;
    }

    private void setPriority() {
        this.priority = this.left == -1 || this.top == -1 ? 0 : Integer.MAX_VALUE - this.top * 65535 - this.left;
    }

    protected abstract void setRecommendations() throws LowVisionProblemException;

    public short getType() {
        return 0;
    }

    public LowVisionType getLowVisionType() {
        return this.lowVisionType;
    }

    public int getLowVisionProblemType() {
        return this.problemType;
    }

    public String getDescription() throws LowVisionProblemException {
        return this.description;
    }

    public IPageImage getPageImage() {
        return this.pageImage;
    }

    public int getX() {
        return this.left;
    }

    public int getY() {
        return this.top;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPriority() {
        return this.priority;
    }

    public double getProbability() {
        return this.probability;
    }

    public int getIntProbability() {
        return (int)Math.rint(this.probability * 100.0);
    }

    public double getCharacterScore() {
        return this.characterScore;
    }

    public LowVisionRecommendation[] getRecommendations() {
        return this.recommendations;
    }

    public boolean isGroup() {
        return this.isGroupFlag;
    }

    public short getComponentType() throws LowVisionProblemException {
        if (!this.isGroupFlag) {
            return this.componentType;
        }
        throw new LowVisionProblemException("componentType cannot be gotten from a ProblemGroup.");
    }

    public PageComponent getPageComponent() throws LowVisionProblemException {
        if (!this.isGroupFlag) {
            return this.pageComponent;
        }
        throw new LowVisionProblemException("component cannot be gotten from a ProblemGroup.");
    }

    public PageElement getPageElement() {
        return this.pageElement;
    }

    public String toString() {
        String compTypeString = null;
        compTypeString = this.componentType == 4 ? "(SS)" : (this.componentType == 5 ? "(MS)" : (this.componentType == 6 ? "(SM)" : "" + this.componentType));
        StringBuffer sb = new StringBuffer();
        sb.append("Description=" + this.description);
        sb.append(compTypeString);
        sb.append(", ");
        sb.append("(x,y)=(" + this.left + "," + this.top + ")");
        sb.append(", ");
        sb.append("[WIDTH x HEIGHT]=[" + this.width + " x " + this.height + "]");
        sb.append(", ");
        sb.append("Probability=" + (int)Math.rint(this.probability * 100.0));
        sb.append(", ");
        sb.append("#Recommendations=" + this.numRecommendations);
        return sb.toString();
    }

    public void dump(PrintStream _ps, boolean _doRecommendations) throws LowVisionProblemException {
        PrintWriter pw = new PrintWriter(_ps, true);
        this.dump(pw, _doRecommendations);
    }

    public void dump(PrintWriter _pw, boolean _doRecommendations) throws LowVisionProblemException {
        _pw.println("----------");
        _pw.println("dumping a problem");
        _pw.println("problemType = " + this.problemType);
        _pw.println("componentType = " + this.componentType);
        _pw.println("description = " + this.getDescription());
        _pw.println("(x,y) = ( " + this.getX() + ", " + this.getY() + ")");
        _pw.println("width, height = " + this.getWidth() + ", " + this.getHeight());
        _pw.println("priority = " + this.getPriority());
        LowVisionRecommendation[] recs = this.getRecommendations();
        if (recs != null) {
            _pw.println("# of Recommendations = " + recs.length);
        } else {
            _pw.println("Recommendations are null.");
        }
        if (_doRecommendations && recs != null) {
            int i = 0;
            while (i < recs.length) {
                _pw.println("Recommendation #" + i);
                recs[i].dump(_pw);
                ++i;
            }
        }
        _pw.println("----------");
    }

    public void drawSurroundingBox(Int2D _img) {
        int x0 = this.getX();
        int y0 = this.getY();
        int x1 = x0 + this.getWidth();
        int y1 = y0 + this.getHeight();
        int color = PROBLEM_COLORS[this.problemType];
        int i = x0;
        while (i < x1) {
            _img.getData()[y0][i] = color;
            _img.getData()[y1 - 1][i] = color;
            ++i;
        }
        int j = y0;
        while (j < y1) {
            _img.getData()[j][x0] = color;
            _img.getData()[j][x1 - 1] = color;
            ++j;
        }
    }

    public static void drawAllSurroundingBoxes(LowVisionProblem[] _problems, Int2D _img) {
        int k = 0;
        while (k < _problems.length) {
            _problems[k].drawSurroundingBox(_img);
            ++k;
        }
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }
}

