/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.accservice.swtbridge.internal.ia2;

import java.util.Locale;
import org.eclipse.actf.accservice.swtbridge.ia2.Accessible2;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleRelation;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessible2;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessibleRelation;
import org.eclipse.actf.util.win32.MemoryUtil;
import org.eclipse.actf.util.win32.NativeIntAccess;
import org.eclipse.actf.util.win32.NativeStringAccess;
import org.eclipse.swt.internal.ole.win32.COM;

public class InternalAccessible2
implements Accessible2 {
    private IAccessible2 ia2 = null;

    public InternalAccessible2(IAccessible2 accessible2) {
        this.ia2 = accessible2;
    }

    public void dispose() {
        this.ia2 = null;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public int getAccessibleRelationCount() {
        if (this.ia2 != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.ia2.get_nRelations(nia.getAddress()) == 0) {
                    int n = nia.getInt();
                    return n;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return 0;
    }

    public AccessibleRelation getAccessibleRelation(int relationIndex) {
        if (this.ia2 != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.ia2.get_relation(relationIndex, nia.getAddress()) == 0) {
                    InternalAccessibleRelation internalAccessibleRelation = new InternalAccessibleRelation(nia.getInt());
                    return internalAccessibleRelation;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return null;
    }

    public AccessibleRelation[] getAccessibleRelations(int maxRelations) {
        if (this.ia2 != null && maxRelations > 0) {
            NativeIntAccess nia = new NativeIntAccess(maxRelations + 1);
            try {
                if (this.ia2.get_relations(maxRelations, nia.getAddress(1), nia.getAddress(0)) == 0) {
                    int count = nia.getInt(0);
                    AccessibleRelation[] retRelations = new AccessibleRelation[count];
                    int i = 0;
                    while (i < count) {
                        retRelations[i] = new InternalAccessibleRelation(nia.getInt(i + 1));
                        ++i;
                    }
                    AccessibleRelation[] accessibleRelationArray = retRelations;
                    return accessibleRelationArray;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return null;
    }

    public int getAccessibleRole() {
        if (this.ia2 != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.ia2.get_role(nia.getAddress()) == 0) {
                    int n = nia.getInt();
                    return n;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return 0;
    }

    public boolean scrollTo(int scrollType) {
        if (this.ia2 != null) {
            this.ia2.scrollTo(scrollType);
        }
        return false;
    }

    public boolean scrollToPoint(int coordinateType, int x, int y) {
        if (this.ia2 != null) {
            this.ia2.scrollToPoint(coordinateType, x, y);
        }
        return false;
    }

    public int[] getGroupPosition() {
        if (this.ia2 != null) {
            NativeIntAccess nia = new NativeIntAccess(3);
            try {
                if (this.ia2.get_groupPosition(nia.getAddress(0), nia.getAddress(1), nia.getAddress(2)) == 0) {
                    int[] nArray = new int[]{nia.getInt(0), nia.getInt(1), nia.getInt(2)};
                    return nArray;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nia.dispose();
            }
        }
        return null;
    }

    public int getStates() {
        if (this.ia2 != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.ia2.get_states(nia.getAddress()) == 0) {
                    int n = nia.getInt();
                    return n;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return 0;
    }

    public String getExtendedRole() {
        if (this.ia2 != null) {
            NativeStringAccess nsa = new NativeStringAccess();
            try {
                if (this.ia2.get_extendedRole(nsa.getAddress()) == 0) {
                    String string = nsa.getString();
                    return string;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nsa.dispose();
            }
        }
        return null;
    }

    public String getLocalizedExtendedRole() {
        if (this.ia2 != null) {
            NativeStringAccess nsa = new NativeStringAccess();
            try {
                if (this.ia2.get_localizedExtendedRole(nsa.getAddress()) == 0) {
                    String string = nsa.getString();
                    return string;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nsa.dispose();
            }
        }
        return null;
    }

    public int getExtendedStateCount() {
        if (this.ia2 != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.ia2.get_nExtendedStates(nia.getAddress()) == 0) {
                    int n = nia.getInt();
                    return n;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return 0;
    }

    public String[] getExtendedStates(int maxExtendedStates) {
        if (this.ia2 != null && maxExtendedStates > 0) {
            NativeIntAccess nia = new NativeIntAccess(2);
            try {
                if (this.ia2.get_extendedStates(maxExtendedStates, nia.getAddress(0), nia.getAddress(1)) == 0) {
                    String[] stringArray = InternalAccessible2.getStringArray(nia.getInt(0), nia.getInt(1), true);
                    return stringArray;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return null;
    }

    public String[] getLocalizedExtendedStates(int maxLocalizedExtendedStates) {
        if (this.ia2 != null && maxLocalizedExtendedStates > 0) {
            NativeIntAccess nia = new NativeIntAccess(2);
            try {
                if (this.ia2.get_localizedExtendedStates(maxLocalizedExtendedStates, nia.getAddress(0), nia.getAddress(1)) == 0) {
                    String[] stringArray = InternalAccessible2.getStringArray(nia.getInt(0), nia.getInt(1), true);
                    return stringArray;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return null;
    }

    public int getUniqueID() {
        if (this.ia2 != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.ia2.get_uniqueID(nia.getAddress()) == 0) {
                    int n = nia.getInt();
                    return n;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return 0;
    }

    public int getWindowHandle() {
        if (this.ia2 != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.ia2.get_windowHandle(nia.getAddress()) == 0) {
                    int n = nia.getInt();
                    return n;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return 0;
    }

    public int getAccessibleIndexInParent() {
        if (this.ia2 != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.ia2.get_indexInParent(nia.getAddress()) == 0) {
                    int n = nia.getInt();
                    return n;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return 0;
    }

    public Locale getLocale() {
        if (this.ia2 != null) {
            NativeIntAccess nia = new NativeIntAccess(3);
            try {
                if (this.ia2.get_locale(nia.getAddress()) == 0) {
                    String[] ls = InternalAccessible2.getStringArray(nia.getAddress(), 3, false);
                    Locale locale = new Locale(ls[0], ls[1], ls[2]);
                    return locale;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nia.dispose();
            }
        }
        return null;
    }

    public String getAttributes() {
        if (this.ia2 != null) {
            NativeStringAccess nsa = new NativeStringAccess();
            try {
                if (this.ia2.get_attributes(nsa.getAddress()) == 0) {
                    String string = nsa.getString();
                    return string;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nsa.dispose();
            }
        }
        return null;
    }

    public static String[] getStringArray(int pBSTR, int count, boolean bFree) {
        String[] sRet = new String[count];
        if (count > 0) {
            int[] hMem = new int[count];
            MemoryUtil.MoveMemory((int[])hMem, (int)pBSTR, (int)(4 * count));
            int i = 0;
            while (i < count) {
                sRet[i] = "";
                if (hMem[i] != 0) {
                    int size = COM.SysStringByteLen((int)hMem[i]);
                    if (size > 0) {
                        char[] buffer = new char[(size + 1) / 2];
                        MemoryUtil.MoveMemory((char[])buffer, (int)hMem[i], (int)size);
                        sRet[i] = new String(buffer);
                    }
                    COM.SysFreeString((int)hMem[i]);
                }
                ++i;
            }
        }
        if (bFree) {
            COM.CoTaskMemFree((int)pBSTR);
        }
        return sRet;
    }
}

