/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.accservice.swtbridge.internal.ia2;

import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleAction;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleAction;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessible2;
import org.eclipse.actf.util.win32.NativeIntAccess;
import org.eclipse.actf.util.win32.NativeStringAccess;

public class InternalAccessibleAction
implements AccessibleAction {
    private IAccessibleAction accessibleAction = null;

    public InternalAccessibleAction(int address) {
        this.accessibleAction = new IAccessibleAction(address);
        this.accessibleAction.AddRef();
    }

    public void dispose() {
        if (this.accessibleAction != null) {
            this.accessibleAction.Release();
            this.accessibleAction = null;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public int getAccessibleActionCount() {
        if (this.accessibleAction != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleAction.nActions(nia.getAddress()) == 0) {
                    int n = nia.getInt();
                    return n;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nia.dispose();
            }
        }
        return 0;
    }

    public boolean doAccessibleAction(int actionIndex) {
        if (this.accessibleAction != null) {
            return this.accessibleAction.doAction(actionIndex) == 0;
        }
        return false;
    }

    public String getAccessibleActionDescription(int actionIndex) {
        if (this.accessibleAction != null) {
            NativeStringAccess nsa = new NativeStringAccess();
            try {
                if (this.accessibleAction.get_description(actionIndex, nsa.getAddress()) == 0) {
                    String string = nsa.getString();
                    return string;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nsa.dispose();
            }
        }
        return null;
    }

    public String[] getAccessibleActionKeyBinding(int actionIndex, int nMaxBinding) {
        if (this.accessibleAction != null && nMaxBinding > 0) {
            NativeIntAccess nia = new NativeIntAccess(2);
            try {
                if (this.accessibleAction.get_keyBinding(actionIndex, nMaxBinding, nia.getAddress(0), nia.getAddress(1)) == 0) {
                    String[] stringArray = InternalAccessible2.getStringArray(nia.getInt(0), nia.getInt(1), true);
                    return stringArray;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return null;
    }

    public String getAccessibleActionName(int actionIndex) {
        if (this.accessibleAction != null) {
            NativeStringAccess nsa = new NativeStringAccess();
            try {
                if (this.accessibleAction.get_name(actionIndex, nsa.getAddress()) == 0) {
                    String string = nsa.getString();
                    return string;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nsa.dispose();
            }
        }
        return null;
    }

    public String getLocalizedAccessibleActionName(int actionIndex) {
        if (this.accessibleAction != null) {
            NativeStringAccess nsa = new NativeStringAccess();
            try {
                if (this.accessibleAction.get_localizedName(actionIndex, nsa.getAddress()) == 0) {
                    String string = nsa.getString();
                    return string;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nsa.dispose();
            }
        }
        return null;
    }
}

