/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.accservice.swtbridge.internal.ia2;

import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleRelation;
import org.eclipse.actf.accservice.swtbridge.internal.InternalAccessibleObject;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleRelation;
import org.eclipse.actf.util.win32.NativeIntAccess;
import org.eclipse.actf.util.win32.NativeStringAccess;

public class InternalAccessibleRelation
implements AccessibleRelation {
    private IAccessibleRelation accessibleRelation = null;

    public InternalAccessibleRelation(int address) {
        this.accessibleRelation = new IAccessibleRelation(address);
        this.accessibleRelation.AddRef();
    }

    public void dispose() {
        if (this.accessibleRelation != null) {
            this.accessibleRelation.Release();
            this.accessibleRelation = null;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public String getRelationType() {
        NativeStringAccess nsa = new NativeStringAccess();
        try {
            if (this.accessibleRelation.get_relationType(nsa.getAddress()) == 0) {
                String string = nsa.getString();
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nsa.dispose();
        }
        return null;
    }

    public String getLocalizedRelationType() {
        NativeStringAccess nsa = new NativeStringAccess();
        try {
            if (this.accessibleRelation.get_localizedRelationType(nsa.getAddress()) == 0) {
                String string = nsa.getString();
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nsa.dispose();
        }
        return null;
    }

    public int getTargetCount() {
        NativeIntAccess nia = new NativeIntAccess();
        try {
            if (this.accessibleRelation.get_nTargets(nia.getAddress()) == 0) {
                int n = nia.getInt();
                return n;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nia.dispose();
        }
        return 0;
    }

    public AccessibleObject getTarget(int targetIndex) {
        NativeIntAccess nia = new NativeIntAccess();
        try {
            if (this.accessibleRelation.get_target(targetIndex, nia.getAddress()) == 0) {
                AccessibleObject accessibleObject = InternalAccessibleObject.newInstance(nia.getInt());
                return accessibleObject;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nia.dispose();
        }
        return null;
    }

    public AccessibleObject[] getTargets(int maxTargets) {
        if (maxTargets > 0) {
            NativeIntAccess nia = new NativeIntAccess(maxTargets + 1);
            try {
                if (this.accessibleRelation.get_targets(maxTargets, nia.getAddress(1), nia.getAddress(0)) == 0) {
                    int count = nia.getInt();
                    AccessibleObject[] retUnknowns = new AccessibleObject[count];
                    int i = 0;
                    while (i < count) {
                        retUnknowns[i] = InternalAccessibleObject.newInstance(nia.getInt(i + 1));
                        ++i;
                    }
                    AccessibleObject[] accessibleObjectArray = retUnknowns;
                    return accessibleObjectArray;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nia.dispose();
            }
        }
        return null;
    }
}

