/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.msaa.properties.fields;

import org.eclipse.actf.visualization.gui.msaa.properties.fields.AbstractInputField;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractFlagIntegerField
extends AbstractInputField {
    private int currValue;
    CheckboxTableViewer viewer;

    public AbstractFlagIntegerField(String labelText, int initValue) {
        super(labelText);
        this.currValue = initValue;
    }

    public int getIntValue() {
        return this.currValue;
    }

    protected void createControl(Composite parent) {
        this.viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        this.viewer.getTable().setLayoutData((Object)new GridData(1808));
        this.viewer.getTable().setFont(parent.getFont());
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Object[][]) {
                    return (Object[])inputElement;
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Object[]) {
                    return ((Object[])element)[0].toString();
                }
                return super.getText(element);
            }
        });
        Object[][] input = this.getLabelsAndValues();
        this.viewer.setInput((Object)input);
        int i = 0;
        while (i < input.length) {
            int flag = (Integer)input[i][1];
            boolean state = flag == this.currValue || (flag & this.currValue) != 0;
            this.viewer.setChecked((Object)input[i], state);
            ++i;
        }
    }

    protected abstract Object[][] getLabelsAndValues();

    public boolean update() {
        if (this.viewer != null) {
            this.currValue = 0;
            Object[] checked = this.viewer.getCheckedElements();
            int i = 0;
            while (i < checked.length) {
                this.currValue |= ((Integer)((Object[])checked[i])[1]).intValue();
                ++i;
            }
            return true;
        }
        return false;
    }
}

