/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.ui.views;

import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.ai.voice.IVoice;
import org.eclipse.actf.ai.voice.IVoiceEventListener;
import org.eclipse.actf.ai.voice.VoiceUtil;
import org.eclipse.actf.visualization.gui.IGuiViewIDs;
import org.eclipse.actf.visualization.gui.internal.GuiPlugin;
import org.eclipse.actf.visualization.gui.internal.util.GuiImages;
import org.eclipse.actf.visualization.gui.internal.util.Messages;
import org.eclipse.actf.visualization.gui.internal.util.ScreenReaderRenderer;
import org.eclipse.actf.visualization.gui.internal.util.TextMap;
import org.eclipse.actf.visualization.gui.ui.actions.HideHtmlAction;
import org.eclipse.actf.visualization.gui.ui.actions.RefreshRootAction;
import org.eclipse.actf.visualization.gui.ui.actions.ShowOffscreenAction;
import org.eclipse.actf.visualization.gui.ui.views.AccessibleObjectSelectionProvider;
import org.eclipse.actf.visualization.gui.ui.views.IJAWSTextView;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAOutlineView;
import org.eclipse.actf.visualization.gui.ui.views.MSAAViewRegistory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.ViewPart;

public class JAWSTextView
extends ViewPart
implements IJAWSTextView {
    private StyledText text;
    private RefreshRootAction refreshAction;
    private ShowOffscreenAction showOffscreenAction;
    private HideHtmlAction hideHtmlAction;
    private Action speakAction;
    private Action speakAllAction;
    private Action stopAction;
    private Action openPreferencesAction;
    private IPreferenceStore preferenceStore = GuiPlugin.getDefault().getPreferenceStore();
    private TextMap textMap = new TextMap();
    private Point lastSelection = null;
    private boolean ignoreSelection = false;

    public void createPartControl(Composite parent) {
        this.text = new StyledText(parent, 832){

            public void invokeAction(int action) {
                super.invokeAction(action);
            }
        };
        this.text.setEditable(false);
        this.text.setLayout((Layout)new GridLayout());
        this.text.setLayoutData((Object)new GridData());
        this.resetFont();
        this.preferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("JAWSTextView_Font".equals(event.getProperty())) {
                    JAWSTextView.this.resetFont();
                }
            }
        });
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        MSAAViewRegistory.findView(IGuiViewIDs.ID_OUTLINEVIEW);
        this.refresh();
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ScreenReaderRenderer.setBusy(true);
            }

            public void keyReleased(KeyEvent e) {
                ScreenReaderRenderer.setBusy(true);
                if (13 == e.keyCode) {
                    JAWSTextView.this.doClick((TypedEvent)e);
                } else if (32 == e.keyCode) {
                    JAWSTextView.this.doSelect((TypedEvent)e);
                } else {
                    JAWSTextView.this.checkSelection((TypedEvent)e);
                }
            }
        });
        this.text.setDoubleClickEnabled(false);
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (1 == e.button) {
                    JAWSTextView.this.checkSelection((TypedEvent)e);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                if (1 == e.button) {
                    JAWSTextView.this.doClick((TypedEvent)e);
                }
            }
        });
        VoiceUtil.getVoice().setEventListener(new IVoiceEventListener(){

            public void indexReceived(final int index) {
                JAWSTextView.this.text.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        JAWSTextView.this.selectLine(index);
                    }
                });
            }
        });
    }

    private void checkSelection(TypedEvent event) {
        Point newSelection = this.text.getSelection();
        if (!newSelection.equals((Object)this.lastSelection)) {
            IMSAAOutlineView outlineView;
            this.lastSelection = newSelection;
            AccessibleObject accObject = this.textMap.getAccessibleObject(newSelection);
            if (accObject != null && (outlineView = (IMSAAOutlineView)MSAAViewRegistory.findView(IGuiViewIDs.ID_OUTLINEVIEW)) != null) {
                this.ignoreSelection = true;
                try {
                    outlineView.setSelection(accObject);
                }
                finally {
                    this.ignoreSelection = false;
                }
            }
        }
    }

    private void doClick(TypedEvent event) {
        AccessibleObject accObject = this.getSelectedItem();
        if (accObject != null) {
            accObject.doDefaultAction();
        }
    }

    private void doSelect(TypedEvent event) {
        AccessibleObject accObject = this.getSelectedItem();
        if (accObject != null) {
            accObject.select(1);
        }
    }

    private AccessibleObject getSelectedItem() {
        return this.textMap.getAccessibleObject(this.text.getSelection());
    }

    private void resetFont() {
        FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)this.preferenceStore, (String)"JAWSTextView_Font");
        this.text.setFont(new Font((Device)this.text.getDisplay(), fontData));
    }

    public void setFocus() {
        this.text.setFocus();
    }

    public void setSelection(AccessibleObject object) {
        Point point;
        VoiceUtil.getVoice().stop();
        if (this.ignoreSelection) {
            return;
        }
        if ((object = MSAAViewRegistory.adjustSelection(object)) != null && (point = this.textMap.getPoint(object)) != null) {
            if (point.x == point.y) {
                if (point.x > 0) {
                    --point.x;
                } else if (point.y < this.text.getCharCount()) {
                    ++point.y;
                }
            }
            this.text.setSelection(point.x, point.y);
        }
    }

    public void refresh() {
        AccessibleObject object = MSAAViewRegistory.adjustSelection(null);
        VoiceUtil.getVoice().stop();
        if (object == null) {
            this.setText(Messages.msaa_jaws_notarget, 16);
        } else {
            new ScreenReaderRenderer(this.text, this.textMap).renderAll(object);
        }
    }

    private void setText(String message, int color) {
        this.text.setText(message);
        StyleRange range = new StyleRange();
        range.foreground = Display.getCurrent().getSystemColor(color);
        range.start = 0;
        range.length = this.text.getCharCount();
        this.text.setStyleRange(range);
    }

    private void selectLine(int line) {
        if (-1 == line) {
            Point selection = this.text.getSelection();
            if (selection.x != selection.y) {
                this.text.setSelection(selection.y, selection.y);
            }
            return;
        }
        int start = this.text.getOffsetAtLine(line);
        int end = start + this.text.getContent().getLine(line).length();
        this.text.setSelection(start, end);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                JAWSTextView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.text);
        this.text.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)new AccessibleObjectSelectionProvider(){

            public Object getSelectedAccessibleObject() {
                return JAWSTextView.this.getSelectedItem();
            }
        });
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.showOffscreenAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.hideHtmlAction);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                JAWSTextView.this.showOffscreenAction.adjust();
                JAWSTextView.this.hideHtmlAction.adjust();
            }
        });
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.openPreferencesAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.speakAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.speakAllAction);
        manager.add((IAction)this.stopAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.refreshAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.refreshAction);
        manager.add((IAction)this.speakAllAction);
        manager.add((IAction)this.stopAction);
    }

    private void makeActions() {
        this.refreshAction = new RefreshRootAction();
        this.showOffscreenAction = new ShowOffscreenAction();
        this.hideHtmlAction = new HideHtmlAction();
        this.speakAction = new Action(Messages.msaa_speak_here){

            public void run() {
                IVoice voice = VoiceUtil.getVoice();
                try {
                    int startLine;
                    voice.stop();
                    int lineCount = JAWSTextView.this.text.getLineCount();
                    int offset = ((JAWSTextView)JAWSTextView.this).text.getSelection().x;
                    int line = startLine = JAWSTextView.this.text.getLineAtOffset(offset);
                    while (line < lineCount) {
                        voice.speak(JAWSTextView.this.text.getContent().getLine(line), false, line);
                        ++line;
                    }
                }
                catch (Exception exception) {}
            }
        };
        this.speakAllAction = new Action(Messages.msaa_speak){

            public void run() {
                JAWSTextView.this.text.setCaretOffset(0);
                JAWSTextView.this.speakAction.run();
            }
        };
        this.speakAllAction.setToolTipText(Messages.msaa_speak_tip);
        this.speakAllAction.setImageDescriptor(GuiImages.IMAGE_SPEAK);
        this.stopAction = new Action(Messages.msaa_stop){

            public void run() {
                VoiceUtil.getVoice().stop();
                JAWSTextView.this.selectLine(-1);
            }
        };
        this.stopAction.setToolTipText(Messages.msaa_stop_tip);
        this.stopAction.setImageDescriptor(GuiImages.IMAGE_STOP);
        final Shell shell = this.getViewSite().getShell();
        this.openPreferencesAction = new Action(Messages.msaa_preferences){

            public void run() {
                PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.actf.visualization.gui.preferences.GuiPreferencePage", null, null).open();
            }
        };
    }
}

