/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.ui.views;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.accservice.swtbridge.AccessibleObjectFactory;
import org.eclipse.actf.model.flash.util.FlashMSAAUtil;
import org.eclipse.actf.util.win32.FlashMSAAObject;
import org.eclipse.actf.util.win32.FlashMSAAObjectFactory;
import org.eclipse.actf.util.win32.VariantUtil;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.ole.win32.Variant;

public class MSAATreeContentProvider
implements ITreeContentProvider {
    private boolean hideHtml = false;
    private boolean showOffscreen = false;
    private static MSAATreeContentProvider instance = new MSAATreeContentProvider();

    public static MSAATreeContentProvider getDefault() {
        if (instance == null) {
            instance = new MSAATreeContentProvider();
        }
        return instance;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof AccessibleObject) {
            AccessibleObject[] accChildren = ((AccessibleObject)parentElement).getChildren();
            Vector<AccessibleObject> childList = new Vector<AccessibleObject>();
            int i = 0;
            while (i < accChildren.length) {
                AccessibleObject accChild = accChildren[i];
                if (accChild != null) {
                    int accState = accChild.getAccState();
                    if ((accState & 0x8000) == 0) {
                        childList.add(accChild);
                    } else if (this.showOffscreen && (accState & 0x10000) != 0) {
                        childList.add(accChild);
                    }
                }
                ++i;
            }
            return childList.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof AccessibleObject) {
            return ((AccessibleObject)element).getChildCount() > 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        Object[] elements = inputElement instanceof Object[] ? (Object[])inputElement : this.getChildren(inputElement);
        if (this.hideHtml) {
            ArrayList<AccessibleObject> result = new ArrayList<AccessibleObject>();
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object i = objectArray[n2];
                if (i instanceof AccessibleObject) {
                    FlashMSAAObject msaaObject = FlashMSAAObjectFactory.getFlashMSAAObjectFromWindow((long)((AccessibleObject)i).getWindow());
                    FlashMSAAObject[] results = FlashMSAAUtil.getFlashElements((FlashMSAAObject)msaaObject);
                    AccessibleObject[] flashElements = new AccessibleObject[results.length];
                    int j = 0;
                    while (j < results.length) {
                        Variant v = VariantUtil.createVariantFromIDispatchAddress((int)results[j].getPtr());
                        flashElements[j] = AccessibleObjectFactory.getAccessibleObjectFromVariant(v);
                        ++j;
                    }
                    AccessibleObject[] accessibleObjectArray = flashElements;
                    int n3 = flashElements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        AccessibleObject j2 = accessibleObjectArray[n4];
                        result.add(j2);
                        ++n4;
                    }
                }
                ++n2;
            }
            return result.toArray();
        }
        return elements;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (oldInput instanceof Object[]) {
            oldInput = ((Object[])oldInput)[0];
        }
        if (oldInput instanceof AccessibleObject) {
            try {
                ((AccessibleObject)oldInput).dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isHideHtml() {
        return this.hideHtml;
    }

    public void setHideHtml(boolean hideHtml) {
        this.hideHtml = hideHtml;
    }

    public boolean isShowOffscreen() {
        return this.showOffscreen;
    }

    public void setShowOffscreen(boolean showOffscreen) {
        this.showOffscreen = showOffscreen;
        FlashMSAAUtil.setShowOffscreen((boolean)showOffscreen);
    }
}

