/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.engines.blind.html.util;

import java.util.Vector;
import org.eclipse.actf.model.dom.html.IErrorLogListener;
import org.eclipse.actf.visualization.eval.EvaluationUtil;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.eval.problem.ProblemItemImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlErrorLogListener
implements IErrorLogListener {
    private boolean isNoDoctype = false;
    private boolean isNonPublic = false;
    private boolean isInvalidDoctype = false;
    private Vector<IProblemItem> problemV = new Vector();
    private String orgDoctype = "";
    private boolean flag = true;

    public void errorLog(int arg0, String arg1) {
        if (arg0 != 4 || arg1.indexOf("eclipse-actf-id") < 0) {
            switch (arg0) {
                case 1: {
                    this.isNoDoctype = true;
                    break;
                }
                case 2: {
                    if (arg1.indexOf("Invalid DOCTYPE declaration.") > -1) {
                        this.isNonPublic = true;
                        break;
                    }
                    if (!arg1.matches(".*Instead of \".*\" use \".*\" as a DTD.")) break;
                    this.orgDoctype = arg1.substring(arg1.indexOf("\"") + 1);
                    this.orgDoctype = this.orgDoctype.substring(0, this.orgDoctype.indexOf("\""));
                    if (this.orgDoctype.matches("-//W3C//DTD XHTML ((1.0 (Strict|Transitional|Frameset))|1.1|Basic 1.0|Basic 1.1)//EN")) {
                        this.orgDoctype = "";
                        break;
                    }
                    this.isInvalidDoctype = true;
                    break;
                }
                case 7: {
                    if (arg1.matches(".*<head.*> must be before <body.*")) {
                        this.addHtmlProblem("C_1000.1", arg1);
                        break;
                    }
                    if (arg1.matches(".*<html.*> is not allowed as a child of <.*")) {
                        this.addHtmlProblem("C_1000.2", arg1);
                        break;
                    }
                    if (arg1.matches(".*<body.*> is not allowed as a child of <.*")) {
                        this.addHtmlProblem("C_1000.3", arg1);
                        break;
                    }
                    if (!arg1.matches(".*Order of <html.*>'s children is wrong.*")) break;
                    this.addHtmlProblem("C_1000.5", arg1);
                    break;
                }
                case 14: {
                    this.addHtmlProblem("C_1000.8", "");
                }
            }
        }
    }

    private void addHtmlProblem(String id, String target) {
        ProblemItemImpl tmpCP = new ProblemItemImpl(id);
        int line = -1;
        String[] tmpS = target.split(":");
        if (tmpS.length > 0) {
            try {
                line = Integer.parseInt(tmpS[0].trim());
            }
            catch (Exception exception) {}
        }
        if (line > -1) {
            tmpCP.setLine(line);
        }
        this.problemV.add((IProblemItem)tmpCP);
    }

    public boolean isNoDoctypeDeclaration() {
        return this.isNoDoctype || this.isNonPublic || this.isInvalidDoctype;
    }

    public boolean isNonPublicDoctype() {
        return this.isNonPublic;
    }

    public boolean isInvalidDoctype() {
        return this.isInvalidDoctype;
    }

    public String getDeclaratedDoctype() {
        return this.orgDoctype;
    }

    public Vector<IProblemItem> getHtmlProblemVector() {
        if (this.flag) {
            if (EvaluationUtil.isOriginalDOM() && this.isNoDoctypeDeclaration()) {
                if (this.isInvalidDoctype() || this.isNonPublicDoctype()) {
                    this.problemV.add((IProblemItem)new ProblemItemImpl("C_1000.6"));
                } else {
                    this.problemV.add((IProblemItem)new ProblemItemImpl("C_1000.7"));
                }
            }
            this.flag = false;
        }
        return this.problemV;
    }
}

