/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.blind.html.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.actf.visualization.engines.blind.ParamBlind;
import org.eclipse.actf.visualization.engines.voicebrowser.IPacket;
import org.eclipse.actf.visualization.engines.voicebrowser.IPacketCollection;
import org.eclipse.actf.visualization.eval.html.HtmlTagUtil;
import org.eclipse.actf.visualization.eval.html.statistics.PageData;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetId;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.internal.engines.blind.html.BlindProblem;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.TextCounter;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizationNodeInfo;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizeMapDataImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkAnalyzer {
    private static final String NULL_STRING = "";
    private static final String SKIP_TO_MAIN_LINK_DEFINITION = ".*([sS]kip|[jJ]ump to|[lL]ink to) .+|.*(\u672c\u6587|\u30e1\u30a4\u30f3|\u3092\u8aad\u3080|(\u3078|\u306b)\u30b8\u30e3\u30f3\u30d7|(\u3078|\u306b)\u79fb\u52d5|\u3078\u306e\u30ea\u30f3\u30af).*";
    private static final String WRONG_SKIPLINK_DEFINITION = ".+ ([sS]kip to|[jJ]ump to) .+";
    private static final int MAX_SKIPLINK_REACHING_TIME = 20;
    private static final int MIN_MAX_TIME_TO_ELIMINATE_SKIP_LINK = 90;
    private List<Element> intraPageLinkList = new ArrayList<Element>();
    private Map<String, Element> anchorMap = new HashMap<String, Element>();
    private Map<Element, String> skipLinkMap = new HashMap<Element, String>();
    private Document doc;
    private IPacketCollection allPc;
    private VisualizeMapDataImpl mapData;
    private Set<String> invisibleIdSet;
    private List<IProblemItem> problems;
    private int intralinkErrorCount = 0;
    private int skiplinkErrorCount = 0;
    private TextCounter textCounter;
    private PageData pageData;

    public LinkAnalyzer(Document result, IPacketCollection allPc, VisualizeMapDataImpl mapData, List<IProblemItem> problems, Set<String> invisibleIdSet, ParamBlind paramBlind, PageData pageData) {
        this.doc = result;
        this.allPc = allPc;
        this.mapData = mapData;
        this.invisibleIdSet = invisibleIdSet;
        this.problems = problems;
        this.pageData = pageData;
        this.textCounter = new TextCounter(paramBlind.iLanguage);
        this.listIntraPageLinks();
        this.analyzeIntraPageLinkMapping();
    }

    private void listIntraPageLinks() {
        NodeList aNl = this.doc.getElementsByTagName("a");
        int aNlSize = aNl.getLength();
        int i = 0;
        while (i < aNlSize) {
            Element curEl = (Element)aNl.item(i);
            String href = curEl.getAttribute("href");
            String name = curEl.getAttribute("name");
            if (href != null && href.length() > 0 && href.charAt(0) == '#') {
                VisualizationNodeInfo info = this.mapData.getNodeInfo(curEl);
                StringBuffer sb = new StringBuffer();
                int size = this.allPc.size();
                if (info != null) {
                    int j = info.getPacketId();
                    while (j < size) {
                        IPacket p = (IPacket)this.allPc.get(j);
                        String str = p.getText();
                        if (str != null) {
                            sb.append(str);
                        }
                        if (!p.getContext().isInsideAnchor()) break;
                        ++j;
                    }
                }
                int words = this.textCounter.getWordCount(sb.toString());
                String linkTitleOrg = NULL_STRING;
                String linkTitle = NULL_STRING;
                BlindProblem prob = null;
                if (curEl.hasAttribute("title")) {
                    linkTitleOrg = linkTitle = curEl.getAttribute("title");
                    if (words == 0 && (words += this.textCounter.getWordCount(linkTitleOrg)) > 0) {
                        prob = new BlindProblem(25, linkTitle);
                        prob.setTargetNode(this.mapData.getOrigNode(curEl));
                        Integer idObj = this.mapData.getIdOfNode(curEl);
                        if (idObj != null) {
                            prob.setNode(curEl, idObj);
                        } else {
                            prob.setNode(curEl);
                        }
                        this.problems.add(prob);
                    }
                    linkTitle = linkTitle.trim();
                    linkTitle = linkTitle.replaceAll("\\[|\\]|\\.|\\!|\\>", NULL_STRING);
                }
                String linkText = sb.toString();
                linkText = linkText.trim();
                linkText = linkText.replaceAll("\\[|\\]|\\.|\\!|\\>", NULL_STRING);
                prob = null;
                if (words > 0) {
                    if (linkText.matches(SKIP_TO_MAIN_LINK_DEFINITION)) {
                        this.skipLinkMap.put(curEl, sb.toString());
                    } else if (linkTitle.matches(SKIP_TO_MAIN_LINK_DEFINITION)) {
                        this.skipLinkMap.put(curEl, linkTitleOrg);
                    } else {
                        if (linkTitle.matches(WRONG_SKIPLINK_DEFINITION)) {
                            prob = new BlindProblem(26, linkText);
                        }
                        if (linkText.matches(WRONG_SKIPLINK_DEFINITION)) {
                            prob = new BlindProblem(19, linkText);
                        }
                    }
                    this.intraPageLinkList.add(curEl);
                } else {
                    String noScriptText = HtmlTagUtil.getNoScriptText((Node)curEl);
                    if (noScriptText.length() <= 0) {
                        prob = new BlindProblem(14, href);
                        if (!curEl.hasAttribute("onclick") && !curEl.hasAttribute("onmouseover")) {
                            ++this.intralinkErrorCount;
                        }
                    }
                }
                if (prob != null) {
                    prob.setTargetNode(this.mapData.getOrigNode(curEl));
                    Integer idObj = this.mapData.getIdOfNode(curEl);
                    if (idObj != null) {
                        prob.setNode(curEl, idObj);
                    } else {
                        prob.setNode(curEl);
                    }
                    this.problems.add(prob);
                }
            }
            if (name != null && name.length() > 0) {
                this.anchorMap.put(name, curEl);
            }
            ++i;
        }
    }

    private void analyzeIntraPageLinkMapping() {
        for (Element lel : this.intraPageLinkList) {
            String href = lel.getAttribute("href").substring(1);
            Element tmpTarget = lel;
            boolean isVisible = true;
            while (isVisible && tmpTarget != null) {
                Node tmpN;
                String idS = tmpTarget.getAttribute("id");
                if (this.invisibleIdSet.contains(idS)) {
                    BlindProblem prob = new BlindProblem(35, "\"" + HtmlTagUtil.getTextAltDescendant((Node)lel) + "\"(href=#" + href + ", id=" + idS + ") ");
                    prob.setTargetNode(this.mapData.getOrigNode(lel));
                    Integer idObj = this.mapData.getIdOfNode(lel);
                    if (idObj != null) {
                        prob.setNode(lel, idObj);
                    } else {
                        prob.setNode(lel);
                    }
                    ++this.intralinkErrorCount;
                    this.problems.add(prob);
                    isVisible = false;
                }
                tmpTarget = (tmpN = tmpTarget.getParentNode()) != null && tmpN.getNodeType() == 1 ? (Element)tmpN : null;
            }
            if (!isVisible) continue;
            if (href.length() == 0) {
                NodeList tmpNL = this.doc.getElementsByTagName("body");
                if (tmpNL == null || tmpNL.getLength() <= 0) continue;
                Node tmpBody = tmpNL.item(0);
                this.mapData.addIntraPageLinkMapping(lel, tmpBody);
                continue;
            }
            Element ael = this.anchorMap.get(href);
            if (ael != null) {
                this.mapData.addIntraPageLinkMapping(lel, ael);
                continue;
            }
            Element idEl = this.doc.getElementById(href);
            if (idEl != null) {
                this.mapData.addIntraPageLinkMapping(lel, idEl);
                continue;
            }
            BlindProblem prob = null;
            boolean toTop = false;
            String linkText = HtmlTagUtil.getTextAltDescendant((Node)lel);
            if (linkText.matches(".*(\u5148\u982d|\u30c8\u30c3\u30d7|\u4e0a|top|start).*")) {
                toTop = true;
            }
            if (this.skipLinkMap.containsKey(lel)) {
                if (href.matches(".*top.*") || toTop) {
                    prob = new BlindProblem(33, href);
                } else {
                    prob = new BlindProblem(18, href);
                    ++this.intralinkErrorCount;
                    ++this.skiplinkErrorCount;
                }
                this.skipLinkMap.remove(lel);
            } else if (href.matches(".*top.*") || toTop) {
                prob = new BlindProblem(33, href);
            } else {
                prob = new BlindProblem(8, href);
                if (!lel.hasAttribute("onClick") && !lel.hasAttribute("onmouseover")) {
                    ++this.intralinkErrorCount;
                }
            }
            prob.setTargetNode(this.mapData.getOrigNode(lel));
            Integer idObj = this.mapData.getIdOfNode(lel);
            if (idObj != null) {
                prob.setNode(lel, idObj);
            } else {
                prob.setNode(lel);
            }
            this.problems.add(prob);
        }
    }

    public Vector<IProblemItem> skipLinkCheck(int maxTime, int maxTimeLeaf) {
        Vector<IProblemItem> problemV = new Vector<IProblemItem>();
        VisualizationNodeInfo skipLinkNodeInfo = null;
        int minSkipLinkTime = Integer.MAX_VALUE;
        int headingCount = 0;
        int skipLinkCount = this.skipLinkMap.size();
        int forwardIntraLinkCount = 0;
        HashSet<Integer> forwardSkipDestIdSet = new HashSet<Integer>();
        HashSet<Node> skipDestIdSet = new HashSet<Node>();
        HashSet<Integer> headingDestIdSet = new HashSet<Integer>();
        Vector<HighlightTargetId> overTimeElementV = new Vector<HighlightTargetId>();
        HashSet<Node> overTimeElementChildSet = new HashSet<Node>();
        List<VisualizationNodeInfo> nodeList = this.mapData.getNodeInfoList();
        for (VisualizationNodeInfo curInfo : nodeList) {
            Node curNode = curInfo.getNode();
            if (curNode == null) continue;
            if (this.skipLinkMap.containsKey(curNode) && curInfo.getTime() < minSkipLinkTime) {
                skipLinkNodeInfo = curInfo;
                minSkipLinkTime = curInfo.getTime();
            }
            if (curInfo.isHeading()) {
                ++headingCount;
                headingDestIdSet.add(new Integer(curInfo.getId()));
            }
            Node tmpNode = curNode;
            if (!curInfo.isBlockElement() || curInfo.isSequence() || curInfo.getTime() <= 120 || overTimeElementChildSet.contains(curNode)) continue;
            overTimeElementV.add(new HighlightTargetId(curInfo.getId(), curInfo.getId()));
            Stack<Node> stack = new Stack<Node>();
            tmpNode = tmpNode.getFirstChild();
            while (tmpNode != null) {
                if (tmpNode.getNodeType() == 1) {
                    overTimeElementChildSet.add(tmpNode);
                }
                if (tmpNode.hasChildNodes()) {
                    stack.push(tmpNode);
                    tmpNode = tmpNode.getFirstChild();
                    continue;
                }
                if (tmpNode.getNextSibling() != null) {
                    tmpNode = tmpNode.getNextSibling();
                    continue;
                }
                tmpNode = null;
                while (tmpNode == null && stack.size() > 0) {
                    tmpNode = (Node)stack.pop();
                    tmpNode = tmpNode.getNextSibling();
                }
            }
        }
        Map<Node, Node> linkMap = this.mapData.getIntraPageLinkMap();
        for (Node source : linkMap.keySet()) {
            Integer destIdInteger;
            int destId;
            int sourceId;
            Node dest = linkMap.get(source);
            skipDestIdSet.add(dest);
            Map<Node, Integer> idMap = this.mapData.getResult2idMap();
            if (!idMap.containsKey(source) || !idMap.containsKey(dest) || (sourceId = this.mapData.getIdOfNode(source).intValue()) >= (destId = (destIdInteger = this.mapData.getIdOfNode(dest)).intValue())) continue;
            VisualizationNodeInfo info = this.mapData.getNodeInfo(source);
            if (info != null) {
                int timeFromTop = info.getTime();
                if (timeFromTop >= 60) continue;
                forwardSkipDestIdSet.add(destIdInteger);
                continue;
            }
            forwardSkipDestIdSet.add(destIdInteger);
        }
        forwardIntraLinkCount = forwardSkipDestIdSet.size();
        skipDestIdSet.size();
        headingDestIdSet.size();
        int overTimeCount = overTimeElementV.size();
        HighlightTargetId[] overId = new HighlightTargetId[overTimeCount];
        overTimeElementV.toArray(overId);
        this.pageData.setSkipMainNum(skipLinkCount);
        this.pageData.setForwardIntraPageLinkNum(forwardIntraLinkCount);
        this.pageData.setBrokenSkipMainNum(this.skiplinkErrorCount);
        this.pageData.setBrokenIntraPageLinkNum(this.intralinkErrorCount);
        if (skipLinkNodeInfo == null) {
            if (headingCount > 0 || forwardIntraLinkCount > 0) {
                if (maxTime >= 90) {
                    problemV.add(new BlindProblem(20));
                }
            } else if (maxTime < 90) {
                problemV.add(new BlindProblem(21, NULL_STRING + maxTime));
            } else {
                problemV.add(new BlindProblem(10));
            }
        } else if (minSkipLinkTime >= 20) {
            BlindProblem prob = new BlindProblem(17, String.valueOf(minSkipLinkTime) + " ");
            Integer idObj = this.mapData.getIdOfNode(skipLinkNodeInfo.getNode());
            if (idObj != null) {
                prob.setNode(skipLinkNodeInfo.getNode(), idObj);
            } else {
                prob.setNode(skipLinkNodeInfo.getNode());
            }
            prob.setTargetNode(this.mapData.getOrigNode(skipLinkNodeInfo.getNode()));
            problemV.add(prob);
        }
        if (overTimeCount > 0) {
            BlindProblem tmpBP = null;
            tmpBP = headingCount > 0 ? (forwardIntraLinkCount > 0 ? new BlindProblem(24) : new BlindProblem(23)) : (forwardIntraLinkCount > 0 ? new BlindProblem(22) : new BlindProblem(12));
            int i = 0;
            while (i < overTimeCount) {
                tmpBP.addNodeIds(overId[i]);
                ++i;
            }
            problemV.add(tmpBP);
        }
        return problemV;
    }
}

