/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.table.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.impl.ODFStylableElementImpl;
import org.eclipse.actf.model.dom.odf.content.IStyleListener;
import org.eclipse.actf.model.dom.odf.range.ITextElementContainer;
import org.eclipse.actf.model.dom.odf.range.impl.ITextElementContainerUtil;
import org.eclipse.actf.model.dom.odf.style.StyleElement;
import org.eclipse.actf.model.dom.odf.table.TableCellElement;
import org.eclipse.actf.model.dom.odf.table.TableElement;
import org.eclipse.actf.model.dom.odf.table.TableRowElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TableRowElementImpl
extends ODFStylableElementImpl
implements TableRowElement {
    private static final long serialVersionUID = 4515268211599720829L;

    protected TableRowElementImpl(ODFDocument odfDoc, Element element) {
        super(odfDoc, element);
    }

    @Override
    public String getAttrTableStyleName() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
        }
        return null;
    }

    @Override
    public int getAttrTableNumberRowsRepeated() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-rows-repeated")) {
            return new Integer(this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-rows-repeated"));
        }
        return -1;
    }

    @Override
    public int getTableIndex() {
        TableElement tableElement = this.getTableElement();
        return tableElement.getTableIndex();
    }

    @Override
    public int getRowIndex() {
        TableElement tableElement = this.getTableElement();
        if (tableElement == null) {
            return -1;
        }
        NodeList list = tableElement.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-row");
        if (list == null) {
            return -1;
        }
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).equals(this)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public TableElement getTableElement() {
        TableElement tableElement = null;
        Node parent = this.getParentNode();
        while (parent != null) {
            if (parent instanceof TableElement) {
                tableElement = (TableElement)parent;
                break;
            }
            parent = parent.getParentNode();
        }
        return tableElement;
    }

    @Override
    public List<TableCellElement> getTableCellChildren() {
        Vector<TableCellElement> cellList = null;
        NodeList children = this.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i) instanceof TableCellElement) {
                if (cellList == null) {
                    cellList = new Vector<TableCellElement>();
                }
                cellList.add((TableCellElement)children.item(i));
            }
            ++i;
        }
        return cellList;
    }

    @Override
    public void setStyle(StyleElement style) {
    }

    @Override
    public StyleElement getStyle() {
        return null;
    }

    @Override
    public void addStyleListener(IStyleListener listener, String topic) {
    }

    @Override
    public void removeStyleListener(IStyleListener listener, String topic) {
    }

    @Override
    public long getContentSize() {
        return ITextElementContainerUtil.getContentSize(this);
    }

    @Override
    public Iterator<ITextElementContainer> getChildIterator() {
        return ITextElementContainerUtil.getChildIterator(this);
    }
}

