/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl.flash;

import org.eclipse.actf.model.dom.dombycom.impl.flash.FlashNodeImpl;
import org.eclipse.actf.model.dom.dombycom.impl.flash.FlashTopNodeImpl;
import org.eclipse.actf.model.dom.dombycom.impl.html.ElementImpl;
import org.eclipse.actf.model.dom.dombycom.impl.html.HTMLTerms;
import org.eclipse.actf.util.vocab.AbstractTerms;
import org.eclipse.actf.util.vocab.IEvalTarget;
import org.w3c.dom.Node;

public class FlashTerms
extends AbstractTerms {
    private static FlashTerms instance;

    public boolean isAlterable(IEvalTarget target) {
        return this.isClickable(target);
    }

    public static FlashTerms getInstance() {
        if (instance == null) {
            instance = new FlashTerms();
        }
        return instance;
    }

    public boolean isValidNode(IEvalTarget target) {
        return true;
    }

    public boolean isVisibleNode(IEvalTarget target) {
        if (target instanceof FlashNodeImpl) {
            FlashNodeImpl flash = (FlashNodeImpl)target;
            return !flash.isSilent();
        }
        return true;
    }

    public boolean isInputable(IEvalTarget target) {
        if (target instanceof FlashNodeImpl) {
            FlashNodeImpl flash = (FlashNodeImpl)target;
            return flash.isInputable();
        }
        return false;
    }

    public boolean isClickable(IEvalTarget target) {
        FlashNodeImpl flash;
        String clickableTarget;
        return target instanceof FlashNodeImpl && (clickableTarget = (flash = (FlashNodeImpl)target).getClickableTarget(flash.getTarget())) != null;
    }

    public boolean isButton(IEvalTarget target) {
        FlashNodeImpl flash;
        String clickableTarget;
        return target instanceof FlashNodeImpl && (clickableTarget = (flash = (FlashNodeImpl)target).getClickableTarget(flash.getTarget())) != null;
    }

    public boolean isFlashTopNode(IEvalTarget target) {
        return target instanceof FlashTopNodeImpl;
    }

    public boolean isMSAAFlash(IEvalTarget target) {
        if (target instanceof FlashTopNodeImpl) {
            return ((FlashTopNodeImpl)target).getMSAA() != null;
        }
        return false;
    }

    public boolean isEmbeddedObject(IEvalTarget target) {
        ElementImpl element;
        String name;
        return target instanceof ElementImpl && ("EMBED".equals(name = (element = (ElementImpl)target).getLocalName()) || "OBJECT".equals(name));
    }

    public boolean isAccessKey(char key, IEvalTarget target) {
        if (target instanceof FlashTopNodeImpl) {
            return HTMLTerms.getInstance().isAccessKey(key, target);
        }
        return super.isAccessKey(key, target);
    }

    public boolean isBlockJumpPointB(IEvalTarget target) {
        if (target instanceof FlashTopNodeImpl) {
            return HTMLTerms.getInstance().isBlockJumpPointB(target);
        }
        return super.isBlockJumpPointB(target);
    }

    public boolean isBlockJumpPointF(IEvalTarget target) {
        if (target instanceof FlashTopNodeImpl) {
            return HTMLTerms.getInstance().isBlockJumpPointF(target);
        }
        return super.isBlockJumpPointF(target);
    }

    public boolean isHeading(int level, IEvalTarget target) {
        if (target instanceof FlashTopNodeImpl) {
            return HTMLTerms.getInstance().isHeading(level, target);
        }
        return super.isHeading(level, target);
    }

    public boolean isHeadingJumpPoint(IEvalTarget target) {
        if (target instanceof FlashTopNodeImpl) {
            return HTMLTerms.getInstance().isHeadingJumpPoint(target);
        }
        return super.isHeadingJumpPoint(target);
    }

    public boolean nodeLocation(Node refNode, boolean backward, IEvalTarget target) {
        if (target instanceof FlashTopNodeImpl) {
            return HTMLTerms.getInstance().nodeLocation(refNode, backward, target);
        }
        return super.nodeLocation(refNode, backward, target);
    }

    public boolean isMedia(IEvalTarget target) {
        if (target instanceof FlashTopNodeImpl) {
            FlashTopNodeImpl swf = (FlashTopNodeImpl)target;
            return swf.hasMedia();
        }
        return super.isMedia(target);
    }

    public boolean hasContent(IEvalTarget target) {
        if (this.isFlashTopNode(target)) {
            return true;
        }
        if (this.isInputable(target)) {
            return true;
        }
        if (this.isListTop(target)) {
            return true;
        }
        return super.hasContent(target);
    }
}

