/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.lowvision;

import java.io.File;
import org.eclipse.actf.util.FileUtils;
import org.eclipse.actf.visualization.lowvision.util.LowVisionVizResourceUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class LowVisionVizPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.actf.visualization.lowvision";
    private static LowVisionVizPlugin plugin;
    private static File tmpDir;

    static {
        tmpDir = null;
    }

    public LowVisionVizPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        String tmpS;
        super.start(context);
        LowVisionVizPlugin.createTempDirectory();
        if (tmpDir != null && FileUtils.isAvailableDirectory((String)(tmpS = String.valueOf(tmpDir.getAbsolutePath()) + File.separator + "img"))) {
            String tmpS2 = String.valueOf(tmpS) + File.separator;
            LowVisionVizResourceUtil.saveImages(tmpS2);
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        if (tmpDir != null) {
            FileUtils.deleteFiles((File)tmpDir);
        }
    }

    public static LowVisionVizPlugin getDefault() {
        return plugin;
    }

    private static void createTempDirectory() {
        if (tmpDir == null) {
            String tmpS = String.valueOf(plugin.getStateLocation().toOSString()) + File.separator + "tmp";
            tmpDir = FileUtils.isAvailableDirectory((String)tmpS) ? new File(tmpS) : new File(System.getProperty("java.io.tmpdir"));
        }
    }

    public static File createTempFile(String prefix, String suffix) throws Exception {
        LowVisionVizPlugin.createTempDirectory();
        return File.createTempFile(prefix, suffix, tmpDir);
    }

    public static File getTempDirectory() {
        if (tmpDir == null) {
            LowVisionVizPlugin.createTempDirectory();
        }
        return tmpDir;
    }
}

