/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.lowvision.eval;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import org.eclipse.actf.ui.util.DialogSave;
import org.eclipse.actf.util.FileUtils;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.guideline.IGuidelineData;
import org.eclipse.actf.visualization.eval.problem.IProblemConst;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.eval.problem.IProblemItemImage;
import org.eclipse.actf.visualization.lowvision.ui.internal.Messages;
import org.eclipse.actf.visualization.lowvision.util.LowVisionVizResourceUtil;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveReportLowVision {
    private static final String UNDERSCORE = "_";
    private static final String LVIMG_FILE = "lvimg.bmp";
    private static final String RESULT_BMP_FILE = "result.bmp";
    private static final String[] ERROR_IMAGE_ALT = new String[]{Messages.SaveReportLowVision_Iro21_Error_Alt, Messages.SaveReportLowVision_Boke21_Error_Alt};
    private Shell shell;
    private String saveFileName;
    private List<IProblemItem> problemList;
    private String currentUrlS;
    private boolean bSave;
    private String saveImgName;
    private String strParamNo;
    private int iColorNum;
    private int iFontNum;
    private int processNo;
    private Document document;
    private File vizImageFile;
    private File reportImageFile;
    private GuidelineHolder guidelineHolder = GuidelineHolder.getInstance();

    public SaveReportLowVision(Shell _shell) {
        this.shell = _shell;
        this.saveFileName = "";
    }

    public void doSave(String _currentUrlS, List<IProblemItem> targetList, File vizImageFile, File reportImageFile) {
        this.currentUrlS = _currentUrlS;
        this.saveFileName = DialogSave.open((Shell)this.shell, (int)1, (String)this.currentUrlS, (String)"_lowVision.htm");
        this.saveImgName = LVIMG_FILE;
        this.problemList = targetList;
        if (this.saveFileName == null) {
            return;
        }
        this.document = null;
        this.bSave = true;
        this.vizImageFile = vizImageFile;
        this.reportImageFile = reportImageFile;
        SaveBmpFileThread saveThread = new SaveBmpFileThread();
        saveThread.start();
    }

    public void doSave(int _processNo, int[] paramNo, String paramStr, String folder, Document probStatisticsDoc, String _currentUrlS, List<IProblemItem> targetList, File vizImageFile, File reportImageFile) {
        this.currentUrlS = _currentUrlS;
        this.processNo = _processNo;
        this.vizImageFile = vizImageFile;
        this.reportImageFile = reportImageFile;
        this.saveFileName = this.currentUrlS;
        if (this.saveFileName != null) {
            int iPos = this.saveFileName.indexOf("//");
            if (iPos == -1) {
                iPos = 0;
            }
            this.saveFileName = this.saveFileName.substring(iPos + 2);
            this.saveFileName = this.saveFileName.replaceAll("\\p{Punct}", UNDERSCORE);
            if (this.saveFileName.indexOf(".") > 0) {
                this.saveFileName = this.saveFileName.substring(0, this.saveFileName.lastIndexOf("."));
            }
            if (this.saveFileName.length() > 100) {
                this.saveFileName = this.saveFileName.substring(0, 100);
            }
        }
        this.saveImgName = String.valueOf(this.saveFileName) + UNDERSCORE + String.valueOf(this.processNo) + UNDERSCORE + String.valueOf(paramNo[0]) + String.valueOf(paramNo[1]) + String.valueOf(paramNo[2]) + "_lvimg.png";
        this.saveFileName = String.valueOf(this.saveFileName) + UNDERSCORE + String.valueOf(this.processNo) + UNDERSCORE + String.valueOf(paramNo[0]) + String.valueOf(paramNo[1]) + String.valueOf(paramNo[2]) + "_lowVision.htm";
        File testDir = new File(folder = String.valueOf(folder) + "lowvision" + File.separator);
        if (!testDir.isDirectory()) {
            testDir.mkdirs();
        }
        this.saveFileName = String.valueOf(folder) + this.saveFileName;
        this.strParamNo = paramStr;
        this.problemList = targetList;
        if (this.saveFileName == null) {
            return;
        }
        this.document = probStatisticsDoc;
        this.bSave = true;
        SaveBmpFileThread saveThread = new SaveBmpFileThread();
        saveThread.start();
    }

    public boolean isInSaveReport() {
        return this.bSave;
    }

    public int getNumColorProblem() {
        return this.iColorNum;
    }

    public int getNumFontProblem() {
        return this.iFontNum;
    }

    private String getFileName(String filePath) {
        int index2;
        int index = filePath.lastIndexOf("/");
        if (index < (index2 = filePath.lastIndexOf("\\"))) {
            index = index2;
        }
        if (index > -1) {
            return filePath.substring(index + 1);
        }
        return filePath;
    }

    private class SaveBmpFileThread
    extends Thread {
        private SaveBmpFileThread() {
        }

        private String getArrayString(int[][] data, int item) {
            StringBuffer tmpSB = new StringBuffer();
            try {
                if (data.length > 0) {
                    int i = 0;
                    while (i < data.length) {
                        tmpSB.append(String.valueOf(data[i][item]) + ",");
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return tmpSB.toString();
        }

        private void prepareJavaScript(Writer writer, IProblemItemImage[] problemArray, String imgDir) {
            int size = problemArray.length;
            int[][] data = new int[size][4];
            int i = 0;
            while (i < size) {
                data[i][0] = problemArray[i].getX();
                data[i][1] = problemArray[i].getY();
                data[i][2] = problemArray[i].getWidth();
                data[i][3] = problemArray[i].getHeight();
                ++i;
            }
            try {
                writer.write("<SCRIPT Language=\"JavaScript\">" + FileUtils.LINE_SEP);
                writer.write("var divLeft = new Array(" + this.getArrayString(data, 0) + "0);" + FileUtils.LINE_SEP);
                writer.write("var divTop = new Array(" + this.getArrayString(data, 1) + "0);" + FileUtils.LINE_SEP);
                writer.write("var divWidth = new Array(" + this.getArrayString(data, 2) + "0);" + FileUtils.LINE_SEP);
                writer.write("var divHeight = new Array(" + this.getArrayString(data, 3) + "0);" + FileUtils.LINE_SEP);
                writer.write("var divArray = new Array(" + size + ");" + FileUtils.LINE_SEP);
                writer.write("var sLeft = new Array(" + size + ");" + FileUtils.LINE_SEP);
                writer.write("var sTop = new Array(" + size + ");" + FileUtils.LINE_SEP);
                writer.write("</SCRIPT>" + FileUtils.LINE_SEP);
                writer.write("<SCRIPT><!--" + FileUtils.LINE_SEP);
                writer.write("if(navigator.appName.toLowerCase().indexOf(\"microsoft\")>=0){" + FileUtils.LINE_SEP);
                writer.write("jsFile=\"" + imgDir + "lvHighlight.js\";" + FileUtils.LINE_SEP);
                writer.write("}else{" + FileUtils.LINE_SEP);
                writer.write("jsFile=\"" + imgDir + "lvHighlight_moz.js\";" + FileUtils.LINE_SEP);
                writer.write("}" + FileUtils.LINE_SEP);
                writer.write("document.write(\"<script src=\"+jsFile+\"></script>\");" + FileUtils.LINE_SEP);
                writer.write("-->" + FileUtils.LINE_SEP + "</SCRIPT>" + FileUtils.LINE_SEP);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void run() {
            try {
                String saveDir = SaveReportLowVision.this.saveFileName.substring(0, SaveReportLowVision.this.saveFileName.lastIndexOf("."));
                File tmpFile = new File(saveDir);
                tmpFile.mkdirs();
                String imgDir = saveDir;
                imgDir = String.valueOf(SaveReportLowVision.this.getFileName(imgDir)) + "/";
                saveDir = String.valueOf(saveDir) + File.separator;
                String saveBmpName = String.valueOf(saveDir) + SaveReportLowVision.RESULT_BMP_FILE;
                FileUtils.copyFile((String)SaveReportLowVision.this.vizImageFile.getAbsolutePath(), (String)saveBmpName, (boolean)true);
                PrintWriter fileOutput = new PrintWriter(new FileWriter(SaveReportLowVision.this.saveFileName));
                fileOutput.write("<html><head><title>Report (LowVision) of " + SaveReportLowVision.this.currentUrlS + "</title>");
                IProblemItemImage[] problemLVArray = new IProblemItemImage[SaveReportLowVision.this.problemList.size()];
                SaveReportLowVision.this.problemList.toArray(problemLVArray);
                this.prepareJavaScript(fileOutput, problemLVArray, imgDir);
                fileOutput.write("</head>");
                if (problemLVArray.length > 0) {
                    fileOutput.write("<body onload=\"onloadFunc()\">" + FileUtils.LINE_SEP);
                } else {
                    fileOutput.write("<body>" + FileUtils.LINE_SEP);
                }
                if (SaveReportLowVision.this.reportImageFile != null) {
                    fileOutput.write("<p><FONT>Problem Map</FONT><BR>");
                    fileOutput.write("<img src=\"" + imgDir + SaveReportLowVision.this.saveImgName + "\" height=\"200\" style=\"{border:2 solid black}\">");
                    fileOutput.write("</p><hr>" + FileUtils.LINE_SEP);
                }
                fileOutput.write("<DIV id=\"mother\">");
                fileOutput.write("<img id=\"simImg\" src=\"" + imgDir + SaveReportLowVision.RESULT_BMP_FILE + "\"></DIV>" + FileUtils.LINE_SEP);
                fileOutput.write("<hr>" + FileUtils.LINE_SEP);
                SaveReportLowVision.this.iColorNum = 0;
                SaveReportLowVision.this.iFontNum = 0;
                if (problemLVArray.length > 0) {
                    fileOutput.write("<table border=\"1\">\r\n");
                    fileOutput.write("<tr>");
                    fileOutput.write("<th>" + IProblemConst.TITLE_ICON + "</th>");
                    IGuidelineData[] guidelineDataArray = SaveReportLowVision.this.guidelineHolder.getGuidelineData();
                    int i = 0;
                    while (i < guidelineDataArray.length) {
                        fileOutput.write("<th>" + guidelineDataArray[i].getGuidelineName() + "</th>");
                        ++i;
                    }
                    fileOutput.write("<th>" + IProblemConst.TITLE_DESCRIPTION + "</th>");
                    fileOutput.write("<th>" + IProblemConst.TITLE_SEVERITY + "</th>");
                    fileOutput.write("<th>" + IProblemConst.TITLE_FORECOLOR + "</th>");
                    fileOutput.write("<th>" + IProblemConst.TITLE_BACKCOLOR + "</th>");
                    fileOutput.write("<th>" + IProblemConst.TITLE_X + "</th>");
                    fileOutput.write("<th>" + IProblemConst.TITLE_Y + "</th>");
                    fileOutput.write("<th>" + IProblemConst.TITLE_AREA + "</th>");
                    fileOutput.write("</tr>" + FileUtils.LINE_SEP);
                    LowVisionVizResourceUtil.saveErrorIcons(saveDir);
                    LowVisionVizResourceUtil.saveImages(saveDir);
                    LowVisionVizResourceUtil.saveScripts(saveDir);
                    i = 0;
                    while (i < problemLVArray.length) {
                        fileOutput.write("<tr id=\"" + i + "\" onclick=\"TROnclickFunc(this)\">");
                        int iconId = problemLVArray[i].getIconId();
                        int currentIcon = 0;
                        String strIconName = "";
                        switch (iconId) {
                            case 1: {
                                SaveReportLowVision saveReportLowVision = SaveReportLowVision.this;
                                saveReportLowVision.iColorNum = saveReportLowVision.iColorNum + 1;
                                currentIcon = 0;
                                if (problemLVArray[i].isCanHighlight()) {
                                    strIconName = "HiIro21.gif";
                                    break;
                                }
                                strIconName = "ErrIro21.gif";
                                break;
                            }
                            case 3: {
                                SaveReportLowVision saveReportLowVision = SaveReportLowVision.this;
                                saveReportLowVision.iFontNum = saveReportLowVision.iFontNum + 1;
                                currentIcon = 1;
                                strIconName = problemLVArray[i].isCanHighlight() ? "HiBoke21.gif" : "ErrBoke21.gif";
                            }
                        }
                        fileOutput.write("<td><img src=" + imgDir + strIconName + " alt=\"" + ERROR_IMAGE_ALT[currentIcon] + "\"></td>");
                        String[] guidelineItems = problemLVArray[i].getEvaluationItem().getTableDataGuideline();
                        int j = 0;
                        while (j < guidelineItems.length) {
                            fileOutput.write("<td>" + guidelineItems[j] + "&nbsp;</td>");
                            ++j;
                        }
                        fileOutput.write("<td  STYLE=\"COLOR:blue;TEXT-DECORATION:underline\">" + problemLVArray[i].getDescription() + "&nbsp;</td>");
                        if (problemLVArray[i].getSeverityLV() > 0) {
                            fileOutput.write("<td>" + String.valueOf(problemLVArray[i].getSeverityLV()) + "&nbsp;</td>");
                        } else {
                            fileOutput.write("<td>-&nbsp;</td>");
                        }
                        fileOutput.write("<td>" + problemLVArray[i].getForeground() + "&nbsp;</td>");
                        fileOutput.write("<td>" + problemLVArray[i].getBackground() + "&nbsp;</td>");
                        fileOutput.write("<td>" + String.valueOf(problemLVArray[i].getX()) + "&nbsp;</td>");
                        fileOutput.write("<td>" + String.valueOf(problemLVArray[i].getY()) + "&nbsp;</td>");
                        fileOutput.write("<td>" + String.valueOf(problemLVArray[i].getArea()) + "&nbsp;</td>");
                        fileOutput.write("</tr>" + FileUtils.LINE_SEP);
                        ++i;
                    }
                    fileOutput.write("</table>" + FileUtils.LINE_SEP);
                }
                if (SaveReportLowVision.this.reportImageFile != null) {
                    FileUtils.copyFile((String)SaveReportLowVision.this.reportImageFile.getAbsolutePath(), (String)(String.valueOf(saveDir) + SaveReportLowVision.this.saveImgName), (boolean)true);
                }
                fileOutput.write("</body>" + FileUtils.LINE_SEP);
                fileOutput.write("</html>");
                fileOutput.flush();
                fileOutput.close();
                if (SaveReportLowVision.this.document != null) {
                    int iPos = SaveReportLowVision.this.saveFileName.lastIndexOf("lowvision" + File.separator);
                    String relFile = "lowvision/" + SaveReportLowVision.this.saveFileName.substring(iPos + 10);
                    NodeList tdList = SaveReportLowVision.this.document.getElementsByTagName("td");
                    Element urlEle = (Element)tdList.item(0);
                    Node oldNode = urlEle.getChildNodes().item(0);
                    urlEle.replaceChild(SaveReportLowVision.this.document.createTextNode("URL(" + String.valueOf(SaveReportLowVision.this.processNo) + ")"), oldNode);
                    NodeList tableList = SaveReportLowVision.this.document.getElementsByTagName("tbody");
                    Element tableEle = (Element)tableList.item(0);
                    Element trElement = SaveReportLowVision.this.document.createElement("tr");
                    tableEle.appendChild(trElement);
                    Element tdElement = SaveReportLowVision.this.document.createElement("td");
                    tdElement.setAttribute("width", "600");
                    trElement.appendChild(tdElement);
                    Element aElement = SaveReportLowVision.this.document.createElement("a");
                    aElement.setAttribute("href", relFile);
                    aElement.appendChild(SaveReportLowVision.this.document.createTextNode(SaveReportLowVision.this.currentUrlS));
                    tdElement.appendChild(aElement);
                    tdElement = SaveReportLowVision.this.document.createElement("td");
                    tdElement.appendChild(SaveReportLowVision.this.document.createTextNode(SaveReportLowVision.this.strParamNo));
                    trElement.appendChild(tdElement);
                    tdElement = SaveReportLowVision.this.document.createElement("td");
                    tdElement.appendChild(SaveReportLowVision.this.document.createTextNode(String.valueOf(SaveReportLowVision.this.iColorNum)));
                    trElement.appendChild(tdElement);
                    tdElement = SaveReportLowVision.this.document.createElement("td");
                    tdElement.appendChild(SaveReportLowVision.this.document.createTextNode(String.valueOf(SaveReportLowVision.this.iFontNum)));
                    trElement.appendChild(tdElement);
                }
                SaveReportLowVision.this.bSave = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

