/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.lowvision.ui.preferences;

import java.io.File;
import java.io.InputStream;
import org.eclipse.actf.visualization.engines.lowvision.image.IPageImage;
import org.eclipse.actf.visualization.engines.lowvision.image.PageImageFactory;
import org.eclipse.actf.visualization.lowvision.LowVisionVizPlugin;
import org.eclipse.actf.visualization.lowvision.ui.internal.Messages;
import org.eclipse.actf.visualization.lowvision.ui.internal.PartControlLowVision;
import org.eclipse.actf.visualization.lowvision.util.ParamLowVision;
import org.eclipse.actf.visualization.lowvision.util.SimulateLowVision;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.framework.Bundle;

public class LowVisionPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = LowVisionPreferencePage.class.getName();
    private static final String EYESIGHT_1_0_JP = "1.0";
    private static final String EYESIGHT_0_5_JP = "0.5";
    private static final String EYESIGHT_0_1_JP = "0.1";
    private static final String EYESIGHT_1_0 = "20/20";
    private static final String EYESIGHT_0_5 = "20/40";
    private static final String EYESIGHT_0_1 = "20/200";
    private static final String COLOR_VISION_1 = Messages.DialogSettingLowVision_Protan;
    private static final String COLOR_VISION_2 = Messages.DialogSettingLowVision_Deutan;
    private static final String COLOR_VISION_3 = Messages.DialogSettingLowVision_Tritan;
    private Button _eyesightCheckButton;
    private Label _eyeSightLabel;
    private Slider _eyeSightSlider;
    private Group _colorvisionGroup;
    private Button _colorvisionCheckButton;
    private Button _colorvision1RadioButton;
    private Button _colorvision2RadioButton;
    private Button _colorvision3RadioButton;
    private Button _colorfilterCheckButton;
    private Label _colorfilterNumLabel;
    private Slider _colorFilterSlider;
    private IPageImage _samplePageImage;
    private ImageData[] _sampleImageData;
    private Image _beforeSimulateImage;
    private ImageData _beforeSimulateImageData;
    private Canvas _beforeSimulateImageCanvas;
    private Image _afterSimulateImage;
    private ImageData _afterSimulateImageData;
    private ImageData[] _afterSimulateImageDataArray;
    private Canvas _afterSimulateImageCanvas;
    private ParamLowVision _currentSetting = null;
    private ParamLowVision _appSetting = null;
    private PartControlLowVision _partRightLowVision;
    private File simulationImageFile;

    public void init(IWorkbench workbench) {
        this._appSetting = ParamLowVision.getDefaultInstance();
        this._currentSetting = (ParamLowVision)this._appSetting.clone();
        this.initSampleImage();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.createSettingControlsPart(composite);
        this.createSampleImagePart(composite);
        return parent;
    }

    public boolean performOk() {
        this.setNewValue(this._appSetting);
        return true;
    }

    protected void performApply() {
        this.performOk();
    }

    private void initSampleImage() {
        Bundle lvBundle = LowVisionVizPlugin.getDefault().getBundle();
        try {
            this._samplePageImage = PageImageFactory.createPageImage((InputStream)FileLocator.openStream((Bundle)lvBundle, (IPath)new Path("vizResources/images/LowVisionSample.bmp"), (boolean)false));
        }
        catch (Exception exception) {
            this._samplePageImage = PageImageFactory.createPageImage();
        }
        this._sampleImageData = new ImageData[0];
        try {
            ImageLoader imageLoader = new ImageLoader();
            this._sampleImageData = imageLoader.load(FileLocator.openStream((Bundle)lvBundle, (IPath)new Path("vizResources/images/LowVisionSample.bmp"), (boolean)false));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.simulationImageFile == null) {
            try {
                this.simulationImageFile = LowVisionVizPlugin.createTempFile("preference", ".bmp");
            }
            catch (Exception exception) {}
        }
    }

    private void createSettingControlsPart(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.createEyeSightControl(composite);
        new Label(composite, 0);
        this.createColorVisionControl(composite);
        new Label(composite, 0);
        this.createColorFilterControl(composite);
    }

    private void createEyeSightControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this._eyesightCheckButton = new Button(composite, 32);
        this._eyesightCheckButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this._eyesightCheckButton.setText(Messages.DialogSettingLowVision_Eyesight_9);
        this._eyesightCheckButton.setSelection(this._appSetting.useEyeSight());
        this._eyesightCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (LowVisionPreferencePage.this._partRightLowVision != null && LowVisionPreferencePage.this._partRightLowVision.isChildThread()) {
                    LowVisionPreferencePage.this._eyeSightSlider.setVisible(((Button)event.widget).getSelection());
                } else {
                    LowVisionPreferencePage.this._eyeSightSlider.setEnabled(((Button)event.widget).getSelection());
                }
                LowVisionPreferencePage.this.doSimulate();
            }
        });
        Composite sliderComposite = new Composite(composite, 0);
        sliderComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        layout = new GridLayout();
        layout.numColumns = 3;
        sliderComposite.setLayout((Layout)layout);
        Label eyeSightLable11 = new Label(sliderComposite, 0);
        eyeSightLable11.setText(EYESIGHT_0_1);
        eyeSightLable11.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        Label eyeSightLable12 = new Label(sliderComposite, 0);
        eyeSightLable12.setText(EYESIGHT_0_5);
        GridData gridData = new GridData(0x1000000, 0x1000000, true, false);
        eyeSightLable12.setLayoutData((Object)gridData);
        Label eyeSightLable13 = new Label(sliderComposite, 0);
        eyeSightLable13.setText(EYESIGHT_1_0);
        eyeSightLable13.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        Label eyeSightLable21 = new Label(sliderComposite, 0);
        eyeSightLable21.setText(EYESIGHT_0_1_JP);
        eyeSightLable21.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        Label eyeSightLable22 = new Label(sliderComposite, 0);
        eyeSightLable22.setText(EYESIGHT_0_5_JP);
        gridData = new GridData(0x1000000, 0x1000000, true, false);
        eyeSightLable22.setLayoutData((Object)gridData);
        Label eyeSightLable23 = new Label(sliderComposite, 0);
        eyeSightLable23.setText(EYESIGHT_1_0_JP);
        eyeSightLable23.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this._eyeSightSlider = new Slider(sliderComposite, 0);
        this._eyeSightSlider.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this._eyeSightSlider.setMinimum(10);
        this._eyeSightSlider.setMaximum(101);
        this._eyeSightSlider.setIncrement(10);
        this._eyeSightSlider.setPageIncrement(10);
        this._eyeSightSlider.setThumb(1);
        this._eyeSightSlider.setSelection(this._appSetting.getEyeSightValue());
        if (this._partRightLowVision != null && this._partRightLowVision.isChildThread()) {
            this._eyeSightSlider.setVisible(this._eyesightCheckButton.getSelection());
        } else {
            this._eyeSightSlider.setEnabled(this._eyesightCheckButton.getSelection());
        }
        this._eyeSightSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LowVisionPreferencePage.this.doSimulate();
            }
        });
        this._eyeSightLabel = new Label(composite, 0);
        gridData = new GridData(32);
        gridData.horizontalIndent = 10;
        gridData.widthHint = 25;
        this._eyeSightLabel.setLayoutData((Object)gridData);
    }

    private void createColorVisionControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite.setLayout((Layout)new GridLayout());
        this._colorvisionCheckButton = new Button(composite, 32);
        this._colorvisionCheckButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this._colorvisionCheckButton.setText(Messages.DialogSettingLowVision_Color_Vision_Deficiency_10);
        this._colorvisionCheckButton.setSelection(this._appSetting.useColorVision());
        this._colorvisionCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LowVisionPreferencePage.this._colorvisionGroup.setEnabled(((Button)event.widget).getSelection());
                LowVisionPreferencePage.this._colorvision1RadioButton.setEnabled(((Button)event.widget).getSelection());
                LowVisionPreferencePage.this._colorvision2RadioButton.setEnabled(((Button)event.widget).getSelection());
                LowVisionPreferencePage.this._colorvision3RadioButton.setEnabled(((Button)event.widget).getSelection());
                LowVisionPreferencePage.this.doSimulate();
            }
        });
        this._colorvisionGroup = new Group(composite, 0);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this._colorvisionGroup.setLayoutData((Object)gridData);
        this._colorvisionGroup.setLayout((Layout)new GridLayout());
        this._colorvision1RadioButton = new Button((Composite)this._colorvisionGroup, 16);
        this._colorvision1RadioButton.setText(COLOR_VISION_1);
        this._colorvision2RadioButton = new Button((Composite)this._colorvisionGroup, 16);
        this._colorvision2RadioButton.setText(COLOR_VISION_2);
        this._colorvision3RadioButton = new Button((Composite)this._colorvisionGroup, 16);
        this._colorvision3RadioButton.setText(COLOR_VISION_3);
        int colorVisionValue = this._appSetting.getColorVisionValue();
        switch (colorVisionValue) {
            case 1: {
                this._colorvision1RadioButton.setSelection(true);
                break;
            }
            case 2: {
                this._colorvision2RadioButton.setSelection(true);
                break;
            }
            case 3: {
                this._colorvision3RadioButton.setSelection(true);
                break;
            }
            default: {
                this._colorvision1RadioButton.setSelection(true);
            }
        }
        SelectionAdapter selectionListener2 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LowVisionPreferencePage.this.doSimulate();
                if (!((Button)event.widget).getSelection()) {
                    return;
                }
            }
        };
        this._colorvision1RadioButton.addSelectionListener((SelectionListener)selectionListener2);
        this._colorvision2RadioButton.addSelectionListener((SelectionListener)selectionListener2);
        this._colorvision3RadioButton.addSelectionListener((SelectionListener)selectionListener2);
        this._colorvisionGroup.setEnabled(this._colorvisionCheckButton.getSelection());
        this._colorvision1RadioButton.setEnabled(this._colorvisionCheckButton.getSelection());
        this._colorvision2RadioButton.setEnabled(this._colorvisionCheckButton.getSelection());
        this._colorvision3RadioButton.setEnabled(this._colorvisionCheckButton.getSelection());
    }

    private void createColorFilterControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this._colorfilterCheckButton = new Button(composite, 32);
        this._colorfilterCheckButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this._colorfilterCheckButton.setText(Messages.DialogSettingLowVision_Crystalline_lens);
        this._colorfilterCheckButton.setSelection(this._appSetting.useEyeSight());
        this._colorfilterCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (LowVisionPreferencePage.this._partRightLowVision != null && LowVisionPreferencePage.this._partRightLowVision.isChildThread()) {
                    LowVisionPreferencePage.this._colorFilterSlider.setVisible(((Button)event.widget).getSelection());
                } else {
                    LowVisionPreferencePage.this._colorFilterSlider.setEnabled(((Button)event.widget).getSelection());
                }
                LowVisionPreferencePage.this.doSimulate();
            }
        });
        Composite colorFilterComposite = new Composite(composite, 0);
        colorFilterComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        layout = new GridLayout();
        layout.numColumns = 3;
        colorFilterComposite.setLayout((Layout)layout);
        Label colorfilterLable1 = new Label(colorFilterComposite, 0);
        colorfilterLable1.setText(Messages.DialogSettingLowVision_60);
        colorfilterLable1.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        Label colorfilterLable2 = new Label(colorFilterComposite, 0);
        colorfilterLable2.setText(Messages.DialogSettingLowVision_40);
        colorfilterLable2.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        Label colorfilterLable3 = new Label(colorFilterComposite, 0);
        colorfilterLable3.setText(Messages.DialogSettingLowVision_20);
        colorfilterLable3.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this._colorFilterSlider = new Slider(colorFilterComposite, 0);
        this._colorFilterSlider.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this._colorFilterSlider.setMinimum(60);
        this._colorFilterSlider.setMaximum(101);
        this._colorFilterSlider.setIncrement(5);
        this._colorFilterSlider.setPageIncrement(10);
        this._colorFilterSlider.setThumb(1);
        this._colorFilterSlider.setSelection(this._appSetting.getColorFilterValue());
        if (this._partRightLowVision != null && this._partRightLowVision.isChildThread()) {
            this._colorFilterSlider.setVisible(this._colorfilterCheckButton.getSelection());
        } else {
            this._colorFilterSlider.setEnabled(this._colorfilterCheckButton.getSelection());
        }
        this._colorFilterSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LowVisionPreferencePage.this.doSimulate();
            }
        });
        this._colorfilterNumLabel = new Label(composite, 0);
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = 10;
        gridData.widthHint = 25;
        this._colorfilterNumLabel.setLayoutData((Object)gridData);
    }

    private void createSampleImagePart(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        Label labelOriginal = new Label(composite, 0);
        labelOriginal.setText(Messages.DialogSettingLowVision_Original__24);
        this._beforeSimulateImageCanvas = new Canvas(composite, 0x100000);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 320;
        gridData.heightHint = 130;
        this._beforeSimulateImageCanvas.setLayoutData((Object)gridData);
        this._beforeSimulateImageCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (LowVisionPreferencePage.this._beforeSimulateImage != null) {
                    LowVisionPreferencePage.this.paintBeforeSimulateImage(event);
                }
            }
        });
        Label labelBlank = new Label(composite, 0);
        labelBlank.setText(" ");
        gridData = new GridData();
        gridData.heightHint = 20;
        labelBlank.setLayoutData((Object)gridData);
        Label labelAfterSimulation = new Label(composite, 0);
        labelAfterSimulation.setText(Messages.DialogSettingLowVision_After_simulation);
        this._afterSimulateImageCanvas = new Canvas(composite, 0x100000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 320;
        gridData.heightHint = 130;
        this._afterSimulateImageCanvas.setLayoutData((Object)gridData);
        this._afterSimulateImageCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (LowVisionPreferencePage.this._afterSimulateImage != null) {
                    LowVisionPreferencePage.this.paintAfterSimulateImage(event);
                }
            }
        });
        this.initImageBeforeSimulate(parent);
        this.doSimulate();
    }

    private void initImageBeforeSimulate(Composite parent) {
        try {
            int i = 0;
            while (i < this._sampleImageData.length) {
                this.displayImageBeforeSimulate(this._sampleImageData[i]);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void displayImageBeforeSimulate(ImageData newImageData) {
        if (this._beforeSimulateImage != null) {
            this._beforeSimulateImage.dispose();
        }
        try {
            this._beforeSimulateImage = new Image((Device)this.getShell().getDisplay(), newImageData);
            this._beforeSimulateImageData = newImageData;
        }
        catch (SWTException swte) {
            swte.printStackTrace();
            this._beforeSimulateImage = null;
            return;
        }
        this._beforeSimulateImageCanvas.redraw();
    }

    private void displayImageAfterSimulate(ImageData newImageData) {
        if (this._afterSimulateImage != null) {
            this._afterSimulateImage.dispose();
        }
        try {
            this._afterSimulateImage = new Image((Device)this.getShell().getDisplay(), newImageData);
            this._afterSimulateImageData = newImageData;
        }
        catch (SWTException e) {
            e.printStackTrace();
            this._afterSimulateImage = null;
            return;
        }
        this._afterSimulateImageCanvas.redraw();
    }

    private void doSimulate() {
        try {
            this.setNewValue(this._currentSetting);
            this._afterSimulateImageDataArray = SimulateLowVision.doSimulate(this._samplePageImage, this._currentSetting, this.simulationImageFile.getAbsolutePath());
            int i = 0;
            while (i < this._afterSimulateImageDataArray.length) {
                this.displayImageAfterSimulate(this._afterSimulateImageDataArray[i]);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void paintBeforeSimulateImage(PaintEvent event) {
        event.gc.drawImage(this._beforeSimulateImage, 0, 0, this._beforeSimulateImageData.width, this._beforeSimulateImageData.height, this._beforeSimulateImageData.x, this._beforeSimulateImageData.y, Math.round(this._beforeSimulateImageData.width), Math.round(this._beforeSimulateImageData.height));
    }

    private void paintAfterSimulateImage(PaintEvent event) {
        event.gc.drawImage(this._afterSimulateImage, 0, 0, this._afterSimulateImageData.width, this._afterSimulateImageData.height, this._afterSimulateImageData.x, this._afterSimulateImageData.y, Math.round(this._afterSimulateImageData.width), Math.round(this._afterSimulateImageData.height));
    }

    private void setNewValue(ParamLowVision currParam) {
        String str;
        currParam.setEyeSight(this._eyesightCheckButton.getSelection());
        if (currParam.useEyeSight()) {
            currParam.setEyeSightValue(this._eyeSightSlider.getSelection());
            int sliderValue = this._eyeSightSlider.getSelection();
            str = sliderValue < 100 ? "0." + String.valueOf(sliderValue) : "1.00";
            this._eyeSightLabel.setText(str);
        } else {
            this._eyeSightLabel.setText("");
        }
        currParam.setColorVision(this._colorvisionCheckButton.getSelection());
        if (currParam.useColorVision()) {
            if (this._colorvision1RadioButton.getSelection()) {
                currParam.setColorVisionValue(1);
            } else if (this._colorvision2RadioButton.getSelection()) {
                currParam.setColorVisionValue(2);
            } else {
                currParam.setColorVisionValue(3);
            }
        }
        currParam.setColorFilter(this._colorfilterCheckButton.getSelection());
        if (currParam.useColorFilter()) {
            currParam.setColorFilterValue(this._colorFilterSlider.getSelection());
            int iAge = 120 - this._colorFilterSlider.getSelection();
            str = String.valueOf(iAge);
            this._colorfilterNumLabel.setText(str);
        } else {
            this._colorfilterNumLabel.setText("");
        }
    }
}

