/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.addons;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.commands.MHandlerContainer;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class HandlerProcessingAddon {
    private EventHandler eventHandler;
    private EventHandler contextHandler;
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    public void postConstruct(MApplication application, EModelService modelService) {
        List<MHandlerContainer> findElements = modelService.findElements((MUIElement)application, null, MHandlerContainer.class, null);
        for (MHandlerContainer mHandlerContainer : findElements) {
            MContext mContext;
            IEclipseContext context;
            if (!(mHandlerContainer instanceof MContext) || (context = (mContext = (MContext)mHandlerContainer).getContext()) == null) continue;
            for (MHandler mHandler : mHandlerContainer.getHandlers()) {
                this.processActiveHandler(mHandler, context);
            }
        }
        this.registerModelListeners();
    }

    private void registerModelListeners() {
        this.eventHandler = new EventHandler(){

            public void handleEvent(Event event) {
                if (event.getProperty("ChangedElement") instanceof MHandlerContainer && event.getProperty("ChangedElement") instanceof MContext) {
                    MHandlerContainer handlerContainer = (MHandlerContainer)event.getProperty("ChangedElement");
                    if ("ADD".equals(event.getProperty("EventType"))) {
                        if (event.getProperty("NewValue") instanceof MHandler) {
                            MHandler handler = (MHandler)event.getProperty("NewValue");
                            MContext mContext = (MContext)handlerContainer;
                            IEclipseContext context = mContext.getContext();
                            if (context != null) {
                                HandlerProcessingAddon.this.processActiveHandler(handler, context);
                            }
                        }
                    } else if ("REMOVE".equals(event.getProperty("EventType")) && event.getProperty("OldValue") instanceof MHandler) {
                        MCommand command;
                        MHandler handler = (MHandler)event.getProperty("OldValue");
                        MContext mContext = (MContext)handlerContainer;
                        IEclipseContext context = mContext.getContext();
                        if (context != null && (command = handler.getCommand()) != null) {
                            String commandId = command.getElementId();
                            EHandlerService handlerService = (EHandlerService)context.get(EHandlerService.class.getName());
                            handlerService.deactivateHandler(commandId, handler.getObject());
                        }
                    }
                }
            }
        };
        this.contextHandler = new EventHandler(){

            public void handleEvent(Event event) {
                Object origin = event.getProperty("ChangedElement");
                Object context = event.getProperty("NewValue");
                if (origin instanceof MHandlerContainer && "SET".equals(event.getProperty("EventType")) && context instanceof IEclipseContext) {
                    MHandlerContainer handlerContainer = (MHandlerContainer)origin;
                    IEclipseContext castedContext = (IEclipseContext)context;
                    for (MHandler mHandler : handlerContainer.getHandlers()) {
                        HandlerProcessingAddon.this.processActiveHandler(mHandler, castedContext);
                    }
                }
            }
        };
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/commands/HandlerContainer/handlers/*", this.eventHandler);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/Context/context/*", this.contextHandler);
    }

    @PreDestroy
    public void preDestroy() {
        this.unregisterModelListeners();
    }

    private void unregisterModelListeners() {
        this.eventBroker.unsubscribe(this.eventHandler);
        this.eventBroker.unsubscribe(this.contextHandler);
    }

    private void processActiveHandler(MHandler handler, IEclipseContext context) {
        MCommand command = handler.getCommand();
        if (command != null) {
            String commandId = command.getElementId();
            if (handler.getObject() == null) {
                IContributionFactory contributionFactory = (IContributionFactory)context.get(IContributionFactory.class.getName());
                handler.setObject(contributionFactory.create(handler.getContributionURI(), context));
            }
            EHandlerService handlerService = (EHandlerService)context.get(EHandlerService.class.getName());
            handlerService.activateHandler(commandId, handler.getObject());
        }
    }
}

