/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash.proxy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import org.eclipse.actf.model.flash.transcoder.ISwfTranscoder;
import org.eclipse.actf.model.flash.transcoder.ISwfTranscoderFactory;
import org.eclipse.actf.model.internal.flash.bridge.WaXcodingConfig;
import org.eclipse.actf.model.internal.flash.proxy.SWFUtil;
import org.eclipse.actf.util.httpproxy.core.IHTTPHeader;
import org.eclipse.actf.util.httpproxy.core.IHTTPRequestMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponseMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponsePushbackMessage;
import org.eclipse.actf.util.httpproxy.core.IPushbackMessageBody;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPProxyTranscoder;
import org.eclipse.actf.util.httpproxy.util.HTTPUtil;
import org.eclipse.actf.util.httpproxy.util.Logger;

public class ProxyTranscoderSWF
implements IHTTPProxyTranscoder {
    private static final Logger LOGGER = Logger.getLogger(ProxyTranscoderSWF.class);
    private static final ISwfTranscoderFactory swfTranscoderFactory = ProxyTranscoderSWF.getSwfTranscoderFactory();
    private final ISwfTranscoder swfTranscoder;
    private static Object imposedSWF;

    private static ISwfTranscoderFactory getSwfTranscoderFactory() {
        try {
            Class<?> clazz = Class.forName("org.eclipse.actf.util.swftranscoder.SwfTranscoderFactory");
            return (ISwfTranscoderFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ProxyTranscoderSWF(int n) {
        this.swfTranscoder = swfTranscoderFactory.newInstance(n);
    }

    protected static ProxyTranscoderSWF newInstance(int n) {
        if (swfTranscoderFactory == null) {
            return null;
        }
        return new ProxyTranscoderSWF(n);
    }

    public static void setSWFTranscodingImposedFile(InputStream inputStream) {
        if (swfTranscoderFactory == null) {
            return;
        }
        ISwfTranscoder iSwfTranscoder = swfTranscoderFactory.newInstance(0);
        try {
            imposedSWF = iSwfTranscoder.parse(inputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private File getTemporaryDestSWF(File file) throws IOException {
        return new File(String.valueOf(file.getAbsolutePath()) + ".out");
    }

    private File getTemporarySrcSWF() throws IOException {
        return File.createTempFile("SWFTC-", ".swf");
    }

    private boolean isTranscodeTarget(int n, IHTTPRequestMessage iHTTPRequestMessage, IHTTPResponsePushbackMessage iHTTPResponsePushbackMessage) {
        if (iHTTPRequestMessage.getHeader(SWFUtil.X_FLASH_VERSION_A) == null) {
            return false;
        }
        if (!SWFUtil.isPossiblySWFContentType((IHTTPResponseMessage)iHTTPResponsePushbackMessage)) {
            return false;
        }
        IPushbackMessageBody iPushbackMessageBody = iHTTPResponsePushbackMessage.getPushbackMessageBody();
        if (iPushbackMessageBody == null) {
            return false;
        }
        PushbackInputStream pushbackInputStream = iPushbackMessageBody.getMessageBodyPushBackInputStream();
        int n2 = SWFUtil.isSWF(pushbackInputStream);
        if (n2 >= WaXcodingConfig.getInstance().getSWFTranscodingMinimumVersion()) {
            LOGGER.info("[id:" + n + "] SWTTranscoder: SWF to be transcoded (" + iHTTPRequestMessage.getOriginalRequestURIString() + ")- Version:" + n2);
            return true;
        }
        if (n2 > 0) {
            LOGGER.info("[id:" + n + "] SWTTranscoder: SWF not to be transcoded (" + iHTTPRequestMessage.getOriginalRequestURIString() + ")- Version:" + n2);
        }
        return false;
    }

    private void outputFailureLog(StringBuffer stringBuffer, IHTTPRequestMessage iHTTPRequestMessage, File file, Throwable throwable) {
        stringBuffer.append("(");
        stringBuffer.append(iHTTPRequestMessage.getOriginalRequestURIString());
        stringBuffer.append(")\n");
        stringBuffer.append(this.stackTraceToString(throwable));
        if (LOGGER.isDebugEnabled() && file != null) {
            stringBuffer.append("The SWF file is secured in ");
            stringBuffer.append(file.getAbsolutePath());
            stringBuffer.append("\n");
        }
        LOGGER.fatal(stringBuffer.toString());
    }

    private File saveSWFFile(File file, byte[] byArray) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            File file2 = file;
            return file2;
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    private String stackTraceToString(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        return byteArrayOutputStream.toString();
    }

    public IHTTPResponseMessage transcode(int n, IHTTPRequestMessage iHTTPRequestMessage, IHTTPResponseMessage iHTTPResponseMessage) {
        byte[] byArray;
        Object object;
        if (!WaXcodingConfig.getInstance().getSWFTranscodingFlag()) {
            return iHTTPResponseMessage;
        }
        if (imposedSWF == null) {
            return iHTTPResponseMessage;
        }
        IHTTPResponsePushbackMessage iHTTPResponsePushbackMessage = HTTPUtil.createHTTPResponsePushbackMessage((IHTTPResponseMessage)iHTTPResponseMessage, (int)4);
        if (!this.isTranscodeTarget(n, iHTTPRequestMessage, iHTTPResponsePushbackMessage)) {
            return iHTTPResponsePushbackMessage;
        }
        File file = null;
        File file2 = null;
        try {
            file = this.getTemporarySrcSWF();
            try {
                object = iHTTPResponsePushbackMessage.readBody(0L, false);
            }
            catch (TimeoutException timeoutException) {
                LOGGER.fatal("[id:" + n + "] Message body cannot be read by timeout.");
                return HTTPUtil.createHTTPResponseInMemoryMessage((long)iHTTPRequestMessage.getSerial(), (byte[])IHTTPHeader.HTTP_VERSION_1_0_A, (byte[])"504".getBytes(), (byte[])"Gateway Timeout".getBytes(), (byte[])IHTTPResponseMessage.EMPTY_BODY);
            }
            if (object == null) {
                return iHTTPResponseMessage;
            }
            if (LOGGER.isDebugEnabled()) {
                this.saveSWFFile(file, (byte[])object);
            }
            Object object2 = this.swfTranscoder.parse(new ByteArrayInputStream((byte[])object));
            Object object3 = this.swfTranscoder.impose(imposedSWF, object2);
            byArray = this.swfTranscoder.generate(object3, false, 8);
            file2 = this.getTemporaryDestSWF(file);
            if (LOGGER.isDebugEnabled()) {
                this.saveSWFFile(file2, byArray);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return iHTTPResponseMessage;
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("SWF transcoding failed ");
            this.outputFailureLog(stringBuffer, iHTTPRequestMessage, file, exception);
            return iHTTPResponseMessage;
        }
        object = HTTPUtil.createHTTPResponseInMemoryMessage((IHTTPResponseMessage)iHTTPResponseMessage, (byte[])byArray);
        return object;
    }
}

