/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.html.impl;

import org.eclipse.actf.model.internal.dom.html.impl.SHDocument;
import org.eclipse.actf.model.internal.dom.html.impl.SHElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableRowElement;

public class SHTableCellElement
extends SHElement
implements HTMLTableCellElement {
    private static final long serialVersionUID = 4538969444602022762L;

    protected SHTableCellElement(String name, SHDocument doc) {
        super(name, doc);
    }

    public int getCellIndex() {
        Node parent = this.getParentNode();
        if (parent instanceof HTMLTableRowElement) {
            int ret = 0;
            Node prev = this.getPreviousSibling();
            while (prev != null) {
                ++ret;
                prev = prev.getPreviousSibling();
            }
            return ret;
        }
        int ret = 0;
        Node prev = this.getPreviousSibling();
        while (prev != null && !(prev instanceof HTMLTableRowElement)) {
            ++ret;
            prev = prev.getPreviousSibling();
        }
        return ret;
    }

    public void setCellIndex(int cellIndex) {
        if (cellIndex < 0) {
            return;
        }
        Node parent = this.getParentNode();
        if (parent instanceof HTMLTableRowElement) {
            parent.removeChild(this);
            NodeList siblings = parent.getChildNodes();
            if (siblings.getLength() <= cellIndex) {
                parent.insertBefore(this, null);
            } else {
                parent.insertBefore(this, siblings.item(cellIndex));
            }
        } else {
            Node leftMost = this;
            Node prev = this.getPreviousSibling();
            while (prev != null && !(prev instanceof HTMLTableRowElement)) {
                leftMost = prev;
                prev = prev.getPreviousSibling();
            }
            parent.removeChild(this);
            Node before = leftMost;
            int i = 0;
            while (i < cellIndex) {
                Node next = before.getNextSibling();
                if (next == null || next instanceof HTMLTableRowElement) {
                    parent.insertBefore(this, null);
                    return;
                }
                before = before.getNextSibling();
                ++i;
            }
            parent.insertBefore(this, before);
        }
    }

    public String getAbbr() {
        return this.getAttribute("abbr");
    }

    public void setAbbr(String abbr) {
        this.setAttribute("abbr", abbr);
    }

    public String getAlign() {
        return this.getAttribute("align");
    }

    public void setAlign(String align) {
        this.setAttribute("aling", align);
    }

    public String getAxis() {
        return this.getAttribute("axis");
    }

    public void setAxis(String axis) {
        this.setAttribute("axis", axis);
    }

    public String getBgColor() {
        return this.getAttribute("bgcolor");
    }

    public void setBgColor(String bgColor) {
        this.setAttribute("bgcolor", bgColor);
    }

    public String getCh() {
        return this.getAttribute("char");
    }

    public void setCh(String ch) {
        this.setAttribute("char", ch);
    }

    public String getChOff() {
        return this.getAttribute("charoff");
    }

    public void setChOff(String chOff) {
        this.setAttribute("charoff", chOff);
    }

    public int getColSpan() {
        return Integer.parseInt(this.getAttribute("colspan"));
    }

    public void setColSpan(int colSpan) {
        this.setAttribute("colspan", Integer.toString(colSpan));
    }

    public String getHeaders() {
        return this.getAttribute("headers");
    }

    public void setHeaders(String headers) {
        this.setAttribute("headers", headers);
    }

    public String getHeight() {
        return this.getAttribute("height");
    }

    public void setHeight(String height) {
        this.setAttribute("height", height);
    }

    public boolean getNoWrap() {
        String val = this.getAttribute("nowrap");
        return val != null && val.length() != 0;
    }

    public void setNoWrap(boolean noWrap) {
        this.setAttribute("nowrap", noWrap ? "nowrap" : null);
    }

    public int getRowSpan() {
        return Integer.parseInt(this.getAttribute("rowspan"));
    }

    public void setRowSpan(int rowSpan) {
        this.setAttribute("rowspan", Integer.toString(rowSpan));
    }

    public String getScope() {
        return this.getAttribute("scope");
    }

    public void setScope(String scope) {
        this.setAttribute("scope", scope);
    }

    public String getVAlign() {
        return this.getAttribute("valign");
    }

    public void setVAlign(String vAlign) {
        this.setAttribute("valign", vAlign);
    }

    public String getWidth() {
        return this.getAttribute("width");
    }

    public void setWidth(String width) {
        this.setAttribute("width", width);
    }
}

