/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.ui.report;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.actf.ui.util.PlatformUIUtil;
import org.eclipse.actf.visualization.eval.IEvaluationResult;
import org.eclipse.actf.visualization.eval.problem.IProblemConst;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.internal.ui.report.table.ResultTableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemTree {
    private Tree tree;
    private TreeItem nodeRoot;
    private TreeItem node1_1;
    private TreeItem node1_2;
    private TreeItem node1_3;
    private TreeItem node1_4;
    private ResultTableViewer _resultTableViewer = null;

    public ProblemTree(Composite parent) {
        this.tree = new Tree(parent, 2050);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.tree.setLayoutData((Object)gridData);
        this.createTreeNodes();
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (ProblemTree.this._resultTableViewer != null) {
                    TreeItem[] targets = ProblemTree.this.tree.getSelection();
                    if (targets != null) {
                        int result = 0;
                        int i = 0;
                        while (i < targets.length) {
                            TreeItem item = targets[i];
                            if (item == ProblemTree.this.nodeRoot) {
                                ProblemTree.this._resultTableViewer.changeFilterType(Integer.MAX_VALUE);
                                return;
                            }
                            if (item == ProblemTree.this.node1_1) {
                                result |= 1;
                            } else if (item == ProblemTree.this.node1_2) {
                                result |= 2;
                            } else if (item == ProblemTree.this.node1_3) {
                                result |= 4;
                            } else if (item == ProblemTree.this.node1_4) {
                                result |= 8;
                            }
                            ++i;
                        }
                        ProblemTree.this._resultTableViewer.changeFilterType(result);
                        return;
                    }
                    ProblemTree.this._resultTableViewer.changeFilterType(Integer.MAX_VALUE);
                }
            }
        });
    }

    public void createTreeNodes() {
        this.tree.removeAll();
        this.nodeRoot = new TreeItem(this.tree, 0);
        this.nodeRoot.setImage(PlatformUIUtil.getSharedImageDescriptor((String)"IMG_OBJ_FOLDER").createImage());
        this.node1_1 = new TreeItem(this.nodeRoot, 0);
        this.node1_1.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.actf.visualization.eval", (String)"icons/Err.png").createImage());
        this.node1_2 = new TreeItem(this.nodeRoot, 0);
        this.node1_2.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.actf.visualization.eval", (String)"icons/Warn.png").createImage());
        this.node1_3 = new TreeItem(this.nodeRoot, 0);
        this.node1_3.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.actf.visualization.eval", (String)"icons/Conf.png").createImage());
        this.node1_4 = new TreeItem(this.nodeRoot, 0);
        this.node1_4.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.actf.visualization.eval", (String)"icons/Info.png").createImage());
        this.nodeRoot.setExpanded(true);
        this.clearTreeNodeAmount();
    }

    public Tree getTree() {
        return this.tree;
    }

    public void setRootSel() {
        this.tree.setSelection(new TreeItem[]{this.nodeRoot});
    }

    public void clearTreeNodeAmount() {
        this.changeTreeNodeAmount(new ArrayList<IProblemItem>());
        this.tree.getDisplay().update();
    }

    public void changeTreeNodeAmount(List<IProblemItem> targetList) {
        int error = 0;
        int warn = 0;
        int user = 0;
        int info = 0;
        Iterator<IProblemItem> i = targetList.iterator();
        while (i.hasNext()) {
            try {
                switch (i.next().getSeverity()) {
                    case 1: {
                        ++error;
                        break;
                    }
                    case 2: {
                        ++warn;
                        break;
                    }
                    case 4: {
                        ++user;
                        break;
                    }
                    case 8: {
                        ++info;
                    }
                }
            }
            catch (Exception exception) {}
        }
        int all = error + user + info;
        this.nodeRoot.setText(String.valueOf(IProblemConst.ALL_ERRORS) + "  (" + all + ")");
        this.node1_1.setText(String.valueOf(IProblemConst.ESSENTIAL) + "  (" + error + ")");
        this.node1_2.setText(String.valueOf(IProblemConst.WARNING) + "  (" + warn + ")");
        this.node1_3.setText(String.valueOf(IProblemConst.USER_CHECK) + " (" + user + ")");
        this.node1_4.setText(String.valueOf(IProblemConst.INFO) + " (" + info + ")");
    }

    public void setResultTableViewer(ResultTableViewer resultTableViewer) {
        this._resultTableViewer = resultTableViewer;
    }

    public ResultTableViewer getResultTableViewer() {
        return this._resultTableViewer;
    }

    public void setResult(IEvaluationResult result) {
        this.changeTreeNodeAmount(result.getProblemList());
    }
}

