/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.ui.report.table;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.visualization.eval.IEvaluationResult;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.guideline.GuidelineSelectionChangedEvent;
import org.eclipse.actf.visualization.eval.guideline.IGuidelineData;
import org.eclipse.actf.visualization.eval.guideline.IGuidelineSlectionChangedListener;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetSourceInfo;
import org.eclipse.actf.visualization.eval.problem.IProblemConst;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.internal.ui.report.ReportMessageDialog;
import org.eclipse.actf.visualization.internal.ui.report.action.ClearSelectionAction;
import org.eclipse.actf.visualization.internal.ui.report.action.CopyAction;
import org.eclipse.actf.visualization.internal.ui.report.action.GuidelineSubMenu;
import org.eclipse.actf.visualization.internal.ui.report.action.ShowDescriptionAction;
import org.eclipse.actf.visualization.internal.ui.report.action.SrcHighlightAction;
import org.eclipse.actf.visualization.internal.ui.report.action.TechniquesSubMenu;
import org.eclipse.actf.visualization.internal.ui.report.srcviewer.SrcViewerForPT;
import org.eclipse.actf.visualization.internal.ui.report.table.ResultTableFilter;
import org.eclipse.actf.visualization.ui.IVisualizationView;
import org.eclipse.actf.visualization.ui.report.table.IResultTableSorter;
import org.eclipse.actf.visualization.ui.report.table.ResultTableSorter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ResultTableViewer
implements IGuidelineSlectionChangedListener {
    private GuidelineHolder guidelineHolder = GuidelineHolder.getInstance();
    private int mode = 0;
    private Table table;
    private ViewerSorter tableSorter = new ResultTableSorter();
    private ResultTableFilter tableFilter;
    private TableViewer tableViewer;
    private SrcViewerForPT srcViewerForPT;
    private int curMode = -1;
    private File currentSoruceFile;
    private SrcHighlightAction srcHighlightAction;
    private boolean isShowAllGuidelineItems = false;
    private Shell shell;

    public ResultTableViewer(Composite parent) {
        this.shell = parent.getShell();
        this.tableViewer = new TableViewer(parent, 67586);
        this.table = this.tableViewer.getTable();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.srcViewerForPT = SrcViewerForPT.initSrcViewerForPT(parent.getShell());
        this.initColumns();
        this.changeColumnLayout();
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableFilter = new ResultTableFilter();
        this.tableViewer.addFilter((ViewerFilter)this.tableFilter);
        MenuManager popupMenu = new MenuManager();
        popupMenu.add((IAction)new ClearSelectionAction(this.tableViewer));
        popupMenu.add((IContributionItem)new GuidelineSubMenu(this));
        popupMenu.add((IContributionItem)new TechniquesSubMenu(this));
        this.srcHighlightAction = new SrcHighlightAction(this);
        this.srcHighlightAction.setEnabled(false);
        popupMenu.add((IAction)this.srcHighlightAction);
        popupMenu.add((IAction)new CopyAction(this));
        popupMenu.add((IAction)new ShowDescriptionAction(this.tableViewer));
        this.table.setMenu(popupMenu.createContextMenu((Control)this.table));
        this.guidelineHolder.addGuidelineSelectionChangedListener((IGuidelineSlectionChangedListener)this);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (ResultTableViewer.this.srcViewerForPT != null && selection instanceof IStructuredSelection) {
                    ArrayList<HighlightTargetSourceInfo> srcLineArray = new ArrayList<HighlightTargetSourceInfo>();
                    for (IProblemItem tmpItem : (IStructuredSelection)selection) {
                        srcLineArray.addAll(Arrays.asList(tmpItem.getHighlightTargetSoruceInfo()));
                    }
                    HighlightTargetSourceInfo[] target = new HighlightTargetSourceInfo[srcLineArray.size()];
                    srcLineArray.toArray(target);
                    ResultTableViewer.this.srcViewerForPT.highlightSrcViewer(target, ResultTableViewer.this.getCurrentSoruceFile());
                }
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    for (IProblemItem tmpItem : (IStructuredSelection)selection) {
                        ReportMessageDialog.openReportMEssageDialog(ResultTableViewer.this.shell, tmpItem);
                    }
                }
            }
        });
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    private void changeColumnLayout() {
        this.srcViewerForPT.setSrcChanged(true);
        switch (this.mode) {
            case 1: {
                this.initLVMode();
                break;
            }
            default: {
                this.initDefaultMode();
            }
        }
    }

    public void refresh() {
        this.tableViewer.refresh();
    }

    private void initColumns() {
        int columnSize = 4 + this.guidelineHolder.getGuidelineData().length + this.guidelineHolder.getMetricsNames().length;
        int lvColumn = 10 + this.guidelineHolder.getGuidelineData().length;
        if (lvColumn > columnSize) {
            columnSize = lvColumn;
        }
        int i = 0;
        while (i < columnSize) {
            TableColumn column = new TableColumn(this.table, 16384);
            column.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(i));
            ++i;
        }
    }

    private void initDefaultMode() {
        TableColumn[] columns = this.table.getColumns();
        int curPos = 0;
        int i = 0;
        while (i < columns.length) {
            columns[i].setImage(null);
            columns[i].setResizable(true);
            ++i;
        }
        columns[curPos].setText(IProblemConst.TITLE_HIGHLIGHT);
        columns[curPos].setWidth(25);
        ++curPos;
        String[] tmpSarray = this.guidelineHolder.getLocalizedMetricsNames();
        boolean[] enabledMetrics = this.guidelineHolder.getMatchedMetrics();
        int i2 = 0;
        while (i2 < tmpSarray.length) {
            columns[curPos].setText(tmpSarray[i2]);
            if (enabledMetrics[i2]) {
                columns[curPos].setWidth(55);
            } else {
                columns[curPos].setWidth(0);
                columns[curPos].setResizable(false);
            }
            ++curPos;
            ++i2;
        }
        IGuidelineData[] dataArray = this.guidelineHolder.getGuidelineData();
        int i3 = 0;
        while (i3 < dataArray.length) {
            columns[curPos].setText(dataArray[i3].getGuidelineName());
            if (dataArray[i3].isMatched()) {
                columns[curPos].setWidth(80);
            } else {
                columns[curPos].setWidth(0);
                columns[curPos].setResizable(false);
            }
            ++curPos;
            ++i3;
        }
        columns[curPos].setText(IProblemConst.TITLE_TECHNIQUS);
        columns[curPos].setWidth(65);
        columns[++curPos].setText(IProblemConst.TITLE_LINE);
        columns[curPos].setWidth(60);
        columns[++curPos].setText(IProblemConst.TITLE_DESCRIPTION);
        columns[curPos].setWidth(1000);
        i3 = ++curPos;
        while (i3 < columns.length) {
            columns[i3].setWidth(0);
            columns[i3].setResizable(false);
            ++i3;
        }
    }

    private void initLVMode() {
        TableColumn[] columns = this.table.getColumns();
        int curPos = 0;
        int i = 0;
        while (i < columns.length) {
            columns[i].setImage(null);
            columns[i].setResizable(true);
            ++i;
        }
        columns[curPos].setText(IProblemConst.TITLE_ICON);
        columns[curPos].setWidth(45);
        ++curPos;
        IGuidelineData[] dataArray = this.guidelineHolder.getGuidelineData();
        int i2 = 0;
        while (i2 < dataArray.length) {
            columns[curPos].setText(dataArray[i2].getGuidelineName());
            if (dataArray[i2].isMatched()) {
                columns[curPos].setWidth(70);
            } else {
                columns[curPos].setWidth(0);
                columns[curPos].setResizable(false);
            }
            ++curPos;
            ++i2;
        }
        columns[curPos].setText(IProblemConst.TITLE_SEVERITY);
        columns[curPos].setWidth(55);
        columns[++curPos].setText(IProblemConst.TITLE_FORECOLOR);
        columns[curPos].setWidth(70);
        columns[++curPos].setText(IProblemConst.TITLE_BACKCOLOR);
        columns[curPos].setWidth(70);
        columns[++curPos].setText(IProblemConst.TITLE_X);
        columns[curPos].setWidth(50);
        columns[++curPos].setText(IProblemConst.TITLE_Y);
        columns[curPos].setWidth(50);
        columns[++curPos].setText(IProblemConst.TITLE_AREA);
        columns[curPos].setWidth(50);
        columns[++curPos].setText(IProblemConst.TITLE_TECHNIQUS);
        columns[curPos].setWidth(60);
        columns[++curPos].setText(IProblemConst.TITLE_DESCRIPTION);
        columns[curPos].setWidth(1000);
        i2 = ++curPos;
        while (i2 < columns.length) {
            columns[i2].setWidth(0);
            columns[i2].setResizable(false);
            ++i2;
        }
    }

    public void changeFilterType(int type) {
        this.tableFilter.setSeverity(type);
        this.refresh();
    }

    public void selectionChanged(GuidelineSelectionChangedEvent e) {
        this.changeColumnLayout();
        this.refresh();
    }

    public void setResult(IVisualizationView vizView, IEvaluationResult result) {
        if (vizView != null) {
            this.mode = vizView.getResultTableMode();
            this.currentSoruceFile = result.getSourceFile();
            this.isShowAllGuidelineItems = result.isShowAllGuidelineItems();
            this.tableSorter = vizView.getTableSorter();
            if (this.curMode != vizView.getResultTableMode()) {
                this.tableViewer.setInput(new Vector());
                this.changeColumnLayout();
            }
            this.tableViewer.setLabelProvider(vizView.getLabelProvider());
            this.tableViewer.setSorter(this.tableSorter);
            this.tableViewer.setInput((Object)result.getProblemList());
            this.srcViewerForPT.setSrcChanged(true);
            this.srcViewerForPT.updateSrcViewer(result.getSourceFile());
            this.srcHighlightAction.setEnabled(result.getSourceFile() != null);
        }
    }

    public File getCurrentSoruceFile() {
        return this.currentSoruceFile;
    }

    public boolean isShowAllGuidelineItems() {
        return this.isShowAllGuidelineItems;
    }

    public void setModelService(IModelService modelService) {
    }

    private class ColumnSelectionAdapter
    extends SelectionAdapter {
        private int column;

        public ColumnSelectionAdapter(int column) {
            this.column = column;
        }

        public void widgetSelected(SelectionEvent arg0) {
            ResultTableViewer.this.tableViewer.setSelection(null);
            if (ResultTableViewer.this.tableSorter instanceof IResultTableSorter) {
                ((IResultTableSorter)ResultTableViewer.this.tableSorter).setCurColumn(this.column);
            }
            ResultTableViewer.this.tableViewer.refresh();
        }
    }
}

