/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.ui.report.views;

import org.eclipse.actf.mediator.IACTFReportViewer;
import org.eclipse.actf.mediator.MediatorEvent;
import org.eclipse.actf.visualization.eval.EvaluationResultImpl;
import org.eclipse.actf.visualization.eval.IEvaluationResult;
import org.eclipse.actf.visualization.internal.ui.report.DetailProblemReportArea;
import org.eclipse.actf.visualization.ui.IVisualizationView;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class DetailedReportView
extends ViewPart
implements IACTFReportViewer {
    private IEvaluationResult curResult = null;
    private static final IEvaluationResult dummyResult = new EvaluationResultImpl();
    private DetailProblemReportArea problemArea;

    public void createPartControl(Composite parent) {
        this.problemArea = new DetailProblemReportArea(parent, 0);
        this.getSite().setSelectionProvider((ISelectionProvider)this.problemArea.getProblemTree().getResultTableViewer().getTableViewer());
    }

    public void setFocus() {
    }

    public void modelserviceChanged(MediatorEvent event) {
        this.problemArea.setModelService(event.getModelServiceHolder().getModelService());
        this.updateEvaluationResult(event);
    }

    public void modelserviceInputChanged(MediatorEvent event) {
        this.updateEvaluationResult(event);
    }

    public void reportChanged(MediatorEvent event) {
        this.updateEvaluationResult(event);
    }

    public void reportGeneratorChanged(MediatorEvent event) {
        this.updateEvaluationResult(event);
    }

    private void updateEvaluationResult(MediatorEvent event) {
        IEvaluationResult tmpResult = dummyResult;
        if (event.getReport() instanceof IEvaluationResult) {
            tmpResult = (IEvaluationResult)event.getReport();
        }
        if (this.curResult != tmpResult) {
            IVisualizationView view = null;
            if (event.getView() instanceof IVisualizationView) {
                view = (IVisualizationView)event.getView();
            }
            this.problemArea.setResult(view, tmpResult);
            this.curResult = tmpResult;
        }
    }
}

