/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.audio.io;

import java.net.URL;
import javax.sound.sampled.Mixer;
import org.eclipse.actf.ai.audio.io.IAudioPipe;
import org.eclipse.actf.ai.audio.io.IAudioReader;
import org.eclipse.actf.ai.audio.io.IAudioWriter;
import org.eclipse.actf.ai.audio.io.impl.AudioFileReader;
import org.eclipse.actf.ai.audio.io.impl.AudioPipe;
import org.eclipse.actf.ai.audio.io.impl.LoopedAudioPipe;
import org.eclipse.actf.ai.audio.io.impl.PlaybackDevice;
import org.eclipse.actf.ai.audio.io.impl.RecordDevice;

public class AudioFactory {
    public static IAudioReader createAudioReader(String file) {
        return new AudioFileReader(file);
    }

    public static IAudioReader createAudioReader(URL url) {
        return new AudioFileReader(url);
    }

    public static IAudioWriter createDefaultWriter() {
        return new PlaybackDevice();
    }

    public static IAudioPipe createAudioPipe(IAudioReader reader, IAudioWriter writer) {
        return new AudioPipe(reader, writer);
    }

    public static IAudioPipe createLoopedAudioPipe(IAudioReader reader, IAudioWriter writer) {
        return new LoopedAudioPipe(reader, writer);
    }

    public static IAudioWriter createAudioWriter(Mixer mixer) {
        return new PlaybackDevice(mixer);
    }

    public static IAudioReader createAudioReader(Mixer mixer, int recordingSmapleRate, int recordingChannels) {
        return new RecordDevice(mixer, recordingSmapleRate, recordingChannels);
    }
}

