/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.audio.io.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.eclipse.actf.ai.audio.io.AudioIOException;
import org.eclipse.actf.ai.audio.io.IAudioReader;

public class AudioFileReader
implements IAudioReader {
    private File file;
    private URL url;
    private AudioFormat format;
    private AudioInputStream stream;
    private boolean opened = false;
    private boolean closed = false;

    public AudioFileReader(String fileName) {
        this.setFile(fileName);
    }

    public AudioFileReader(URL url) {
        this.setURL(url);
    }

    public String getName() {
        if (this.file != null) {
            return "File \"" + this.file.getName() + "\"";
        }
        if (this.url != null) {
            return "URL \"" + this.url.getPath() + "\"";
        }
        return "";
    }

    private void setFile(String fileName) {
        this.file = new File(fileName);
    }

    private void setURL(URL url) {
        this.url = url;
    }

    public boolean canRead() {
        try {
            if (this.file != null) {
                AudioSystem.getAudioInputStream(this.file);
            }
            if (this.url != null) {
                AudioSystem.getAudioFileFormat(this.url);
            }
            return true;
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
        }
        catch (IOException iOException) {}
        return false;
    }

    public synchronized void open() throws AudioIOException {
        try {
            if (this.file != null) {
                this.stream = AudioSystem.getAudioInputStream(this.file);
            }
            if (this.url != null) {
                this.stream = AudioSystem.getAudioInputStream(this.url);
            }
            this.format = this.stream.getFormat();
            this.opened = true;
            this.closed = false;
        }
        catch (UnsupportedAudioFileException e) {
            throw new AudioIOException("Unsupported audio file type.", e);
        }
        catch (IOException e) {
            throw new AudioIOException(e.toString(), e);
        }
    }

    public AudioFormat getAudioFormat() {
        return this.format;
    }

    public synchronized int read(byte[] data, int offset, int length) throws AudioIOException {
        if (!this.opened) {
            throw new AudioIOException("This is not opened.", null);
        }
        try {
            int nBytesRead = this.stream.read(data, offset, length);
            if (nBytesRead == -1) {
                this.stream.close();
                this.opened = false;
                this.closed = true;
                nBytesRead = 0;
            }
            return nBytesRead;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public synchronized void close() {
        try {
            if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException iOException) {}
        this.opened = false;
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

