/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.fm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLAction;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLRules;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionList {
    private final ArrayList<NVDLAction> actions = new ArrayList();
    private int count;

    public List<NVDLAction> getActions() {
        return this.actions;
    }

    public int getCount() {
        return this.count;
    }

    private void invalidId(String id) throws InvalidIdException {
        this.actions.clear();
        this.count = 0;
        throw new InvalidIdException(id);
    }

    public int getPrecedence() {
        return 0;
    }

    public boolean match(ActionList al) {
        int size = this.actions.size();
        if (size != al.actions.size()) {
            return false;
        }
        int i = 0;
        while (i < size) {
            NVDLAction a2;
            NVDLAction a1 = this.actions.get(i);
            if (!a1.equals(a2 = al.actions.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ActionList)) {
            return false;
        }
        ActionList al = (ActionList)o;
        if (this.count != al.count) {
            return false;
        }
        return this.match(al);
    }

    public int hashCode() {
        int v = 0;
        int size = this.actions.size();
        int i = 0;
        while (i < size) {
            NVDLAction a = this.actions.get(i);
            v ^= a.hashCode();
            ++i;
        }
        return v;
    }

    public ActionList() {
    }

    public ActionList(NVDLRules rules, String id) throws InvalidIdException {
        this.actions.clear();
        String[] aids = id.split("[ \t\n\r]");
        int i = 0;
        while (i < aids.length) {
            NVDLAction a = rules.getAction(aids[i]);
            if (a != null) {
                this.actions.add(a);
            } else {
                if (i != aids.length - 1) {
                    this.invalidId(id);
                }
                try {
                    this.count = Integer.parseInt(aids[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    this.invalidId(id);
                }
            }
            ++i;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int size = this.actions.size();
        int i = 0;
        while (i < size) {
            NVDLAction a = this.actions.get(i);
            buf.append(a.getName());
            buf.append(' ');
            ++i;
        }
        buf.append(this.getCount());
        return buf.toString();
    }

    public static class InvalidIdException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 5426408147221128508L;
        public final String id;

        InvalidIdException(String id) {
            this.id = id;
        }
    }
}

