/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.util;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class PrefixMapper {
    private PrefixDef latest = null;
    private PrefixDef oldest = null;

    public void reset() {
        this.oldest = null;
        this.latest = null;
    }

    public void startPrefixMapping(String prefix, String uri) {
        PrefixDef pd;
        this.latest = pd = new PrefixDef(prefix, uri, this.latest);
        if (this.oldest == null) {
            this.oldest = pd;
        }
        assert (this.oldest == null || this.oldest.next == null);
    }

    public void endPrefixMapping(String prefix) {
        PrefixDef pd = this.latest;
        while (pd != null) {
            if (pd.prefix.equals(prefix)) {
                if (pd.previous == null) {
                    this.latest = pd.next;
                    if (this.latest != null) break;
                    this.oldest = null;
                    break;
                }
                if (pd.next == null) {
                    pd.previous.next = null;
                    this.oldest = pd.previous;
                    break;
                }
                pd.previous.next = pd.next;
                pd.next.previous = pd.previous;
                break;
            }
            pd = pd.next;
        }
        assert (this.oldest == null || this.oldest.next == null);
    }

    public PrefixReturnVal uniquePrefix(String prefixBase, String ns) {
        String tryPrefix = prefixBase;
        int tryCount = 0;
        block0: while (true) {
            PrefixDef pd = this.oldest;
            while (pd != null) {
                if (pd.uri.equals(ns)) {
                    return new PrefixReturnVal(pd.prefix, false);
                }
                if (pd.prefix.equals(tryPrefix)) {
                    tryPrefix = String.valueOf(prefixBase) + ++tryCount;
                    continue block0;
                }
                pd = pd.previous;
            }
            break;
        }
        return new PrefixReturnVal(tryPrefix, true);
    }

    public Object startEffectivePrefixMappings(ContentHandler h) throws SAXException {
        PrefixDef last = null;
        PrefixDef pd = this.oldest;
        while (pd != null) {
            h.startPrefixMapping(pd.prefix, pd.uri);
            last = pd;
            pd = pd.previous;
        }
        return last;
    }

    public void endEffectivePrefixMappings(Object effectiveMapping, ContentHandler h) throws SAXException {
        PrefixDef pd = (PrefixDef)effectiveMapping;
        while (pd != null) {
            h.endPrefixMapping(pd.prefix);
            pd = pd.next;
        }
    }

    public StartElementToken sendStartElement(ContentHandler h, String ns, String localName, String preferredPrefix, Attributes attrs) throws SAXException {
        PrefixReturnVal prv = this.uniquePrefix(preferredPrefix, ns);
        if (prv.requireDecl) {
            h.startPrefixMapping(prv.prefix, ns);
        }
        String qName = String.valueOf(prv.prefix) + ":" + localName;
        h.startElement(ns, localName, qName, attrs);
        return new StartElementToken(localName, ns, qName, prv.prefix, prv.requireDecl);
    }

    public void sendEndElement(ContentHandler h, StartElementToken set) throws SAXException {
        h.endElement(set.ns, set.localName, set.qName);
        if (set.requireDecl) {
            h.endPrefixMapping(set.prefix);
        }
    }

    public void sendEmptyElement(ContentHandler h, String ns, String localName, String preferredPrefix, Attributes attrs) throws SAXException {
        PrefixReturnVal prv = this.uniquePrefix(preferredPrefix, ns);
        if (prv.requireDecl) {
            h.startPrefixMapping(prv.prefix, ns);
        }
        String qName = String.valueOf(prv.prefix) + ":" + localName;
        h.startElement(ns, localName, qName, attrs);
        h.endElement(ns, localName, qName);
        if (prv.requireDecl) {
            h.endPrefixMapping(prv.prefix);
        }
    }

    private class PrefixDef {
        PrefixDef next;
        PrefixDef previous;
        final String prefix;
        final String uri;

        PrefixDef(String prefix, String uri, PrefixDef next) {
            this.prefix = prefix;
            this.uri = uri;
            this.next = next;
            if (next != null) {
                next.previous = this;
            }
        }
    }

    public static class PrefixReturnVal {
        public final String prefix;
        public final boolean requireDecl;

        PrefixReturnVal(String prefix, boolean requireDecl) {
            this.prefix = prefix;
            this.requireDecl = requireDecl;
        }
    }

    public static class StartElementToken {
        final String localName;
        final String ns;
        final String qName;
        final String prefix;
        final boolean requireDecl;

        StartElementToken(String localName, String ns, String qName, String prefix, boolean requireDecl) {
            this.localName = localName;
            this.ns = ns;
            this.qName = qName;
            this.prefix = prefix;
            this.requireDecl = requireDecl;
        }
    }
}

