/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.navigator.impl;

import org.eclipse.actf.ai.fennec.treemanager.ITreeItem;
import org.eclipse.actf.ai.fennec.treemanager.TreeManagerException;
import org.eclipse.actf.ai.internal.navigator.NavigatorPlugin;
import org.eclipse.actf.ai.navigator.IManipulator;
import org.eclipse.actf.ai.navigator.impl.NavigatorImpl;
import org.eclipse.actf.ai.navigator.impl.WebEventListener;
import org.eclipse.actf.ai.navigator.userinfo.IUserInfoGenerator;
import org.eclipse.actf.ai.navigator.userinfo.impl.AltInputDialog;
import org.eclipse.actf.ai.navigator.userinfo.impl.AltTextEditor;
import org.eclipse.actf.ai.navigator.userinfo.impl.AltTextGuesser;
import org.eclipse.actf.ai.navigator.userinfo.impl.BrowserObserver;
import org.eclipse.actf.ai.navigator.userinfo.impl.HeadingCanceller;
import org.eclipse.actf.ai.navigator.userinfo.impl.LandmarkMaker;
import org.eclipse.actf.ai.navigator.userinfo.impl.MetaDataModifier;
import org.eclipse.actf.ai.navigator.util.ContentShortener;
import org.eclipse.actf.ai.xmlstore.XMLStoreException;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.ui.util.PlatformUIUtil;
import org.eclipse.actf.util.vocab.IEvalTarget;
import org.eclipse.actf.util.vocab.Vocabulary;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NavigatorImplEx
extends NavigatorImpl {
    private final IPreferenceStore preferenceStore;
    private final ContentShortener contentShortener;
    private final BrowserObserver observer;
    private IWebBrowserACTF webBrowser;

    public NavigatorImplEx(WebEventListener webEventListener, IWebBrowserACTF webBrowser, int maxRetry, int retryInterval) {
        super(webEventListener, webBrowser, maxRetry, retryInterval);
        this.webBrowser = webBrowser;
        this.preferenceStore = NavigatorPlugin.getDefault().getPreferenceStore();
        this.contentShortener = new ContentShortener(32, this.getMessageFormatter());
        this.observer = new BrowserObserver(webBrowser);
    }

    public void saveUserInfo() {
        if (this.getCurrentEntry() != null && !this.getCurrentEntry().isUserEntry()) {
            this.speakUnavailableUserInfo();
            return;
        }
        try {
            MetaDataModifier modifier = new MetaDataModifier();
            modifier.setSite(this.observer.getTargetFilter());
            modifier.setPageTitle(PlatformUIUtil.getActiveEditor().getTitle());
            modifier.commit(true);
            this.speakWithFormat("Navigator.ANNOTATION_IS_SAVED", true);
        }
        catch (XMLStoreException e) {
            e.printStackTrace();
        }
    }

    public void guessAltText() {
        if (this.getCurrentEntry() != null && !this.getCurrentEntry().isUserEntry()) {
            this.speakUnavailableUserInfo();
            return;
        }
        try {
            ITreeItem item = this.getTreeManager().getCurrentRootItem();
            this.setMode(IManipulator.KEYHOOK_DISABLED_MODE);
            item.setFocus();
            int k = this.guessAltTextIter(item);
            if (k > 0) {
                String mes = this.getMessageFormatter().mes("Navigator.ALT_TEXT_WERE_GUESSED", k);
                this.speak(mes, true);
                if (this.preferenceStore.getBoolean("autoSave")) {
                    this.saveUserInfo();
                }
                if (this.preferenceStore.getBoolean("autoRefresh")) {
                    this.refresh();
                }
            } else {
                this.speakWithFormat("Navigator.THERE_IS_NO_MISSING_ALT_TEXT", true);
            }
            item.setFocus();
            this.setMode(IManipulator.TREE_NAVIGATION_MODE);
        }
        catch (TreeManagerException e) {
            e.printStackTrace();
        }
        catch (XMLStoreException e) {
            e.printStackTrace();
        }
    }

    private int guessAltTextIter(ITreeItem item) throws XMLStoreException {
        int k = 0;
        ITreeItem[] v = item.getChildItems();
        int i = 0;
        while (i < v.length) {
            ITreeItem c = v[i];
            k += this.guessAltTextIter(c);
            ++i;
        }
        if (!Vocabulary.isAlterable().eval((IEvalTarget)item)) {
            return k;
        }
        if (this.isGoodAltText(item.getUIString())) {
            return k;
        }
        AltTextGuesser guesser = new AltTextGuesser(this.webBrowser, item);
        String newText = guesser.guessByContext();
        if (newText == null || newText.length() == 0) {
            return k;
        }
        MetaDataModifier modifier = new MetaDataModifier();
        modifier.setGenerator(new AltTextEditor());
        modifier.setSite(this.observer.getTargetFilter());
        modifier.setPageTitle(PlatformUIUtil.getActiveEditor().getTitle());
        modifier.setItem(item);
        modifier.setText(this.getMessageFormatter().mes("Navigator.ANNOTATION_LINK_TO", newText));
        IUserInfoGenerator.Result result = modifier.commit(false);
        if (result != IUserInfoGenerator.Result.NOTHING) {
            ++k;
        }
        return k;
    }

    private boolean isGoodAltText(String s) {
        return s.length() > 0;
    }

    public void nextAlterable() {
        if (this.getCurrentEntry() != null && !this.getCurrentEntry().isUserEntry()) {
            this.speakUnavailableUserInfo();
            return;
        }
        this.findNext(Vocabulary.isAlterable(), NavigatorImpl.JumpMode.ALTALABLE);
    }

    public void previousAlterable() {
        if (this.getCurrentEntry() != null && !this.getCurrentEntry().isUserEntry()) {
            this.speakUnavailableUserInfo();
            return;
        }
        this.findPrevious(Vocabulary.isAlterable(), NavigatorImpl.JumpMode.ALTALABLE);
    }

    public void editAltText() {
        if (this.getCurrentEntry() != null && !this.getCurrentEntry().isUserEntry()) {
            this.speakUnavailableUserInfo();
            return;
        }
        try {
            ITreeItem item = this.getTreeManager().getActiveItem();
            if (item == null) {
                return;
            }
            if (Vocabulary.isAlterable().eval((IEvalTarget)item)) {
                String newText;
                this.setMode(IManipulator.KEYHOOK_DISABLED_MODE);
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                AltInputDialog dialog = new AltInputDialog(shell, item.getUIString());
                if (dialog.open() == 0 && (newText = dialog.getResult()) != null) {
                    MetaDataModifier modifier = new MetaDataModifier();
                    modifier.setGenerator(new AltTextEditor());
                    modifier.setSite(this.observer.getTargetFilter());
                    modifier.setPageTitle(PlatformUIUtil.getActiveEditor().getTitle());
                    modifier.setItem(item);
                    modifier.setText(newText);
                    IUserInfoGenerator.Result result = modifier.commit(this.preferenceStore.getBoolean("autoSave"));
                    if (this.preferenceStore.getBoolean("autoRefresh")) {
                        this.refresh();
                    }
                    this.speak(this.getMessageFormatter().mes(modifier.toString(result), newText), true, false);
                }
                this.setMode(IManipulator.TREE_NAVIGATION_MODE);
            } else {
                this.speakWithFormat("Navigator.ITEM_IS_NOT_AVAILABLE", true);
            }
        }
        catch (TreeManagerException e) {
            e.printStackTrace();
        }
        catch (XMLStoreException e) {
            e.printStackTrace();
        }
    }

    private void speakUnavailableUserInfo() {
        this.speakWithFormat("Navigator.ANNOTATION_IS_NOT_AVAILABLE", true);
    }

    public void makeLandmark() {
        if (this.getCurrentEntry() != null && !this.getCurrentEntry().isUserEntry()) {
            this.speakUnavailableUserInfo();
            return;
        }
        try {
            ITreeItem item = this.getTreeManager().getActiveItem();
            MetaDataModifier modifier = new MetaDataModifier();
            modifier.setGenerator((IUserInfoGenerator)((Object)(this.getHeadingLevelOf(item) > 0 ? new HeadingCanceller() : new LandmarkMaker())));
            modifier.setSite(this.observer.getTargetFilter());
            modifier.setPageTitle(PlatformUIUtil.getActiveEditor().getTitle());
            modifier.setItem(item);
            IUserInfoGenerator.Result result = modifier.commit(this.preferenceStore.getBoolean("autoSave"));
            if (this.preferenceStore.getBoolean("autoRefresh")) {
                this.refresh();
            }
            this.speak(this.getMessageFormatter().mes(modifier.toString(result), this.contentShortener.getSummary(item, true)), true, false);
        }
        catch (TreeManagerException e) {
            e.printStackTrace();
        }
        catch (XMLStoreException e) {
            e.printStackTrace();
        }
    }

    private short getHeadingLevelOf(ITreeItem item) {
        short level = 0;
        ITreeItem i = item;
        while (i != null) {
            short k = i.getHeadingLevel();
            if (k < 0) {
                return k;
            }
            if (k > 0) {
                level = k;
            }
            i = i.getParent();
        }
        return level;
    }

    private void refresh() throws TreeManagerException {
        this.selectUserFennec();
    }

    public void removeUserInfo() {
        if (this.getCurrentEntry() == null) {
            this.speakWithFormat("Navigator.NO_ANNOTATION");
            return;
        }
        try {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            String title = this.getMessageFormatter().mes("Navigator.USER_INFO_REMOVE_CONFIRM");
            String message = this.getMessageFormatter().mes("Navigator.USER_INFO_REMOVE_MESSAGE");
            boolean ret = MessageDialog.openQuestion((Shell)shell, (String)title, (String)message);
            if (!ret) {
                return;
            }
            MetaDataModifier modifier = new MetaDataModifier();
            modifier.setSite(this.observer.getTargetFilter());
            modifier.setPageTitle(PlatformUIUtil.getActiveEditor().getTitle());
            if (modifier.remove()) {
                this.speakWithFormat("Navigator.ANNOTATION_IS_REMOVED", true);
                this.forceRestart(false);
            } else {
                this.speakWithFormat("Navigator.NO_ANNOTATION", true);
            }
        }
        catch (XMLStoreException e) {
            e.printStackTrace();
        }
    }
}

