/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.navigator.impl;

import org.eclipse.actf.ai.fennec.treemanager.ILocation;
import org.eclipse.actf.ai.navigator.impl.NavigatorImpl;
import org.eclipse.actf.ai.navigator.voice.VoiceManager;

class TripJournal {
    private static final boolean DEBUG = false;
    private static final int JOURNAL_SIZE = 1024;
    private static final VoiceManager voice = new VoiceManager(null);
    private int startIdx = 0;
    private int endIdx = 0;
    private int currentIdx = 0;
    private int recordIdx = 0;
    private TripJournalItem[] tripJournalItems = new TripJournalItem[1024];
    private boolean backwarding;
    private boolean forwarding;

    private int incrementIdx(int idx) {
        if (++idx == this.tripJournalItems.length) {
            idx = 0;
        }
        return idx;
    }

    private int decrementIdx(int idx) {
        if (idx == 0) {
            idx = this.tripJournalItems.length;
        }
        return --idx;
    }

    private void recordInPlay(NavigatorImpl navigator, ILocation location, String url) {
        TripJournalItem tji;
        TripJournalItem tjiOld = this.tripJournalItems[this.recordIdx];
        if (location == null && tjiOld != null) {
            location = tjiOld.location;
        }
        this.tripJournalItems[this.recordIdx] = tji = new TripJournalItem(navigator, location, url);
    }

    public void recordJournal(NavigatorImpl navigator, ILocation location, String url, boolean init) {
        if (init) {
            this.endIdx = this.currentIdx = this.incrementIdx(this.currentIdx);
            this.tripJournalItems[this.currentIdx] = new TripJournalItem(navigator, location, url);
            return;
        }
        if (!navigator.isFocused()) {
            return;
        }
        if (this.backwarding) {
            this.recordInPlay(navigator, location, url);
            this.backwarding = false;
        } else if (this.forwarding) {
            this.recordInPlay(navigator, location, url);
            this.forwarding = false;
        } else {
            TripJournalItem tji;
            TripJournalItem tjiOld = this.tripJournalItems[this.currentIdx];
            if (tjiOld != null && url != null && url.equals(tjiOld.url)) {
                return;
            }
            this.tripJournalItems[this.currentIdx] = tji = new TripJournalItem(navigator, location, url);
            this.endIdx = this.currentIdx = this.incrementIdx(this.currentIdx);
            if (this.startIdx == this.endIdx) {
                this.startIdx = this.incrementIdx(this.startIdx);
            }
        }
    }

    TripJournal() {
    }

    private void sayForward() {
        voice.speakWithFormat("TripJournal.FORWARD", true, false);
    }

    private void sayForwardFailed() {
        voice.speakWithFormat("TripJournal.FAILEDTOFORWARD", true, false);
    }

    public void forward(NavigatorImpl currentNavigartor) {
        this.recordIdx = this.currentIdx;
        int idxFwd = this.currentIdx;
        while (true) {
            if (idxFwd == this.endIdx) {
                this.sayForwardFailed();
                return;
            }
            TripJournalItem tji = this.tripJournalItems[idxFwd = this.incrementIdx(idxFwd)];
            if (tji == null) {
                this.forwarding = true;
                this.currentIdx = idxFwd;
                currentNavigartor.goForward();
                currentNavigartor.restoreLocation(null);
                return;
            }
            switch (tji.navigator.focusTab()) {
                case STAY: {
                    this.forwarding = true;
                    this.currentIdx = idxFwd;
                    tji.navigator.goForward();
                    tji.navigator.restoreLocation(tji.location);
                    this.sayForward();
                    return;
                }
                case CHANGED: {
                    this.currentIdx = idxFwd;
                    this.sayForward();
                    return;
                }
            }
        }
    }

    private void sayBackward() {
        voice.speakWithFormat("TripJournal.BACKWARD", true, false);
    }

    private void sayBackwardFailed() {
        voice.speakWithFormat("TripJournal.FAILEDTOBACKWARD", true, false);
    }

    public void backward(NavigatorImpl currentNavigator) {
        this.recordIdx = this.currentIdx;
        int idxBack = this.currentIdx;
        while (true) {
            if (idxBack == this.startIdx) {
                this.sayBackwardFailed();
                return;
            }
            TripJournalItem tji = this.tripJournalItems[idxBack = this.decrementIdx(idxBack)];
            if (tji == null) {
                if (idxBack == this.startIdx) {
                    this.sayBackwardFailed();
                    return;
                }
                this.currentIdx = idxBack;
                tji = this.tripJournalItems[idxBack = this.decrementIdx(idxBack)];
                if (tji != null) {
                    tji.navigator.focusTab();
                }
                this.sayBackward();
                return;
            }
            switch (tji.navigator.focusTab()) {
                case STAY: {
                    this.backwarding = true;
                    this.currentIdx = idxBack;
                    tji.navigator.goBackward();
                    tji.navigator.restoreLocation(tji.location);
                    this.sayBackward();
                    return;
                }
                case CHANGED: {
                    if (currentNavigator == null) {
                        this.endIdx = idxBack;
                    } else {
                        ILocation location = currentNavigator.getLocation();
                        int idx = this.incrementIdx(idxBack);
                        this.tripJournalItems[idx] = new TripJournalItem(currentNavigator, location, currentNavigator.getCurrentURL());
                    }
                    this.currentIdx = idxBack;
                    this.sayBackward();
                    return;
                }
            }
        }
    }

    public void tripEnd() {
        this.forwarding = false;
        this.backwarding = false;
    }

    public void refreshEnd() {
        TripJournalItem tji = this.tripJournalItems[this.currentIdx];
        if (tji == null) {
            return;
        }
        if (tji.navigator.focusTab() == NavigatorImpl.FocusTabResult.STAY) {
            tji.navigator.restoreLocation(tji.location);
        }
    }

    private static class TripJournalItem {
        final NavigatorImpl navigator;
        final ILocation location;
        final String url;

        TripJournalItem(NavigatorImpl navigator, ILocation location, String url) {
            this.navigator = navigator;
            this.location = location;
            this.url = url;
        }
    }
}

