/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.dom;

import org.eclipse.actf.util.dom.TreeWalkerImpl;
import org.eclipse.actf.util.dom.WhatToShowNodeFilter;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class NodeIteratorImpl
implements NodeIterator {
    private Node root;
    private Node current = null;
    private int whatToShow;
    private NodeFilter filter;
    private NodeFilter defaultFilter;
    private boolean entitiyReferenceExpansion;
    private boolean isDetach = false;
    private boolean noFilter = true;
    private boolean isForward = true;
    private TreeWalkerImpl treeWalker;

    public NodeIteratorImpl(Node root, int whatToShow, NodeFilter filter, boolean entityReferenceExpansion) throws DOMException {
        if (root == null) {
            throw new DOMException(8, "Root can't be a null.");
        }
        this.root = root;
        this.whatToShow = whatToShow;
        this.filter = filter;
        this.noFilter = filter == null;
        this.entitiyReferenceExpansion = entityReferenceExpansion;
        this.defaultFilter = new WhatToShowNodeFilter(whatToShow);
        this.treeWalker = new TreeWalkerImpl(root, whatToShow, filter, entityReferenceExpansion);
    }

    private short eval(Node target) {
        short flag = this.defaultFilter.acceptNode(target);
        if (this.noFilter || flag == 3) {
            return flag;
        }
        return this.filter.acceptNode(target);
    }

    public void detach() {
        this.isDetach = true;
        this.root = null;
        this.current = null;
        this.filter = null;
        this.defaultFilter = null;
    }

    public boolean getExpandEntityReferences() {
        return this.entitiyReferenceExpansion;
    }

    public NodeFilter getFilter() {
        return this.filter;
    }

    public Node getRoot() {
        return this.root;
    }

    public int getWhatToShow() {
        return this.whatToShow;
    }

    public Node nextNode() throws DOMException {
        if (this.isDetach) {
            throw new DOMException(11, String.valueOf(this.getClass().toString()) + " is detached.");
        }
        if (this.current == null) {
            this.treeWalker.setCurrentNode(this.root);
            this.current = this.eval(this.root) == 1 ? this.root : this.treeWalker.nextNode();
            this.isForward = true;
            return this.current;
        }
        if (this.isForward) {
            Node tmpN = this.treeWalker.nextNode();
            if (tmpN == null) {
                return null;
            }
            this.current = tmpN;
            return this.current;
        }
        this.isForward = true;
        return this.current;
    }

    public Node previousNode() throws DOMException {
        if (this.isDetach) {
            throw new DOMException(11, String.valueOf(this.getClass().toString()) + " is detached.");
        }
        if (this.current == null) {
            return null;
        }
        if (!this.isForward) {
            Node tmpN = this.treeWalker.previousNode();
            if (tmpN == null) {
                return null;
            }
            this.current = tmpN;
            return this.current;
        }
        this.isForward = false;
        return this.current;
    }

    private Node nonChildNextNode(Node target) {
        if (target == this.root) {
            return null;
        }
        Node tmpN = target.getNextSibling();
        if (tmpN != null) {
            return tmpN;
        }
        Node tmpP = this.treeWalker.getParentNode(target);
        while (tmpP != null && tmpP != this.root) {
            tmpN = tmpP.getNextSibling();
            if (tmpN != null) {
                return tmpN;
            }
            tmpP = this.treeWalker.getParentNode(tmpP);
        }
        return null;
    }

    private Node checkParent(Node target) {
        Node tmpN = this.current;
        while (tmpN != null && tmpN != this.root) {
            if (tmpN == target) {
                return target;
            }
            tmpN = this.treeWalker.getParentNode(tmpN);
        }
        return null;
    }

    public void prepareNodeRemove(Node target) {
        Node tmpN = this.checkParent(target);
        if (tmpN != null) {
            if (this.isForward) {
                this.treeWalker.setCurrentNode(tmpN);
                this.current = this.treeWalker.previousNode();
            } else {
                this.current = this.nonChildNextNode(tmpN);
                if (this.current == null) {
                    this.treeWalker.setCurrentNode(tmpN);
                    this.current = this.treeWalker.previousNode();
                    this.isForward = true;
                } else {
                    this.treeWalker.setCurrentNode(this.current);
                }
            }
        }
    }
}

