/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.fennec.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.actf.ai.fennec.FennecException;
import org.eclipse.actf.ai.fennec.FennecInterruptedException;
import org.eclipse.actf.ai.fennec.autotranslator.AutoTranslator;
import org.eclipse.actf.ai.fennec.impl.FennecBundleMetadata;
import org.eclipse.actf.ai.fennec.impl.FennecGeneratedMetadata;
import org.eclipse.actf.ai.fennec.impl.FennecMetadata;
import org.eclipse.actf.ai.fennec.impl.FennecRecombinantMetadata;
import org.eclipse.actf.ai.fennec.impl.TreeItemFennec;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FennecMode {
    public static final int TYPE_SIMPLE = 0;
    public static final int TYPE_ATTACH = 1;
    public static final int TYPE_UNWRAP = 2;
    public static final int TYPE_BUILT = 2;
    public static final int TRIGGER_MOVE = 1;
    public static final int TRIGGER_CLICK = 2;
    public static final int TRIGGER_KEEP = 4;
    public static final int TRIGGER_WITHOUTCHANGE = 8;
    public static final int TRIGGER_UNWRAP = 16;
    public static final int TRIGGER_ALWAYS = 23;
    private final int type;
    private final int trigger;
    private final boolean automatic;
    private final boolean changeless;
    private final boolean waitContents;
    private FennecRecombinantMetadata baseMetadata;
    private List<FennecMetadata> belongingMetadata;
    private HashMap<Node, ArrayList<FennecMetadata>> metadataMap;
    private TreeItemFennec currentTopItem;
    private FennecMetadata[] topMds;
    private HashMap cachedResult = new HashMap();

    void addMetadata(FennecMetadata md) {
    }

    void setBaseMetadata(FennecRecombinantMetadata md) {
        this.baseMetadata = md;
    }

    boolean changed(TreeItemFennec pItem, int trigger) {
        if ((trigger & 8) != 0) {
            return false;
        }
        return !this.changeless;
    }

    TreeItemFennec buildItem(Node n, TreeItemFennec pItem) {
        this.currentTopItem = pItem;
        TreeItemFennec item = AutoTranslator.translate(this, pItem, n);
        if (pItem != null) {
            pItem.markRefreshedChild();
        }
        return item;
    }

    TreeItemFennec buildItemContinued(Node n, TreeItemFennec item) {
        this.currentTopItem = null;
        TreeItemFennec newItem = AutoTranslator.translateContinued(this, item, n);
        if (newItem != null) {
            newItem.markRefreshedChild();
        }
        return newItem;
    }

    private FennecMetadata[] initMetadataMap(FennecMetadata[] mds, Node n) {
        if (this.topMds != null) {
            return this.topMds;
        }
        this.metadataMap = new HashMap();
        ArrayList<FennecMetadata> mdList = new ArrayList<FennecMetadata>();
        int i = 0;
        while (i < mds.length) {
            if (mds[i].hasTargets()) {
                this.registMetadata(this.metadataMap, mds[i], n);
            } else {
                mdList.add(mds[i]);
            }
            ++i;
        }
        this.topMds = mdList.toArray(new FennecMetadata[mdList.size()]);
        return this.topMds;
    }

    public TreeItemFennec generateItem(TreeItemFennec pItem, Node n) {
        FennecMetadata[] cmds = null;
        FennecMetadata[] mds = this.baseMetadata.getChildMetadata();
        if (mds != null) {
            if (this.currentTopItem == pItem) {
                cmds = this.initMetadataMap(mds, n);
            } else {
                this.initMetadataMap(mds, n);
                ArrayList<FennecMetadata> aMeta = this.metadataMap.get(n);
                if (aMeta != null) {
                    cmds = aMeta.toArray(new FennecMetadata[aMeta.size()]);
                }
            }
        }
        FennecGeneratedMetadata md = FennecGeneratedMetadata.generate(this.baseMetadata, this, n, cmds);
        return TreeItemFennec.newTreeItem(md, pItem, n);
    }

    private void registMetadata(HashMap<Node, ArrayList<FennecMetadata>> metaMap, FennecMetadata meta, Node base) {
        NodeList list = meta.query(base);
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            ArrayList<FennecMetadata> aMeta = metaMap.get(node);
            if (aMeta == null) {
                aMeta = new ArrayList();
                metaMap.put(node, aMeta);
            }
            if (meta instanceof FennecBundleMetadata) {
                FennecMetadata[] m = ((FennecBundleMetadata)meta).childMetadata;
                int j = 0;
                while (j < m.length) {
                    if (m[j].hasTargets()) {
                        this.registMetadata(metaMap, m[j], node);
                    } else {
                        aMeta.add(m[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private List autoAttach(TreeItemFennec pItem, NodeList nl, int len, int trigger) throws FennecException {
        ArrayList<TreeItemFennec> l = new ArrayList<TreeItemFennec>(len);
        int i = 0;
        while (i < len) {
            Node n = nl.item(i);
            TreeItemFennec newItem = this.buildItem(n, pItem);
            if (newItem != null) {
                l.add(newItem);
            }
            ++i;
        }
        if (l.size() == 0) {
            if (this.trigger == 2) {
                throw new FennecInterruptedException("Could not attach the expected nodes.");
            }
            return null;
        }
        if (this.waitContents && l.size() == 0) {
            throw new FennecInterruptedException("Contents have not been prepared yet.");
        }
        return l;
    }

    private List manualAttach(TreeItemFennec pItem, NodeList nl, int len, int trigger) throws FennecException {
        ArrayList l = new ArrayList(len);
        FennecMetadata[] childMds = this.baseMetadata.getChildMetadata();
        int j = 0;
        while (j < len) {
            int i = 0;
            while (i < childMds.length) {
                FennecMetadata md = childMds[i];
                List l2 = md.buildItems(pItem, nl.item(j), trigger);
                if (l2 != null) {
                    if (l2.size() > 0) {
                        l.addAll(l2);
                    } else if (this.waitContents) {
                        throw new FennecInterruptedException("Contents have not been prepared yet.");
                    }
                }
                ++i;
            }
            ++j;
        }
        return l;
    }

    private List unwrap(TreeItemFennec pItem, NodeList nl, int len, int trigger) {
        return null;
    }

    List expand(TreeItemFennec pItem, Node baseNode, int trigger) throws FennecException {
        List l;
        if (trigger != 4 && (trigger & this.trigger) == 0) {
            return null;
        }
        Object key = baseNode != null ? baseNode : (pItem == null ? null : pItem.getBaseNode());
        if (!this.changed(pItem, trigger) && (l = (List)this.cachedResult.get(key)) != null) {
            return l;
        }
        NodeList nl = baseNode != null ? this.baseMetadata.query(baseNode) : this.baseMetadata.query(pItem);
        int len = nl.getLength();
        List result = null;
        switch (this.type) {
            case 1: {
                if (len == 0) {
                    if (this.trigger == 2) {
                        throw new FennecInterruptedException("Could not attach the expected nodes.");
                    }
                    return null;
                }
                result = this.automatic ? this.autoAttach(pItem, nl, len, trigger) : this.manualAttach(pItem, nl, len, trigger);
                this.cachedResult.put(key, result);
                return result;
            }
        }
        return result;
    }

    FennecMode(int type, int trigger, boolean automatic, boolean changeless, boolean waitContents) {
        this.type = type;
        this.trigger = trigger;
        this.automatic = automatic;
        this.changeless = changeless;
        this.waitContents = waitContents;
    }

    FennecMode(int type) {
        this.type = type;
        this.trigger = 23;
        this.automatic = false;
        this.changeless = false;
        this.waitContents = false;
    }
}

