/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.fennec.mediator;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.actf.ai.fennec.FennecServiceFactory;
import org.eclipse.actf.ai.fennec.IFennecEntry;
import org.eclipse.actf.ai.fennec.IFennecMediator;
import org.eclipse.actf.ai.fennec.IFennecService;
import org.eclipse.actf.ai.fennec.impl.FennecEntryImpl;
import org.eclipse.actf.ai.fennec.treemanager.ITreeManager;
import org.eclipse.actf.ai.fennec.treemanager.TreeManagerFactory;
import org.eclipse.actf.ai.xmlstore.IXMLInfo;
import org.eclipse.actf.ai.xmlstore.IXMLSelector;
import org.eclipse.actf.ai.xmlstore.IXMLStore;
import org.eclipse.actf.ai.xmlstore.IXMLStoreService;
import org.eclipse.actf.ai.xmlstore.XMLStoreServiceUtil;
import org.eclipse.actf.model.dom.dombycom.IDocumentEx;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;

public class FennecMediatorImpl
implements IFennecMediator {
    private final IWebBrowserACTF webBrowser;

    public ITreeManager newTreeManager(IFennecEntry entry) {
        IFennecService fennecService;
        IDocumentEx doc = (IDocumentEx)this.webBrowser.getLiveDocument();
        if (entry != null) {
            try {
                fennecService = FennecServiceFactory.newFennecService(entry, doc);
            }
            catch (Exception exception) {
                fennecService = FennecServiceFactory.newFennecServiceWithDefaultMetadata(doc);
            }
        } else {
            fennecService = FennecServiceFactory.newFennecServiceWithDefaultMetadata(doc);
        }
        return TreeManagerFactory.newITreeManager(fennecService);
    }

    private IXMLStore getFennecStore(String url) {
        IXMLStoreService ss = XMLStoreServiceUtil.getXMLStoreService();
        IXMLSelector selector = ss.getSelectorWithDocElem("fennec", "http://www.ibm.com/xmlns/prod/aiBrowser/fennec");
        IXMLStore store = ss.getRootStore();
        if ((store = store.specify(selector)) == null) {
            return null;
        }
        selector = ss.getSelectorWithURI(url);
        return store.specify(selector);
    }

    public IFennecEntry getDefaultFennecEntry() {
        String url = this.webBrowser.getURL();
        IXMLStore store = this.getFennecStore(url);
        if (store == null) {
            return null;
        }
        Iterator it = store.getInfoIterator();
        if (it == null) {
            return null;
        }
        if (!it.hasNext()) {
            return null;
        }
        IXMLInfo info = (IXMLInfo)it.next();
        return new FennecEntryImpl(info);
    }

    public IFennecEntry[] getFennecEntries() {
        String url = this.webBrowser.getURL();
        IXMLStore store = this.getFennecStore(url);
        if (store == null) {
            return null;
        }
        Iterator it = store.getInfoIterator();
        if (it == null) {
            return null;
        }
        ArrayList<FennecEntryImpl> entries = new ArrayList<FennecEntryImpl>();
        while (it.hasNext()) {
            IXMLInfo info = (IXMLInfo)it.next();
            if (info == null) continue;
            entries.add(new FennecEntryImpl(info));
        }
        IFennecEntry[] ea = new IFennecEntry[entries.size()];
        ea = entries.toArray(ea);
        return ea;
    }

    public void release() {
    }

    public FennecMediatorImpl(IWebBrowserACTF webBrowser) {
        this.webBrowser = webBrowser;
    }
}

