/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml.dtd;

import de.pdark.decentxml.BasicNode;
import de.pdark.decentxml.Token;
import de.pdark.decentxml.XMLTokenizer;
import de.pdark.decentxml.dtd.DocTypeAttributeList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocTypeElement
extends BasicNode {
    private String name;
    private String content;
    private List<DocTypeAttributeList> attLists;

    public DocTypeElement(Token token, String name, String content) {
        super(token);
        this.name = name.trim();
        this.content = content.trim();
    }

    public DocTypeElement(XMLTokenizer.Type type, String name, String content) {
        super(type, DocTypeElement.toXML(name, content));
        this.name = name.trim();
        this.content = content.trim();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.updateValue();
        this.name = name.trim();
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
        this.updateValue();
        this.content = content.trim();
    }

    protected void updateValue() {
        this.setValue(DocTypeElement.toXML(this.name, this.content));
    }

    public static String toXML(String name, String content) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<!ELEMENT");
        if (!Character.isWhitespace(name.charAt(0))) {
            buffer.append(" ");
        }
        buffer.append(name);
        if (!Character.isWhitespace(name.charAt(name.length() - 1)) && !Character.isWhitespace(content.charAt(0))) {
            buffer.append(" ");
        }
        buffer.append(content);
        buffer.append('>');
        return buffer.toString();
    }

    public void setAttLists(List<DocTypeAttributeList> value) {
        this.attLists = value;
    }

    public List<DocTypeAttributeList> getAttLists() {
        return this.attLists;
    }
}

