/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.typeinference;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;

public class OffsetTargetedASTVisitor
extends ASTVisitor {
    private final int requestedOffset;

    public OffsetTargetedASTVisitor(int requestedOffset) {
        this.requestedOffset = requestedOffset;
    }

    protected boolean interesting(ASTNode s) {
        if (s instanceof Block) {
            return true;
        }
        return s.sourceStart() < 0 || s.sourceEnd() <= s.sourceStart() || this.requestedOffset >= s.sourceStart() && this.requestedOffset < s.sourceEnd();
    }

    public final boolean visit(MethodDeclaration s) {
        if (!this.interesting((ASTNode)s)) {
            return false;
        }
        return this.visitInteresting(s);
    }

    protected boolean visitInteresting(MethodDeclaration s) {
        return this.visitGeneralInteresting((ASTNode)s);
    }

    public final boolean visit(ModuleDeclaration s) {
        if (!this.interesting((ASTNode)s)) {
            return false;
        }
        return this.visitInteresting(s);
    }

    protected boolean visitInteresting(ModuleDeclaration s) {
        return this.visitGeneralInteresting((ASTNode)s);
    }

    public final boolean visit(TypeDeclaration s) throws Exception {
        if (!this.interesting((ASTNode)s)) {
            return false;
        }
        return this.visitInteresting(s);
    }

    protected boolean visitInteresting(TypeDeclaration s) throws Exception {
        return this.visitGeneralInteresting((ASTNode)s);
    }

    public final boolean visit(Expression s) throws Exception {
        if (!this.interesting((ASTNode)s)) {
            return false;
        }
        return this.visitInteresting(s);
    }

    protected boolean visitInteresting(Expression s) {
        return this.visitGeneralInteresting((ASTNode)s);
    }

    public final boolean visit(Statement s) throws Exception {
        if (!this.interesting((ASTNode)s)) {
            return false;
        }
        return this.visitInteresting(s);
    }

    protected boolean visitInteresting(Statement s) {
        return this.visitGeneralInteresting((ASTNode)s);
    }

    public final boolean visitGeneral(ASTNode s) throws Exception {
        if (!this.interesting(s)) {
            return false;
        }
        return this.visitGeneralInteresting(s);
    }

    protected boolean visitGeneralInteresting(ASTNode s) {
        return true;
    }
}

