/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.dltk.debug.core.model.IScriptLineBreakpoint;
import org.eclipse.dltk.internal.debug.core.model.AbstractScriptBreakpoint;

public class ScriptLineBreakpoint
extends AbstractScriptBreakpoint
implements IScriptLineBreakpoint {
    protected String getMarkerId() {
        return "org.eclipse.dltk.debug.scriptLineBreakpointMarker";
    }

    protected void addLineBreakpointAttributes(Map attributes, int lineNumber, int charStart, int charEnd) {
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("charStart", new Integer(charStart));
        attributes.put("charEnd", new Integer(charEnd));
    }

    public ScriptLineBreakpoint() {
    }

    public ScriptLineBreakpoint(final String debugModelId, final IResource resource, final int lineNumber, final int charStart, final int charEnd, int hitCount, final boolean add) throws DebugException {
        final HashMap attributes = new HashMap();
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ScriptLineBreakpoint.this.setMarker(resource.createMarker(ScriptLineBreakpoint.this.getMarkerId()));
                ScriptLineBreakpoint.this.addScriptBreakpointAttributes(attributes, debugModelId, true);
                ScriptLineBreakpoint.this.addLineBreakpointAttributes(attributes, lineNumber, charStart, charEnd);
                ScriptLineBreakpoint.this.ensureMarker().setAttributes(attributes);
                ScriptLineBreakpoint.this.register(add);
            }
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }

    public URI getResourceURI() {
        try {
            return ScriptLineBreakpoint.makeUri(this.ensureMarker().getResource());
        }
        catch (DebugException e) {
            e.printStackTrace();
            return null;
        }
    }
}

