/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.actions.ActionMessages;
import org.eclipse.dltk.internal.ui.actions.ActionUtil;
import org.eclipse.dltk.internal.ui.actions.OpenActionUtil;
import org.eclipse.dltk.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class OpenAction
extends SelectionDispatchAction {
    private ScriptEditor fEditor;
    static /* synthetic */ Class class$0;

    public OpenAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.OpenAction_label);
        this.setToolTipText(ActionMessages.OpenAction_tooltip);
        this.setDescription(ActionMessages.OpenAction_description);
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
    }

    public OpenAction(ScriptEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setText(ActionMessages.OpenAction_declaration_label);
        this.setEnabled(EditorUtility.getEditorInputModelElement((IEditorPart)this.fEditor, false) != null);
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof ISourceReference || element instanceof IFile || element instanceof IStorage) continue;
            return false;
        }
        return true;
    }

    public void run(ITextSelection selection) {
        if (!this.isProcessable()) {
            return;
        }
        try {
            IModelElement[] elements = SelectionConverter.codeResolveForked(this.fEditor, false);
            if (elements == null || elements.length == 0) {
                IEditorStatusLine statusLine;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((statusLine = (IEditorStatusLine)this.fEditor.getAdapter(clazz)) != null) {
                    statusLine.setMessage(true, ActionMessages.OpenAction_error_messageBadSelection, null);
                }
                this.getShell().getDisplay().beep();
                return;
            }
            IModelElement element = elements[0];
            if (elements.length > 1 && (element = OpenActionUtil.selectModelElement(elements, this.getShell(), this.getDialogTitle(), ActionMessages.OpenAction_select_element)) == null) {
                return;
            }
            int type = element.getElementType();
            if (type == 2 || type == 3 || type == 4) {
                element = EditorUtility.getEditorInputModelElement((IEditorPart)this.fEditor, false);
            }
            this.run(new Object[]{element});
        }
        catch (InvocationTargetException e) {
            this.showError(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    private boolean isProcessable() {
        IModelElement je;
        if (this.fEditor != null && (je = EditorUtility.getEditorInputModelElement((IEditorPart)this.fEditor, false)) instanceof ISourceModule && !ScriptModelUtil.isPrimary((ISourceModule)((ISourceModule)je))) {
            return true;
        }
        return ActionUtil.isProcessable(this.getShell(), this.fEditor);
    }

    public void run(IStructuredSelection selection) {
        if (!this.checkEnabled(selection)) {
            return;
        }
        this.run(selection.toArray());
    }

    public void run(Object[] elements) {
        if (elements == null) {
            return;
        }
        int i = 0;
        while (i < elements.length) {
            block10: {
                Object element = elements[i];
                try {
                    element = this.getElementToOpen(element);
                    boolean activateOnOpen = this.fEditor != null ? true : OpenStrategy.activateOnOpen();
                    OpenActionUtil.open(element, activateOnOpen);
                }
                catch (ModelException e) {
                    DLTKUIPlugin.log((IStatus)new Status(4, "org.eclipse.dltk.ui", 10001, ActionMessages.OpenAction_error_message, (Throwable)e));
                    ErrorDialog.openError((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OpenAction_error_messageProblems, (IStatus)e.getStatus());
                }
                catch (PartInitException x) {
                    String name = null;
                    if (element instanceof IModelElement) {
                        name = ((IModelElement)element).getElementName();
                    } else if (element instanceof IStorage) {
                        name = ((IStorage)element).getName();
                    } else if (element instanceof IResource) {
                        name = ((IResource)element).getName();
                    }
                    if (name == null) break block10;
                    MessageDialog.openError((Shell)this.getShell(), (String)ActionMessages.OpenAction_error_messageProblems, (String)Messages.format(ActionMessages.OpenAction_error_messageArgs, new String[]{name, x.getMessage()}));
                }
            }
            ++i;
        }
    }

    public Object getElementToOpen(Object object) throws ModelException {
        return object;
    }

    private String getDialogTitle() {
        return ActionMessages.OpenAction_error_title;
    }

    private void showError(InvocationTargetException e) {
        ExceptionHandler.handle(e, this.getShell(), this.getDialogTitle(), ActionMessages.OpenAction_error_message);
    }
}

