/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.validators.core.IValidatorType;

public class ValidatorManager {
    private static final String LANGUAGE_EXTPOINT = "org.eclipse.dltk.validators.core.validator";
    private static final String NATURE_ATTR = "nature";
    private static Map validators;
    private static Map idToValidatorType;

    static {
        idToValidatorType = null;
    }

    public static IValidatorType getValidatorTypeFromID(String id) {
        if (idToValidatorType == null) {
            idToValidatorType = new HashMap();
            try {
                IValidatorType[] allValidatorTypes = ValidatorManager.getAllValidatorTypes();
                int i = 0;
                while (i < allValidatorTypes.length) {
                    idToValidatorType.put(allValidatorTypes[i].getID(), allValidatorTypes[i]);
                    ++i;
                }
            }
            catch (CoreException coreException) {
                idToValidatorType = null;
                return null;
            }
        }
        return (IValidatorType)idToValidatorType.get(id);
    }

    private static void initialize() {
        if (validators != null) {
            return;
        }
        validators = new HashMap(5);
        IConfigurationElement[] cfg = Platform.getExtensionRegistry().getConfigurationElementsFor(LANGUAGE_EXTPOINT);
        int i = 0;
        while (i < cfg.length) {
            List<IConfigurationElement> elements;
            String nature = cfg[i].getAttribute(NATURE_ATTR);
            if (validators.get(nature) != null) {
                elements = (List)validators.get(nature);
                elements.add(cfg[i]);
            } else {
                elements = new ArrayList();
                elements.add(cfg[i]);
                validators.put(nature, elements);
            }
            ++i;
        }
    }

    public static IValidatorType[] getValidators(String natureId) throws CoreException {
        ValidatorManager.initialize();
        ArrayList results = new ArrayList();
        ValidatorManager.processNature(natureId, results);
        ValidatorManager.processNature("#", results);
        return results.toArray(new IValidatorType[results.size()]);
    }

    private static void processNature(String natureId, List results) throws CoreException {
        block7: {
            Object ext;
            block8: {
                ext = validators.get(natureId);
                if (ext == null) break block7;
                if (!(ext instanceof IValidatorType[])) break block8;
                IValidatorType[] b = (IValidatorType[])ext;
                int i = 0;
                while (i < b.length) {
                    if (!results.contains(b[i])) {
                        results.add(b[i]);
                    }
                    ++i;
                }
                break block7;
            }
            if (!(ext instanceof List)) break block7;
            List elements = (List)ext;
            IValidatorType[] result = new IValidatorType[elements.size()];
            int i = 0;
            while (i < elements.size()) {
                Object e = elements.get(i);
                if (e instanceof IValidatorType) {
                    result[i] = (IValidatorType)e;
                } else {
                    IValidatorType builder;
                    IConfigurationElement cfg = (IConfigurationElement)e;
                    result[i] = builder = (IValidatorType)cfg.createExecutableExtension("class");
                }
                ++i;
            }
            validators.put(natureId, result);
            i = 0;
            while (i < result.length) {
                if (!results.contains(result[i])) {
                    results.add(result[i]);
                }
                ++i;
            }
        }
    }

    public static IValidatorType[] getAllValidatorTypes() throws CoreException {
        ValidatorManager.initialize();
        ArrayList<IValidatorType> result = new ArrayList<IValidatorType>();
        Iterator iterator = validators.keySet().iterator();
        while (iterator.hasNext()) {
            String nature = (String)iterator.next();
            IValidatorType[] b = ValidatorManager.getValidators(nature);
            int i = 0;
            while (i < b.length) {
                if (!result.contains(b[i])) {
                    result.add(b[i]);
                }
                ++i;
            }
        }
        return result.toArray(new IValidatorType[result.size()]);
    }
}

