/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;

public class ASTListNode
extends ASTNode {
    private final List nodes;

    public ASTListNode(int start, int end, List nodes) {
        super(start, end);
        this.nodes = nodes;
    }

    public ASTListNode(int start, int end) {
        super(start, end);
        this.nodes = new ArrayList();
    }

    public ASTListNode() {
        super(0, -1);
        this.nodes = new ArrayList();
    }

    public void addNode(ASTNode s) {
        if (s != null) {
            this.nodes.add(s);
        }
    }

    public List getChilds() {
        return this.nodes;
    }

    public List getExpressions() {
        return this.nodes;
    }

    public List getStatements() {
        return this.nodes;
    }

    public void setChilds(List l) {
        this.nodes.clear();
        this.nodes.addAll(l);
    }

    public int getKind() {
        return 0;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit(this)) {
            if (this.nodes != null) {
                Iterator iter = this.nodes.iterator();
                while (iter.hasNext()) {
                    ASTNode s = (ASTNode)iter.next();
                    s.traverse(visitor);
                }
            }
            visitor.endvisit(this);
        }
    }
}

