/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.core.BasicDLTKExtensionManager;

public class ClassBasedDLTKExtensionManager
extends BasicDLTKExtensionManager {
    private static final String CLASS_ATTR = "class";

    public ClassBasedDLTKExtensionManager(String extensionPoint) {
        super(extensionPoint);
    }

    public Object getObject(String natureId) {
        return this.getInitObject(this.getElementInfo(natureId));
    }

    public Object getInitObject(BasicDLTKExtensionManager.ElementInfo ext) {
        try {
            if (ext != null) {
                Object object;
                if (ext.object != null) {
                    return ext.object;
                }
                IConfigurationElement cfg = ext.config;
                ext.object = object = this.createObject(cfg);
                return object;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected Object createObject(IConfigurationElement cfg) throws CoreException {
        return cfg.createExecutableExtension(CLASS_ATTR);
    }

    public Object getObject(IModelElement element) {
        Object toolkit;
        if (element.getElementType() == 1) {
            return null;
        }
        IProject project = element.getScriptProject().getProject();
        String natureId = this.findScriptNature(project);
        if (natureId != null && (toolkit = this.getObject(natureId)) != null) {
            return toolkit;
        }
        return null;
    }

    public Object getObjectLower(String natureID) {
        BasicDLTKExtensionManager.ElementInfo ext = this.getElementInfo(natureID);
        if (ext.oldInfo == null) {
            return null;
        }
        return this.getInitObject(ext.oldInfo);
    }
}

