/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.breakpoints;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.debug.core.ScriptDebugManager;
import org.eclipse.dltk.debug.core.model.IScriptBreakpoint;
import org.eclipse.dltk.debug.ui.breakpoints.BreakpointMessages;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class ScriptBreakpointPropertyPage
extends PropertyPage {
    private Button enabledBreakpointButton;
    private Button hitCountCheckingButton;
    private Combo hitConditionCombo;
    private Text hitValueText;
    private SourceViewer expressionViewer;
    private Button enableExpressionButton;

    protected boolean getBreakointEnableState() {
        return this.enabledBreakpointButton.getSelection();
    }

    protected boolean getEnabledHitChecking() {
        return this.hitCountCheckingButton.getSelection();
    }

    protected void setEnabledHitChecking(boolean state) {
        this.hitCountCheckingButton.setSelection(state);
    }

    protected void setHitCondition(int condition) {
        this.hitConditionCombo.select(condition);
    }

    protected int getHitCondition() {
        return this.getEnabledHitChecking() ? this.hitConditionCombo.getSelectionIndex() : -1;
    }

    protected void setHitValue(int value) {
        this.hitValueText.setText(Integer.toString(value));
    }

    protected int getHitValue() {
        return this.getEnabledHitChecking() ? Integer.parseInt(this.hitValueText.getText()) : -1;
    }

    protected void setExpression(String expression) {
        this.expressionViewer.getDocument().set(expression);
    }

    protected String getExpression() {
        return this.expressionViewer.getDocument().get();
    }

    protected void setExpressionState(boolean state) {
        this.enableExpressionButton.setSelection(state);
    }

    protected boolean getExpressionState() {
        return this.enableExpressionButton.getSelection();
    }

    protected Composite createComposite(Composite parent, int numColumns) {
        Composite composit = new Composite(parent, 0);
        composit.setFont(parent.getFont());
        GridLayout layout = new GridLayout(numColumns, false);
        composit.setLayout((Layout)layout);
        composit.setLayoutData((Object)new GridData(768));
        return composit;
    }

    protected Button createRadioButton(Composite parent, String text) {
        Button button = new Button(parent, 16400);
        button.setText(text);
        button.setFont(parent.getFont());
        button.setLayoutData((Object)new GridData());
        return button;
    }

    protected Button createCheckButton(Composite parent, String text) {
        Button button = new Button(parent, 16416);
        button.setText(text);
        button.setFont(parent.getFont());
        button.setLayoutData((Object)new GridData());
        return button;
    }

    protected Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setFont(parent.getFont());
        label.setLayoutData((Object)new GridData());
        return label;
    }

    protected void createLabels(Composite parent) throws CoreException {
        IScriptBreakpoint breakpoint = this.getBreakpoint();
        Composite labelComposite = this.createComposite(parent, 2);
        this.createLabel(labelComposite, BreakpointMessages.LanguageLabel);
        this.createLabel(labelComposite, DLTKLanguageManager.getLanguageToolkit((String)this.getNatureId()).getLanguageName());
        String resourceName = breakpoint.getResourceName();
        if (resourceName != null) {
            this.createLabel(labelComposite, BreakpointMessages.FileLabel);
            this.createLabel(labelComposite, resourceName);
        }
        this.createLabel(labelComposite, BreakpointMessages.HitCountLabel);
        int hitCount = breakpoint.getHitCount();
        this.createLabel(labelComposite, hitCount == -1 ? BreakpointMessages.HitCountNotAvailableMessage : Integer.toString(hitCount));
        this.createTypeSpecificLabels(labelComposite);
    }

    protected void createTypeSpecificLabels(Composite parent) throws CoreException {
    }

    protected void createButtons(Composite parent) throws CoreException {
        Composite buttonsComposite = this.createComposite(parent, 1);
        this.enabledBreakpointButton = this.createCheckButton(buttonsComposite, BreakpointMessages.EnabledLabel);
        this.createTypeSpecificButtons(buttonsComposite);
    }

    protected void createTypeSpecificButtons(Composite parent) {
    }

    protected void createHitCountEditor(Composite parent) {
        Composite hitCountComposite = this.createComposite(parent, 4);
        this.hitCountCheckingButton = this.createCheckButton(hitCountComposite, BreakpointMessages.BreakWhenHitCountLabel);
        this.hitCountCheckingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScriptBreakpointPropertyPage.this.updateControlsState();
            }
        });
        this.hitConditionCombo = new Combo(hitCountComposite, 8);
        this.hitConditionCombo.add(BreakpointMessages.HitConditionGreaterOrEqual, 0);
        this.hitConditionCombo.add(BreakpointMessages.HitConditionEqual, 1);
        this.hitConditionCombo.add(BreakpointMessages.HitConditionMultiple, 2);
        this.hitConditionCombo.select(0);
        this.hitConditionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScriptBreakpointPropertyPage.this.updateControlsState();
            }
        });
        this.hitConditionCombo.setData((Object)new GridData());
        this.hitValueText = new Text(hitCountComposite, 2048);
        this.hitValueText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.hitValueText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ScriptBreakpointPropertyPage.this.updateControlsState();
            }
        });
        this.createLabel(hitCountComposite, BreakpointMessages.HitsLabel);
    }

    protected void createExpressionEditor(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        this.enableExpressionButton = new Button((Composite)group, 32);
        this.enableExpressionButton.setText(BreakpointMessages.UseConditionLabel);
        this.enableExpressionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScriptBreakpointPropertyPage.this.updateControlsState();
            }
        });
        this.expressionViewer = new ScriptSourceViewer((Composite)group, null, null, false, 2816, null);
        IDLTKUILanguageToolkit toolkit = DLTKUILanguageManager.getLanguageToolkit((String)this.getNatureId());
        Document document = new Document();
        toolkit.getTextTools().setupDocumentPartitioner((IDocument)document, toolkit.getPartitioningId());
        ScriptSourceViewerConfiguration config = toolkit.createSourceViwerConfiguration();
        this.expressionViewer.configure((SourceViewerConfiguration)config);
        this.expressionViewer.setDocument((IDocument)document);
        this.expressionViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    protected IScriptBreakpoint getBreakpoint() {
        return (IScriptBreakpoint)this.getElement();
    }

    protected String getNatureId() {
        ScriptDebugManager manager = ScriptDebugManager.getInstance();
        return manager.getNatureByDebugModel(this.getBreakpoint().getModelIdentifier());
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite composite = this.createComposite(parent, 1);
        try {
            this.createLabels(composite);
            this.createButtons(composite);
            if (this.hasHitCountEditor()) {
                this.createHitCountEditor(composite);
            }
            if (this.hasExpressionEditor()) {
                this.createExpressionEditor(composite);
            }
            this.loadValues();
            this.updateControlsState();
        }
        catch (CoreException coreException) {}
        return composite;
    }

    protected boolean hasHitCountEditor() {
        return true;
    }

    protected boolean hasExpressionEditor() {
        return true;
    }

    protected void loadValues() throws CoreException {
        IScriptBreakpoint breakpoint = this.getBreakpoint();
        this.enabledBreakpointButton.setSelection(breakpoint.isEnabled());
        if (this.hasHitCountEditor()) {
            int hitValue = breakpoint.getHitValue();
            if (hitValue != -1) {
                this.setHitValue(hitValue);
                this.setHitCondition(breakpoint.getHitCondition());
                this.setEnabledHitChecking(true);
            } else {
                this.setEnabledHitChecking(false);
            }
        }
        if (this.hasExpressionEditor()) {
            this.setExpressionState(breakpoint.getExpressionState());
            this.setExpression(breakpoint.getExpression());
        }
    }

    protected void saveValues() throws CoreException {
        IScriptBreakpoint breakpoint = this.getBreakpoint();
        breakpoint.setEnabled(this.getBreakointEnableState());
        if (this.hasHitCountEditor()) {
            breakpoint.setHitValue(this.getHitValue());
            breakpoint.setHitCondition(this.getHitCondition());
        }
        if (this.hasExpressionEditor()) {
            breakpoint.setExpression(this.getExpression());
            breakpoint.setExpressionState(this.getExpressionState());
        }
    }

    protected void updateControlsState() {
        if (this.hasHitCountEditor()) {
            boolean hitChecking = this.hitCountCheckingButton.getSelection();
            this.hitConditionCombo.setEnabled(hitChecking);
            this.hitValueText.setEnabled(hitChecking);
        }
        if (this.hasExpressionEditor()) {
            boolean expressionEnabled = this.enableExpressionButton.getSelection();
            Control control = this.expressionViewer.getControl();
            control.setEnabled(expressionEnabled);
        }
        this.validateValues();
    }

    protected void validateValues() {
        boolean valid = true;
        String errorMessage = null;
        if (this.hasHitCountEditor() && this.getEnabledHitChecking()) {
            try {
                this.getHitValue();
            }
            catch (NumberFormatException numberFormatException) {
                valid = false;
                errorMessage = BreakpointMessages.InvalidNumberOfHits;
            }
        }
        this.setValid(valid);
        this.setErrorMessage(errorMessage);
    }

    public boolean performOk() {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    ScriptBreakpointPropertyPage.this.saveValues();
                    DebugPlugin.getDefault().getBreakpointManager().fireBreakpointChanged((IBreakpoint)ScriptBreakpointPropertyPage.this.getBreakpoint());
                }
            }, null, 0, null);
        }
        catch (CoreException coreException) {}
        return super.performOk();
    }
}

