/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.search;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.internal.core.SourceMethod;

public class TclMatchLocator
extends MatchLocator {
    public TclMatchLocator(SearchPattern pattern, SearchRequestor requestor, IDLTKSearchScope scope, IProgressMonitor progressMonitor) {
        super(pattern, requestor, scope, progressMonitor);
    }

    protected IModelElement createMethodHandle(ISourceModule module, String methodName) {
        IMethod methodHandle = null;
        if (methodName.indexOf("::") != -1) {
            int pos = methodName.lastIndexOf("::");
            String cName = methodName.substring(0, pos);
            String name = methodName.substring(pos + 2);
            if (!cName.startsWith("$")) {
                cName = "$" + cName;
            }
            if (!(cName = cName.replaceAll("::", "\\$")).equals("$")) {
                IType type = null;
                try {
                    type = this.findTypeFrom(module.getChildren(), "", cName, '$');
                }
                catch (ModelException e) {
                    e.printStackTrace();
                }
                if (type != null) {
                    methodHandle = type.getMethod(name);
                }
            } else {
                methodHandle = module.getMethod(methodName);
            }
        } else {
            methodHandle = module.getMethod(methodName);
        }
        if (methodHandle instanceof SourceMethod) {
            while (this.methodHandles.contains(methodHandle)) {
                ++((SourceMethod)methodHandle).occurrenceCount;
            }
        }
        this.methodHandles.add(methodHandle);
        return methodHandle;
    }

    protected IModelElement createHandle(MethodDeclaration method, IModelElement parent) {
        if (parent instanceof IType) {
            IType type = (IType)parent;
            return this.createMethodHandle(type, new String(method.getName()));
        }
        if (parent instanceof ISourceModule) {
            if (method.getDeclaringTypeName() != null) {
                return this.createMethodHandle((ISourceModule)parent, String.valueOf(method.getDeclaringTypeName()) + "::" + method.getName());
            }
            return this.createMethodHandle((ISourceModule)parent, method.getName());
        }
        return null;
    }
}

