/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.tests.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IBuiltinModuleProvider;
import org.eclipse.dltk.debug.tests.AbstractDebugTest;
import org.eclipse.dltk.internal.launching.InterpreterContainer;
import org.eclipse.dltk.internal.launching.InterpreterContainerInitializer;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterStandin;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.launching.ScriptRuntime;

public class BuildpathContainerTests
extends AbstractDebugTest {
    public BuildpathContainerTests(String name) {
        super(name);
    }

    public void testCanUpdate() throws CoreException {
        IInterpreterInstall def = ScriptRuntime.getDefaultInterpreterInstall((String)"testnature");
        String InterpreterId = String.valueOf(def.getId()) + System.currentTimeMillis();
        InterpreterStandin standin = new InterpreterStandin(def.getInterpreterInstallType(), InterpreterId);
        String InterpreterName = "Alternate Interpreter";
        Path containerPath = new Path(ScriptRuntime.INTERPRETER_CONTAINER);
        containerPath = containerPath.append((IPath)new Path(def.getInterpreterInstallType().getId()));
        containerPath = containerPath.append((IPath)new Path(InterpreterName));
        standin.setName(InterpreterName);
        standin.setInstallLocation(def.getInstallLocation());
        standin.setLibraryLocations(ScriptRuntime.getLibraryLocations((IInterpreterInstall)def));
        standin.convertToRealInterpreter();
        IInterpreterInstall newInterpreter = def.getInterpreterInstallType().findInterpreterInstall(InterpreterId);
        BuildpathContainerTests.assertNotNull((String)"Failed to create new Interpreter", (Object)newInterpreter);
        InterpreterContainer container = new InterpreterContainer(newInterpreter, (IPath)containerPath);
        InterpreterContainerInitializer initializer = new InterpreterContainerInitializer();
        LibraryLocation[] originalLibs = ScriptRuntime.getLibraryLocations((IInterpreterInstall)newInterpreter);
        BuildpathContainerTests.assertTrue((String)"Libraries should not be empty", (originalLibs.length > 0 ? 1 : 0) != 0);
        IBuildpathEntry[] originalEntries = container.getBuildpathEntries();
        BuildpathContainerTests.assertEquals((String)"Libraries should be same size as buildpath entries", (int)originalLibs.length, (int)originalEntries.length);
        BuildpathContainerTests.assertTrue((String)"Initializer will not accept update", (boolean)initializer.canUpdateBuildpathContainer((IPath)containerPath, this.getScriptProject()));
        FakeContainer fakeContainer = new FakeContainer();
        initializer.requestBuildpathContainerUpdate((IPath)containerPath, this.getScriptProject(), (IBuildpathContainer)fakeContainer);
        LibraryLocation[] newLibs = ScriptRuntime.getLibraryLocations((IInterpreterInstall)newInterpreter);
        BuildpathContainerTests.assertEquals((String)"Libraries should be empty", (int)0, (int)newLibs.length);
        fakeContainer.setEntries(originalEntries);
        initializer.requestBuildpathContainerUpdate((IPath)containerPath, this.getScriptProject(), (IBuildpathContainer)fakeContainer);
        newLibs = ScriptRuntime.getLibraryLocations((IInterpreterInstall)newInterpreter);
        BuildpathContainerTests.assertEquals((String)"Libraries should be restored", (int)originalLibs.length, (int)newLibs.length);
        int i = 0;
        while (i < newLibs.length) {
            LibraryLocation location = newLibs[i];
            LibraryLocation origi = originalLibs[i];
            BuildpathContainerTests.assertEquals((String)"Library should be the eqaual", (Object)origi.getLibraryPath().toFile(), (Object)location.getLibraryPath().toFile());
            ++i;
        }
    }

    class FakeContainer
    implements IBuildpathContainer {
        IBuildpathEntry[] entries = new IBuildpathEntry[0];

        FakeContainer() {
        }

        public IBuildpathEntry[] getBuildpathEntries() {
            return this.entries;
        }

        public String getDescription() {
            return "Fake";
        }

        public int getKind() {
            return 3;
        }

        public IPath getPath() {
            return new Path(ScriptRuntime.INTERPRETER_CONTAINER);
        }

        public void setEntries(IBuildpathEntry[] cpe) {
            this.entries = cpe;
        }

        public IBuiltinModuleProvider getBuiltinProvider() {
            return null;
        }
    }
}

