/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.BuiltinProjectFragment;
import org.eclipse.dltk.internal.core.BuiltinSourceModule;
import org.eclipse.dltk.internal.core.ExternalProjectFragment;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.util.HandleFactory;

public class ValidatorUtils {
    private static HandleFactory factory = new HandleFactory();

    public static void processResourcesToElements(Object o, List elements, List resources) {
        if (o instanceof IResource) {
            ArrayList els = new ArrayList();
            ResourceVisitor visitor = new ResourceVisitor(els);
            try {
                ((IResource)o).accept((IResourceVisitor)visitor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            int i = 0;
            while (i < els.size()) {
                Object eo = ValidatorUtils.convertResourceToModelElement(els.get(i));
                if (eo != null) {
                    if (eo instanceof IModelElement && !elements.contains(eo)) {
                        elements.add(eo);
                    } else if (eo instanceof IResource && !resources.contains(eo)) {
                        resources.add(eo);
                    }
                }
                ++i;
            }
        } else if (o instanceof IModelElement) {
            if (o instanceof IParent) {
                SourceModuleVisitor visitor = new SourceModuleVisitor(elements);
                try {
                    ((IModelElement)o).accept((IModelElementVisitor)visitor);
                }
                catch (ModelException e) {
                    e.printStackTrace();
                }
            } else if (!(o instanceof ISourceModule)) {
                ISourceModule module = (ISourceModule)((IModelElement)o).getAncestor(5);
                if (elements.contains(module)) {
                    elements.add(module);
                }
            } else if (o instanceof ISourceModule && !elements.contains(o)) {
                elements.add(o);
            }
        }
    }

    private static Object convertResourceToModelElement(Object o) {
        if (o instanceof IModelElement) {
            return o;
        }
        if (!(o instanceof IResource)) {
            return null;
        }
        IResource res = (IResource)o;
        IProject project = res.getProject();
        if (!DLTKLanguageManager.hasScriptNature((IProject)project)) {
            return null;
        }
        IScriptProject scriptProject = DLTKCore.create((IProject)project);
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement[])new IModelElement[]{scriptProject});
        Openable element = factory.createOpenable(res.getFullPath().toString(), scope);
        if (element != null && element.getElementType() == 5 && element.exists()) {
            return element;
        }
        return res;
    }

    private static class ResourceVisitor
    implements IResourceVisitor {
        private List resources;

        public ResourceVisitor(List resources) {
            this.resources = resources;
        }

        public boolean visit(IResource resource) {
            if (!this.resources.contains(resource) && resource.getType() == 1) {
                this.resources.add(resource);
                return false;
            }
            return true;
        }
    }

    private static class SourceModuleVisitor
    implements IModelElementVisitor {
        private List elements;

        public SourceModuleVisitor(List elements) {
            this.elements = elements;
        }

        public boolean visit(IModelElement element) {
            if (element.getElementType() == 3 && (element instanceof ExternalProjectFragment || element instanceof BuiltinProjectFragment)) {
                return false;
            }
            if (element.getElementType() == 5 && !(element instanceof ExternalSourceModule) && !(element instanceof BuiltinSourceModule)) {
                if (!this.elements.contains(element)) {
                    this.elements.add(element);
                }
                return false;
            }
            return true;
        }
    }
}

