/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.ui;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.validators.core.IValidator;
import org.eclipse.dltk.validators.core.IValidatorType;
import org.eclipse.dltk.validators.core.ValidatorRuntime;
import org.eclipse.dltk.validators.internal.core.ValidatorDefinitionsContainer;
import org.eclipse.dltk.validators.internal.ui.ValidatorMessages;
import org.eclipse.dltk.validators.internal.ui.ValidatorsUI;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ValidatorUpdater {
    private ValidatorDefinitionsContainer fOriginalValidators;

    public ValidatorUpdater() {
        this.saveCurrentAsOriginal();
    }

    private void saveCurrentAsOriginal() {
        this.fOriginalValidators = new ValidatorDefinitionsContainer();
        IValidatorType[] types = ValidatorRuntime.getValidatorTypes();
        int i = 0;
        while (i < types.length) {
            IValidator[] validators = types[i].getValidators();
            if (validators != null) {
                int j = 0;
                while (j < validators.length) {
                    this.fOriginalValidators.addValidator(validators[j]);
                    ++j;
                }
            }
            ++i;
        }
    }

    public boolean updateValidatorSettings(IValidator[] validatorEnvironments) {
        ValidatorDefinitionsContainer validatorContainer = new ValidatorDefinitionsContainer();
        int i = 0;
        while (i < validatorEnvironments.length) {
            validatorContainer.addValidator(validatorEnvironments[i]);
            ++i;
        }
        this.saveValidatorDefinitions(validatorContainer);
        this.saveCurrentAsOriginal();
        return true;
    }

    private void saveValidatorDefinitions(final ValidatorDefinitionsContainer container) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask(ValidatorMessages.ValidatorUpdater_0, 100);
                        String ValidatorDefXML = container.getAsXML();
                        monitor.worked(40);
                        ValidatorRuntime.getPreferences().setValue("org.eclipse.dltk.validators.core.PREF_VALIDATOR_XML", ValidatorDefXML);
                        monitor.worked(30);
                        ValidatorRuntime.savePreferences();
                        monitor.worked(30);
                    }
                    catch (IOException ioe) {
                        ValidatorsUI.log(ioe);
                    }
                    catch (ParserConfigurationException e) {
                        ValidatorsUI.log(e);
                    }
                    catch (TransformerException e) {
                        ValidatorsUI.log(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_7 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_8 = null;
                }
                monitor.done();
            }
        };
        try {
            ValidatorsUI.getDefault().getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            ValidatorsUI.log(e);
        }
        catch (InterruptedException e) {
            ValidatorsUI.log(e);
        }
    }
}

